"use strict";
(function(){
// Generated by CoffeeScript 1.7.1
var Steam, after, always, apply, at, clear, clone, cloneDeep, compact, compose, concat, constant, contains, copy, countBy, curry, debounce, defaults, defer, delay, describeCount, difference, escape, every, extend, filter, find, findIndex, findKey, findLast, findLastIndex, findLastKey, flatten, forEach, forEachRight, forIn, forInRight, forOwn, forOwnRight, functions, groupBy, has, head, identity, indexBy, indexOf, initial, intersection, invert, isArguments, isArray, isBoolean, isDate, isDefined, isElement, isEmpty, isEqual, isError, isFalsy, isFinite, isFunction, isInteger, isNaN, isNull, isNumber, isObject, isPlainObject, isRegExp, isString, isTruthy, isUndefined, join, keys, last, lastIndexOf, luid, map, mapValues, mapWithKey, max, memoize, merge, min, negate, never, noop, now, omit, once, pairs, partial, partialRight, pick, pluck, pop, property, pull, push, pushAll, random, range, reduce, reduceRight, reject, remove, removeWhere, repeat, same, sample, shift, shuffle, size, some, sort, sortBy, sortedIndex, splice, split, tail, throttle, times, toArray, transform, unescape, union, unique, uniqueId, unshift, unshiftAll, values, valuesAreEqual, where, without, words, wrap, xor, zip, zipCompare, zipObject,
  __slice = [].slice;

Steam = typeof exports !== "undefined" && exports !== null ? exports : this.Steam = {};

compact = _.compact;

difference = _.difference;

findIndex = _.findIndex;

findLastIndex = _.findLastIndex;

flatten = _.flatten;

head = _.head;

indexOf = _.indexOf;

initial = _.initial;

intersection = _.intersection;

last = _.last;

lastIndexOf = _.lastIndexOf;

pull = _.pull;

range = _.range;

removeWhere = _.remove;

sortedIndex = _.sortedIndex;

tail = _.tail;

union = _.union;

unique = _.unique;

without = _.without;

xor = _.xor;

zip = _.zip;

zipObject = _.zipObject;

at = _.at;

contains = _.contains;

countBy = _.countBy;

every = _.every;

filter = _.filter;

find = _.find;

findLast = _.findLast;

forEach = _.forEach;

forEachRight = _.forEachRight;

groupBy = _.groupBy;

indexBy = _.indexBy;

map = _.map;

max = _.max;

min = _.min;

pluck = _.pluck;

reduce = _.reduce;

reduceRight = _.reduceRight;

reject = _.reject;

sample = _.sample;

shuffle = _.shuffle;

size = _.size;

some = _.some;

sortBy = _.sortBy;

toArray = _.toArray;

where = _.where;

after = _.after;

compose = _.compose;

curry = _.curry;

debounce = _.debounce;

defer = _.defer;

delay = _.delay;

memoize = _.memoize;

once = _.once;

partial = _.partial;

partialRight = _.partialRight;

throttle = _.throttle;

wrap = _.wrap;

clone = _.clone;

cloneDeep = _.cloneDeep;

defaults = _.defaults;

extend = _.extend;

findKey = _.findKey;

findLastKey = _.findLastKey;

forIn = _.forIn;

forInRight = _.forInRight;

forOwn = _.forOwn;

forOwnRight = _.forOwnRight;

functions = _.functions;

has = _.has;

invert = _.invert;

isArguments = _.isArguments;

isArray = _.isArray;

isBoolean = _.isBoolean;

isDate = _.isDate;

isElement = _.isElement;

isEmpty = _.isEmpty;

isEqual = _.isEqual;

isFinite = _.isFinite;

isFunction = _.isFunction;

isNaN = _.isNaN;

isNull = _.isNull;

isNumber = _.isNumber;

isInteger = function(value) {
  return (isNumber(value)) && value % 1 === 0;
};

isObject = _.isObject;

isPlainObject = _.isPlainObject;

isRegExp = _.isRegExp;

isString = _.isString;

isUndefined = _.isUndefined;

keys = _.keys;

mapValues = _.mapValues;

merge = _.merge;

omit = _.omit;

pairs = _.pairs;

pick = _.pick;

transform = _.transform;

values = _.values;

now = _.now;

constant = _.constant;

escape = _.escape;

identity = _.identity;

noop = _.noop;

property = _.property;

random = _.random;

times = _.times;

unescape = _.unescape;

uniqueId = _.uniqueId;

apply = function(func, args) {
  return func.apply(null, args);
};

isDefined = function(value) {
  return !isUndefined(value);
};

isTruthy = function(value) {
  if (value) {
    return true;
  } else {
    return false;
  }
};

isFalsy = function(value) {
  if (value) {
    return false;
  } else {
    return true;
  }
};

isError = function(value) {
  return value instanceof Error;
};

negate = function(value) {
  return !value;
};

always = function() {
  return true;
};

never = function() {
  return false;
};

join = function(array, delimiter) {
  return array.join(delimiter);
};

split = function(text, delimiter) {
  return text.split(delimiter);
};

words = function(text) {
  return split(text, /\s+/);
};

sort = function(array, comparator) {
  return array.sort(comparator);
};

copy = function(array) {
  return array.slice(0);
};

concat = function() {
  var array, arrays;
  array = arguments[0], arrays = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
  return array.concat.apply(array, arrays);
};

unshift = function(array, arg) {
  array.unshift(arg);
  return array;
};

unshiftAll = function(array, elements) {
  array.splice.apply(array, [0, 0].concat(elements));
  return array;
};

shift = function(array) {
  return array.shift();
};

push = function(array, arg) {
  array.push(arg);
  return array;
};

pushAll = function(array, elements) {
  var element, _i, _len;
  for (_i = 0, _len = elements.length; _i < _len; _i++) {
    element = elements[_i];
    array.push(element);
  }
  return array;
};

pop = function(array) {
  return array.pop();
};

splice = function() {
  var args, array;
  array = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
  return array.splice.apply(array, args);
};

remove = function(array, element) {
  var index;
  if (-1 < (index = array.indexOf(element))) {
    return head(array.splice(index, 1));
  } else {
    return void 0;
  }
};

clear = function(array) {
  array.length = 0;
  return array;
};

repeat = function(count, value) {
  var array, i, _i;
  array = [];
  for (i = _i = 0; 0 <= count ? _i < count : _i > count; i = 0 <= count ? ++_i : --_i) {
    array.push(value);
  }
  return array;
};

zipCompare = function(array1, array2, areEqual) {
  var a, b, i, _i, _j, _len, _len1;
  if (!isArray(array1)) {
    return false;
  }
  if (!isArray(array2)) {
    return false;
  }
  if (array1.length !== array2.length) {
    return false;
  }
  if (areEqual) {
    for (i = _i = 0, _len = array1.length; _i < _len; i = ++_i) {
      a = array1[i];
      b = array2[i];
      if (!areEqual(a, b)) {
        return false;
      }
    }
  } else {
    for (i = _j = 0, _len1 = array1.length; _j < _len1; i = ++_j) {
      a = array1[i];
      b = array2[i];
      if (a !== b) {
        return false;
      }
    }
  }
  return true;
};

same = function(array, areEqual) {
  var i, value, _i, _j, _ref, _ref1;
  if (array.length > 1) {
    value = head(array);
    if (isFunction(areEqual)) {
      for (i = _i = 1, _ref = array.length; 1 <= _ref ? _i < _ref : _i > _ref; i = 1 <= _ref ? ++_i : --_i) {
        if (!areEqual(value, array[i])) {
          return false;
        }
      }
    } else {
      for (i = _j = 1, _ref1 = array.length; 1 <= _ref1 ? _j < _ref1 : _j > _ref1; i = 1 <= _ref1 ? ++_j : --_j) {
        if (value !== array[i]) {
          return false;
        }
      }
    }
    return true;
  } else {
    return true;
  }
};

valuesAreEqual = function(array, pluck, areEqual) {
  var i, value, _i, _j, _ref, _ref1;
  if (array.length > 1) {
    value = pluck(head(array));
    if (isFunction(areEqual)) {
      for (i = _i = 1, _ref = array.length; 1 <= _ref ? _i < _ref : _i > _ref; i = 1 <= _ref ? ++_i : --_i) {
        if (!areEqual(value, pluck(array[i]))) {
          return false;
        }
      }
    } else {
      for (i = _j = 1, _ref1 = array.length; 1 <= _ref1 ? _j < _ref1 : _j > _ref1; i = 1 <= _ref1 ? ++_j : --_j) {
        if (value !== pluck(array[i])) {
          return false;
        }
      }
    }
    return true;
  } else {
    return true;
  }
};

mapWithKey = function(obj, map) {
  var key, result, value;
  result = [];
  for (key in obj) {
    value = obj[key];
    result.push(map(value, key));
  }
  return result;
};

describeCount = function(count, singular, plural) {
  if (!plural) {
    plural = singular + 's';
  }
  switch (count) {
    case 0:
      return "No " + plural;
    case 1:
      return "1 " + singular;
    default:
      return "" + count + " " + plural;
  }
};

luid = function() {
  var d;
  d = new Date().getTime();
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
    var r;
    r = (d + Math.random() * 16) % 16 | 0;
    d = Math.floor(d / 16);
    return (c === 'x' ? r : r & 0x7 | 0x8).toString(16);
  });
};
// Generated by CoffeeScript 1.7.1
var T,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  __slice = [].slice;

Steam.Typedef = (function() {
  var Builtin, Reference, Struct, Type, builtinChecks, isBuiltin, t_any, t_array, t_boolean, t_check, t_checkBuiltin, t_checkEnum, t_checkReference, t_checkStruct, t_date, t_dump, t_error, t_function, t_number, t_object, t_primitive, t_regexp, t_string, t_tuple, t_union, typedef;
  Type = (function() {
    function Type() {}

    return Type;

  })();
  Builtin = (function(_super) {
    __extends(Builtin, _super);

    function Builtin(name, checks, inspect) {
      this.name = name;
      this.checks = checks;
      this.inspect = inspect;
    }

    return Builtin;

  })(Type);
  Reference = (function(_super) {
    __extends(Reference, _super);

    function Reference(name, type, checks) {
      this.name = name;
      this.type = type;
      this.checks = checks;
      this.inspect = __bind(this.inspect, this);
    }

    Reference.prototype.inspect = function() {
      var description;
      description = {};
      description[this.name] = this.type.inspect();
      return description;
    };

    return Reference;

  })(Type);
  Struct = (function(_super) {
    __extends(Struct, _super);

    function Struct(name, definition, checks) {
      this.name = name;
      this.definition = definition;
      this.checks = checks;
      this.inspect = __bind(this.inspect, this);
    }

    Struct.prototype.inspect = function() {
      var description, k, struct, v, _ref;
      description = {};
      description[this.name] = struct = {};
      _ref = this.definition;
      for (k in _ref) {
        v = _ref[k];
        struct[k] = v.inspect();
      }
      return description;
    };

    return Struct;

  })(Type);
  builtinChecks = {
    'Any': function() {
      return true;
    },
    'Number': isNumber,
    'String': isString,
    'Boolean': isBoolean,
    'Function': isFunction,
    'Error': isError,
    'Date': isDate,
    'RegExp': isRegExp,
    'Object': isObject
  };
  t_checkEnum = function(validValues) {
    return function(value) {
      var validValue, _i, _len;
      for (_i = 0, _len = validValues.length; _i < _len; _i++) {
        validValue = validValues[_i];
        if (value === validValue) {
          return null;
        }
      }
      return "Enum value [" + value + "] does not match one of [" + (validValues.join(', ')) + "]";
    };
  };
  t_checkBuiltin = function(value, type) {
    var check, error, errors, _i, _len, _ref;
    errors = [];
    _ref = type.checks;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      check = _ref[_i];
      if (error = check(value)) {
        errors.push(error);
      }
    }
    if (errors.length > 0) {
      return errors;
    } else {
      return null;
    }
  };
  t_checkReference = function(value, type) {
    var check, error, errors, _i, _len, _ref;
    errors = [];
    if (error = t_check(value, type.type)) {
      errors.push(error);
    }
    _ref = type.checks;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      check = _ref[_i];
      if (error = check(value)) {
        errors.push(error);
      }
    }
    if (errors.length > 0) {
      return errors;
    } else {
      return null;
    }
  };
  t_checkStruct = function(value, type) {
    var attributeName, attributeType, attributeValue, check, error, errors, _i, _len, _ref, _ref1;
    errors = [];
    _ref = type.definition;
    for (attributeName in _ref) {
      attributeType = _ref[attributeName];
      if ((isObject(value)) && attributeName in value) {
        attributeValue = value[attributeName];
        if (error = t_check(attributeValue, attributeType)) {
          errors.push(error);
        }
      } else {
        errors.push("Required attribute [" + attributeName + "] not found.");
      }
    }
    _ref1 = type.checks;
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      check = _ref1[_i];
      if (error = check(value)) {
        errors.push(error);
      }
    }
    if (errors.length > 0) {
      return errors;
    } else {
      return null;
    }
  };
  t_check = function(value, type) {
    if (type instanceof Builtin) {
      return t_checkBuiltin(value, type);
    } else if (type instanceof Reference) {
      return t_checkReference(value, type);
    } else if (type instanceof Struct) {
      return t_checkStruct(value, type);
    } else {
      throw new Error("Unknown type [" + type + "]");
    }
  };
  t_primitive = function(name, args) {
    var arg, check, checks, primitiveCheck, value, _i, _j, _len, _len1;
    primitiveCheck = builtinChecks[name];
    check = function(value) {
      if (primitiveCheck(value)) {
        return null;
      } else {
        return "[" + value + "] is not a " + name;
      }
    };
    checks = [check];
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      arg = args[_i];
      if (isArray(arg)) {
        for (_j = 0, _len1 = arg.length; _j < _len1; _j++) {
          value = arg[_j];
          if (!primitiveCheck(value)) {
            throw new Error("Enum value [" + value + "] is not a " + name);
          }
        }
        checks.push(t_checkEnum(arg));
      } else if (isFunction(arg)) {
        checks.push(arg);
      } else {
        throw new Error("Invalid type arg [" + arg + "]");
      }
    }
    return new Builtin(name, checks, function() {
      return name;
    });
  };
  t_any = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Any', args);
  };
  t_number = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Number', args);
  };
  t_string = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('String', args);
  };
  t_boolean = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Boolean', args);
  };
  t_function = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Function', args);
  };
  t_error = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Error', args);
  };
  t_date = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Date', args);
  };
  t_regexp = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('RegExp', args);
  };
  t_object = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Object', args);
  };
  isBuiltin = function(f) {
    return f === t_any || f === t_number || f === t_string || f === t_boolean || f === t_function || f === t_error || f === t_date || f === t_regexp || f === t_object;
  };
  t_array = function() {
    var arg, args, checks, type, types, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    types = [];
    checks = [];
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      arg = args[_i];
      if (arg instanceof Type) {
        types.push(arg);
      } else if (isFunction(arg)) {
        if (isBuiltin(arg)) {
          types.push(arg());
        } else {
          checks.push(arg);
        }
      } else {
        throw new Error("Invalid arg [" + arg + "]");
      }
    }
    if (types.length > 0) {
      type = t_union.apply(null, types);
      checks.unshift(function(array) {
        var element, error, errors, index, _j, _len1;
        errors = [];
        if (isArray(array)) {
          for (index = _j = 0, _len1 = array.length; _j < _len1; index = ++_j) {
            element = array[index];
            if (error = t_check(element, type)) {
              errors.push("Array[" + index + "]: " + error);
            }
          }
        } else {
          errors.push("[" + array + "] is not an Array");
        }
        if (errors.length > 0) {
          return errors;
        } else {
          return null;
        }
      });
    } else {
      throw new Error("Array type not specified");
    }
    return new Builtin('Array', checks, function() {
      return "Array[" + (type.inspect()) + "]";
    });
  };
  t_union = function() {
    var arg, args, checks, types, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    if (args.length === 0) {
      throw new Error("Variant types not specified");
    } else if (args.length === 1) {
      arg = head(args);
      if (isBuiltin(arg)) {
        return arg();
      } else if (arg instanceof Type) {
        return arg;
      } else {
        throw new Error("Invalid arg [" + arg + "]");
      }
    } else {
      types = [];
      checks = [];
      for (_i = 0, _len = args.length; _i < _len; _i++) {
        arg = args[_i];
        if (isBuiltin(arg)) {
          types.push(arg());
        } else if (arg instanceof Type) {
          types.push(arg);
        } else if (isFunction(arg)) {
          checks.push(arg);
        } else {
          throw new Error("Invalid type arg [" + arg + "]");
        }
      }
      checks.unshift(function(value) {
        var error, errors, matched, type, _j, _len1;
        errors = [];
        matched = false;
        for (_j = 0, _len1 = types.length; _j < _len1; _j++) {
          type = types[_j];
          if (error = t_check(value, type)) {
            errors.push(error);
          } else {
            matched = true;
            break;
          }
        }
        if (matched) {
          return null;
        } else {
          return map(errors, function(error) {
            return "Variant [" + value + "]: " + error;
          });
        }
      });
      return new Builtin('Variant', checks, function() {
        return "" + (types.map(function(type) {
          return type.inspect();
        }).join('|'));
      });
    }
  };
  t_tuple = function() {
    var arg, args, checks, types, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    types = [];
    checks = [];
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      arg = args[_i];
      if (isBuiltin(arg)) {
        types.push(arg());
      } else if (arg instanceof Type) {
        types.push(arg);
      } else if (isFunction(arg)) {
        checks.push(arg);
      } else {
        throw new Error("Invalid arg [" + arg + "]");
      }
    }
    if (types.length > 0) {
      checks.unshift(function(tuple) {
        var error, errors, index, type, value, _j, _len1;
        if (isArray(tuple)) {
          errors = [];
          for (index = _j = 0, _len1 = types.length; _j < _len1; index = ++_j) {
            type = types[index];
            value = tuple[index];
            if (error = t_check(value, type)) {
              errors.push("Tuple[" + index + "]: " + error);
            }
          }
          if (tuple.length !== types.length) {
            errors.push("Invalid tuple length. Expected " + types.length + ". Got " + tuple.length);
          }
          if (errors.length > 0) {
            return errors;
          } else {
            return null;
          }
        } else {
          return "Value [" + tuple + "] is not a Tuple";
        }
      });
      return new Builtin('Tuple', checks, function() {
        return "Tuple[" + (types.map(function(type) {
          return type.inspect();
        }).join(', ')) + "]";
      });
    } else {
      throw new Error("Tuple types not specified");
    }
  };
  t_dump = function(arg) {
    var dump, lines, tab;
    tab = '  ';
    dump = function(lines, offset, arg) {
      var indent, item, _i, _len;
      if (isArray(arg)) {
        indent = offset + tab;
        for (_i = 0, _len = arg.length; _i < _len; _i++) {
          item = arg[_i];
          dump(lines, indent, item);
        }
      } else if (isString(arg)) {
        lines.push(offset + arg);
      }
    };
    dump(lines = [], '', arg);
    return lines;
  };
  typedef = function() {
    var arg, attr, attrType, checks, definition, name, specification, _ref;
    specification = arguments[0], checks = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
    _ref = head(pairs(specification)), name = _ref[0], arg = _ref[1];
    if (isBuiltin(arg)) {
      return new Reference(name, arg(), checks);
    } else if (arg instanceof Type) {
      return new Reference(name, arg, checks);
    } else if (isFunction(arg)) {
      throw new Error("Arbitrary functions not allowed on structs");
    } else if (isObject(arg)) {
      definition = {};
      for (attr in arg) {
        attrType = arg[attr];
        if (isBuiltin(attrType)) {
          definition[attr] = attrType();
        } else if (isArray(attrType)) {
          definition[attr] = t_union.apply(null, attrType);
        } else if (attrType instanceof Type) {
          definition[attr] = attrType;
        } else {
          throw new Error("Unrecognized type [" + attr + "] : [" + attrType + "]");
        }
      }
      return new Struct(name, definition, checks);
    } else {
      throw new Error("Invalid arg [" + arg + "]");
    }
  };
  typedef.any = t_any;
  typedef.num = t_number;
  typedef.str = t_string;
  typedef.bool = t_boolean;
  typedef.func = t_function;
  typedef.err = t_error;
  typedef.date = t_date;
  typedef.regexp = t_regexp;
  typedef.arr = t_array;
  typedef.obj = t_object;
  typedef.union = t_union;
  typedef.tuple = t_tuple;
  typedef.check = t_check;
  typedef.dump = t_dump;
  return typedef;
})();

T = Steam.Typedef;
// Generated by CoffeeScript 1.7.1
var and$, apply$, call$, context$, debounce$, edge$, edges$, filter$, if$, isNode$, join$, lift$, link$, node$, nodes$, not$, or$, switch$, throttle$, unlink$, zip$, _ref,
  __slice = [].slice;

Steam.Hypergraph = (function() {
  var applyOnChange, callOnChange, createContext, createEdge, createHyperedge, createNode, createObservable, createObservableArray, createPolynode, debounceNode, filterNode, isNode, isObservable, joinNodes, liftNodes, link, switchNodes, throttleNode, unlink, zipNodes, _apply;
  createEdge = function() {
    var arrow, self;
    arrow = null;
    self = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (arrow) {
        return apply(arrow.func, args);
      } else {
        return void 0;
      }
    };
    self.subscribe = function(func) {
      console.assert(isFunction(func));
      if (arrow) {
        throw new Error('Cannot re-attach edge');
      } else {
        return arrow = {
          func: func,
          dispose: function() {
            return arrow = null;
          }
        };
      }
    };
    self.dispose = function() {
      if (arrow) {
        return arrow.dispose();
      }
    };
    return self;
  };
  createHyperedge = function() {
    var arrows, self;
    arrows = [];
    self = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return map(arrows, function(arrow) {
        return apply(arrow.func, args);
      });
    };
    self.subscribe = function(func) {
      var arrow;
      console.assert(isFunction(func));
      arrows.push(arrow = {
        func: func,
        dispose: function() {
          return remove(arrows, arrow);
        }
      });
      return arrow;
    };
    self.dispose = function() {
      return forEach(copy(arrows), function(arrow) {
        return arrow.dispose();
      });
    };
    return self;
  };
  if (typeof ko !== "undefined" && ko !== null) {
    createObservable = ko.observable;
    createObservableArray = ko.observableArray;
    isObservable = ko.isObservable;
  } else {
    createObservable = function(initialValue) {
      var arrows, currentValue, notifySubscribers, self;
      arrows = [];
      currentValue = initialValue;
      notifySubscribers = function(arrows, newValue) {
        var arrow, _i, _len;
        for (_i = 0, _len = arrows.length; _i < _len; _i++) {
          arrow = arrows[_i];
          arrow.func(newValue);
        }
      };
      self = function(newValue) {
        var unchanged;
        if (arguments.length === 0) {
          return currentValue;
        } else {
          unchanged = self.equalityComparer ? self.equalityComparer(currentValue, newValue) : currentValue === newValue;
          if (!unchanged) {
            currentValue = newValue;
            return notifySubscribers(arrows, newValue);
          }
        }
      };
      self.subscribe = function(func) {
        var arrow;
        console.assert(isFunction(func));
        arrows.push(arrow = {
          func: func,
          dispose: function() {
            return remove(arrows, arrow);
          }
        });
        return arrow;
      };
      self.__observable__ = true;
      return self;
    };
    createObservableArray = createObservable;
    isObservable = function(obj) {
      if (obj.__observable__) {
        return true;
      } else {
        return false;
      }
    };
  }
  createNode = function(value, equalityComparer) {
    var observable;
    if (arguments.length === 0) {
      return createNode(void 0, never);
    } else {
      observable = createObservable(value);
      if (isFunction(equalityComparer)) {
        observable.equalityComparer = equalityComparer;
      }
      return observable;
    }
  };
  isNode = isObservable;
  createPolynode = function(array) {
    return createObservableArray(array || []);
  };
  createContext = function(edges, parent) {
    var context, edge, name;
    if (parent == null) {
      parent = null;
    }
    context = {
      root: null,
      parent: null
    };
    if (parent) {
      console.assert(isDefined(parent.root));
      context.root = parent.root;
      context.parent = parent;
    } else {
      context.root = context.parent = context;
    }
    for (name in edges) {
      edge = edges[name];
      console.assert(isFunction(edge));
      console.assert(!(name in context));
      context[name] = edge;
    }
    return context;
  };
  link = function(node, func) {
    console.assert(isFunction(node, '[node] is not a function'));
    console.assert(isFunction(node.subscribe, '[node] does not have a [dispose] method'));
    console.assert(isFunction(func, '[func] is not a function'));
    return node.subscribe(func);
  };
  unlink = function(arrows) {
    var arrow, _i, _len, _results;
    if (isArray(arrows)) {
      _results = [];
      for (_i = 0, _len = arrows.length; _i < _len; _i++) {
        arrow = arrows[_i];
        console.assert(isFunction(arrow.dispose, '[arrow] does not have a [dispose] method'));
        _results.push(arrow.dispose());
      }
      return _results;
    } else {
      console.assert(isFunction(arrows.dispose, '[arrow] does not have a [dispose] method'));
      return arrows.dispose();
    }
  };
  _apply = function(sources, func) {
    return apply(func, map(sources, function(source) {
      return source();
    }));
  };
  callOnChange = function() {
    var func, sources, _i;
    sources = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), func = arguments[_i++];
    func();
    return map(sources, function(source) {
      return link(source, function() {
        return func();
      });
    });
  };
  applyOnChange = function() {
    var func, sources, _i;
    sources = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), func = arguments[_i++];
    _apply(sources, func);
    return map(sources, function(source) {
      return link(source, function() {
        return _apply(sources, func);
      });
    });
  };
  joinNodes = function() {
    var func, sources, target, _i;
    sources = 3 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 2) : (_i = 0, []), target = arguments[_i++], func = arguments[_i++];
    console.assert(isFunction(target, '[target] is not a function'));
    target(_apply(sources, func));
    return map(sources, function(source) {
      return link(source, function() {
        return target(_apply(sources, func));
      });
    });
  };
  zipNodes = function(sources, func) {
    var evaluate, target;
    evaluate = function() {
      return _apply(sources, func);
    };
    target = createNode(evaluate());
    map(sources, function(source) {
      return link(source, function() {
        return target(evaluate());
      });
    });
    return target;
  };
  liftNodes = function() {
    var func, sources, _i;
    sources = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), func = arguments[_i++];
    return zipNodes(sources, func);
  };
  filterNode = function(source, predicate) {
    var target, value;
    target = createNode(predicate(value = source()) ? value : void 0);
    link(source, function(value) {
      if (predicate(value)) {
        return target(value);
      }
    });
    return target;
  };
  switchNodes = function(defaultValue, count) {
    var choices, i, _i;
    choices = [];
    for (i = _i = 0; 0 <= count ? _i < count : _i > count; i = 0 <= count ? ++_i : --_i) {
      choices.push(node$(defaultValue, function(a, b) {
        return a === b;
      }));
    }
    forEach(choices, function(source) {
      return link(source, function(value) {
        var target, _j, _len;
        if (value !== defaultValue) {
          for (i = _j = 0, _len = choices.length; _j < _len; i = ++_j) {
            target = choices[i];
            if (source !== target) {
              target(defaultValue);
            }
          }
        }
      });
    });
    return choices;
  };
  debounceNode = function(source, wait, options) {
    var target;
    target = createNode(void 0);
    link(source, debounce(target, wait, options));
    return target;
  };
  throttleNode = function(source, wait, options) {
    var target;
    target = createNode(void 0);
    link(source, throttle(target, wait, options));
    return target;
  };
  return {
    createEdge: createEdge,
    createHyperedge: createHyperedge,
    createNode: createNode,
    isNode: isNode,
    createPolynode: createPolynode,
    createContext: createContext,
    link: link,
    unlink: unlink,
    callOnChange: callOnChange,
    applyOnChange: applyOnChange,
    joinNodes: joinNodes,
    zipNodes: zipNodes,
    liftNodes: liftNodes,
    filterNode: filterNode,
    switchNodes: switchNodes,
    debounceNode: debounceNode,
    throttleNode: throttleNode
  };
})();

_ref = Steam.Hypergraph, edge$ = _ref.createEdge, edges$ = _ref.createHyperedge, node$ = _ref.createNode, isNode$ = _ref.isNode, nodes$ = _ref.createPolynode, context$ = _ref.createContext, link$ = _ref.link, unlink$ = _ref.unlink, call$ = _ref.callOnChange, apply$ = _ref.applyOnChange, join$ = _ref.joinNodes, zip$ = _ref.zipNodes, lift$ = _ref.liftNodes, filter$ = _ref.filterNode, switch$ = _ref.switchNodes, debounce$ = _ref.debounceNode, throttle$ = _ref.throttleNode;

if$ = function(condition, valueIfTrue, valueIfFalse) {
  return zip$([condition, valueIfTrue, valueIfFalse], function(c, t, f) {
    if (c) {
      return t;
    } else {
      return f;
    }
  });
};

and$ = function() {
  var sources;
  sources = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
  return zip$(sources, function() {
    var values;
    values = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return every(values);
  });
};

or$ = function() {
  var sources;
  sources = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
  return zip$(sources, function() {
    var values;
    values = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return some(values);
  });
};

not$ = function(source) {
  return zip$([source], negate);
};
// Generated by CoffeeScript 1.7.1
var geyser,
  __slice = [].slice;

geyser = (function() {
  var GeyserNode, GeyserTag, createTag, generate, getOrCreateTag, parseTagSpec, render, _tagCache;
  _tagCache = {};
  GeyserTag = (function() {
    function GeyserTag(name, classes, attrs) {
      this.name = name;
      this.classes = classes;
      this.attrs = attrs;
    }

    return GeyserTag;

  })();
  GeyserNode = (function() {
    function GeyserNode(tag, params, content) {
      this.tag = tag;
      this.params = params;
      this.content = content;
    }

    return GeyserNode;

  })();
  createTag = function(tagSpec, attrSpec) {
    var classes, tag, _ref;
    switch (tagSpec.indexOf('.')) {
      case -1:
        return new GeyserTag(tagSpec, null, attrSpec);
      case 0:
        return new GeyserTag('div', ((tagSpec.substr(1)).split('.')).join(' '), attrSpec);
      default:
        _ref = tagSpec.split('.'), tag = _ref[0], classes = 2 <= _ref.length ? __slice.call(_ref, 1) : [];
        return new GeyserTag(tag, classes.join(' '), attrSpec);
    }
  };
  parseTagSpec = function(spec) {
    var i;
    if (-1 === (i = spec.indexOf(' '))) {
      return createTag(spec, null);
    } else {
      return createTag(spec.substr(0, i), spec.substr(i + 1));
    }
  };
  getOrCreateTag = function(spec) {
    var tag;
    if (tag = _tagCache[spec]) {
      return tag;
    } else {
      return _tagCache[spec] = parseTagSpec(spec);
    }
  };
  generate = function() {
    var specs;
    specs = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    if (specs.length === 1 && isArray(head(specs))) {
      specs = head(specs);
    }
    return map(specs, function(spec) {
      var tag;
      tag = getOrCreateTag(spec);
      return function(arg, params) {
        return new GeyserNode(tag, params, isArray(arg) ? arg : arg instanceof GeyserNode ? [arg] : arg);
      };
    });
  };
  render = function(arg) {
    var attrs, classes, content, id, k, name, tag, v, _ref;
    if (arg instanceof GeyserNode) {
      id = arg.id ? " id='" + arg.id + "'" : '';
      tag = arg.tag;
      name = tag.name;
      classes = tag.classes ? " class='" + tag.classes + "'" : '';
      attrs = tag.attrs ? " " + tag.attrs : '';
      if (attrs && arg.params) {
        _ref = arg.params;
        for (k in _ref) {
          v = _ref[k];
          attrs = attrs.replace("" + k, v);
        }
      }
      content = render(arg.content);
      return "<" + name + classes + attrs + ">" + content + "</" + name + ">";
    } else if (isArray(arg)) {
      return join(map(arg, render), '');
    } else {
      if (isUndefined(arg)) {
        return '';
      } else {
        return arg;
      }
    }
  };
  return {
    generate: generate,
    render: render
  };
})();
// Generated by CoffeeScript 1.7.1
var typecheck, typedump;

typedump = function(key, value, indent) {
  var k, v;
  if (indent == null) {
    indent = '';
  }
  if (isNumber(value)) {
    console.log(indent + ("" + key + ": T.num"));
  } else if (isString(value)) {
    console.log(indent + ("" + key + ": T.str"));
  } else if (isBoolean(value)) {
    console.log(indent + ("" + key + ": T.bool"));
  } else if (isFunction(value)) {
    console.log(indent + ("" + key + ": T.func"));
  } else if (isError(value)) {
    console.log(indent + ("" + key + ": T.error"));
  } else if (isDate(value)) {
    console.log(indent + ("" + key + ": T.date"));
  } else if (isRegExp(value)) {
    console.log(indent + ("" + key + ": T.regexp"));
  } else if (isArray(value)) {
    console.log(indent + ("" + key + ": T.arr T.any"));
  } else if (isObject(value)) {
    console.log(indent + ("" + key + ":"));
    for (k in value) {
      v = value[k];
      typedump(k, v, indent + '  ');
    }
  }
};

typecheck = function(value, type) {
  var error, lines, message;
  if (error = T.check(value, type)) {
    lines = T.dump(error);
    message = "Typecheck failed for " + type.name;
    if (typeof exports !== "undefined" && exports !== null) {
      console.error(message, lines);
    } else {
      if (window.steam) {
        window.steam.context.fatal(message, {
          errors: lines
        });
      } else {
        console.error(message, lines);
      }
    }
    return false;
  } else {
    return true;
  }
};
// Generated by CoffeeScript 1.7.1
(function() {
  var captureClickAndDrag, makeGrabBar, momentTimestampFormat, timeagoUpdateInterval;

  ko.bindingHandlers.paragraph = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var data, html;
      html = '';
      if (data = ko.unwrap(valueAccessor())) {
        if (-1 !== data.indexOf('\n')) {
          html = "<span>" + (data.replace(/\n/g, '<br/>')) + "</span>";
        } else {
          html = data;
        }
      }
      return ko.utils.setHtml(element, html);
    }
  };

  ko.bindingHandlers.json = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var data;
      data = ko.unwrap(valueAccessor());
      return $(element).text(JSON.stringify(data, null, 2));
    }
  };

  ko.bindingHandlers.geyser = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, data;
      if (data = ko.unwrap(valueAccessor())) {
        $element = $(element);
        if (data.markup) {
          $element.html(geyser.render(data.markup));
          if (data.behavior) {
            data.behavior($element);
          }
          if (data.dispose) {
            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
              return data.dispose();
            });
          }
        } else {
          $element.html(geyser.render(data));
        }
      } else {
        $(element).text('-');
      }
    }
  };

  ko.bindingHandlers.icon = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var icon;
      if (icon = ko.unwrap(valueAccessor())) {
        element.className = "fa fa-" + icon.image;
        element.style.color = icon.color ? icon.color : null;
        element.title = icon.caption ? icon.caption : '';
      }
    }
  };

  ko.bindingHandlers.hover = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, handler, handlerIn, handlerOut;
      handler = ko.unwrap(valueAccessor());
      if (!isFunction(handler)) {
        throw new Error('Not a function');
      }
      $element = $(element);
      handlerIn = function() {
        return handler(true);
      };
      handlerOut = function() {
        return handler(false);
      };
      $element.hover(handlerIn, handlerOut);
      return ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
        return $element.off('mouseenter mouseleave');
      });
    }
  };

  ko.bindingHandlers.tooltip = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, title;
      title = ko.unwrap(valueAccessor());
      $element = $(element);
      $element.tooltip('destroy');
      if (title) {
        $element.tooltip({
          title: title
        });
      }
      return ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
        return $element.tooltip('destroy');
      });
    }
  };

  timeagoUpdateInterval = 60000;

  momentTimestampFormat = 'MMMM Do YYYY, h:mm:ss a';

  ko.bindingHandlers.timeago = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, date, tick, timestamp;
      timestamp = ko.unwrap(valueAccessor());
      if (isString(timestamp)) {
        timestamp = parseInt(timestamp);
      }
      $element = $(element);
      date = moment(new Date(timestamp));
      $element.attr('title', date.format(momentTimestampFormat));
      tick = function() {
        var label;
        label = date.fromNow();
        if ($element.text() !== label) {
          $element.text(label);
        }
      };
      if (window.steam) {
        window.steam.context.schedule(timeagoUpdateInterval, tick);
        ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
          return window.steam.context.unschedule(timeagoUpdateInterval, tick);
        });
      }
      tick();
    }
  };

  ko.bindingHandlers.collapse = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $disclosureEl, $el, $nextEl, angleDown, angleRight, disclosureEl, isCollapsed, toggle;
      angleDown = 'fa-angle-down';
      angleRight = 'fa-angle-right';
      isCollapsed = ko.unwrap(valueAccessor());
      disclosureEl = document.createElement('i');
      disclosureEl.className = 'fa';
      element.appendChild(disclosureEl);
      $el = $(element);
      $nextEl = $el.next();
      if (!$nextEl.length) {
        throw new Error('No collapsible sibling found');
      }
      $disclosureEl = $(disclosureEl);
      toggle = function() {
        if (isCollapsed) {
          $disclosureEl.removeClass(angleDown).addClass(angleRight);
          $nextEl.hide();
        } else {
          $disclosureEl.removeClass(angleRight).addClass(angleDown);
          $nextEl.show();
        }
        return isCollapsed = !isCollapsed;
      };
      $el.css('cursor', 'pointer');
      $el.attr('title', 'Click to expand/collapse');
      $disclosureEl.css('margin-left', '10px');
      $el.on('click', toggle);
      toggle();
      ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
        return $el.off('click');
      });
    }
  };

  ko.bindingHandlers.raw = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, arg;
      arg = ko.unwrap(valueAccessor());
      if (arg) {
        $element = $(element);
        $element.empty();
        $element.append(arg);
      }
    }
  };

  ko.bindingHandlers.help = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, arg, steam;
      if (steam = window.steam) {
        $element = $(element);
        arg = ko.unwrap(valueAccessor());
        if (isFunction(arg)) {
          $element.on('click', function() {
            return arg();
          });
        } else if (isString(arg)) {
          $element.on('click', function() {
            return steam.context.help(arg);
          });
        } else {
          throw new Error('Invalid argument');
        }
        ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
          return $element.off('click');
        });
      }
    }
  };

  captureClickAndDrag = function($el, onClick, onDrag, onRelease) {
    var $document;
    $document = $(document);
    return $el.on('mousedown', function(e) {
      var onMouseMove, onMouseUp, zIndex;
      if (e.which !== 1) {
        return;
      }
      zIndex = $el.css('z-index');
      $el.css('z-index', 1000);
      onMouseMove = function(e) {
        return onDrag(e.pageX, e.pageY);
      };
      onMouseUp = function(e) {
        $el.css('z-index', zIndex);
        $document.off('mousemove', onMouseMove);
        $document.off('mouseup', onMouseUp);
        return onRelease(e.pageX, e.pageY);
      };
      $document.on('mousemove', onMouseMove);
      $document.on('mouseup', onMouseUp);
      e.preventDefault();
      onClick(e.pageX, e.pageY);
    });
  };

  makeGrabBar = function($el, _opts, go) {
    var onClick, onDrag, onRelease, readElementSize, _height, _left, _offset, _top, _width, _x, _y;
    _offset = null;
    _left = _top = _width = _height = _x = _y = 0;
    readElementSize = function() {
      _width = $el.outerWidth();
      _height = $el.outerHeight();
      return _offset = $el.offset();
    };
    onClick = function(x, y) {
      readElementSize();
      _x = _offset.left + _width - x;
      return _y = _offset.top + _height - y;
    };
    onDrag = function(x, y) {
      var left, top;
      left = _opts.allowHorizontalMovement ? x + _x - _width : _offset.left;
      top = _opts.allowVerticalMovement ? y + _y - _height : _offset.top;
      if (left !== _left || top !== _top) {
        _left = left;
        _top = top;
        return $el.offset({
          left: left,
          top: top
        });
      }
    };
    onRelease = function(x, y) {
      readElementSize();
      return go({
        left: _offset.left,
        top: _offset.top,
        width: _width,
        height: _height
      });
    };
    return captureClickAndDrag($el, onClick, onDrag, onRelease);
  };

  ko.bindingHandlers.draggable = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $el, grabBarOpts;
      $el = $(element);
      grabBarOpts = {
        allowVerticalMovement: true,
        allowHorizontalMovement: false
      };
      return makeGrabBar($el, grabBarOpts, function(rect) {
        return console.log(rect);
      });
    }
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.Application = function(_) {
    var _view;
    if (window) {
      Steam.ErrorMonitor(_);
      Steam.TextMetrics(_);
    }
    Steam.Timers(_);
    Steam.EventLog(_);
    Steam.Cache(_);
    Steam.LocalStorage(_);
    Steam.Xhr(_);
    Steam.H2OProxy(_);
    Steam.HelpServer(_);
    _view = Steam.MainView(_);
    Steam.Router(_, Steam.Routes(_));
    Steam.DialogManager(_);
    return {
      context: _,
      view: _view
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ApplicationContext = function() {
    return context$({
      error: edge$(),
      warn: edge$(),
      info: edge$(),
      fatal: edge$(),
      notify: edge$(),
      schedule: edge$(),
      unschedule: edge$(),
      timeout: edge$(),
      man: edge$(),
      help: edge$(),
      status: edge$(),
      inspect: edge$(),
      route: edge$(),
      setRoute: edge$(),
      getRoute: edge$(),
      onRouteSucceeded: edge$(),
      onRouteFailed: edge$(),
      loadDialog: edge$(),
      unloadDialog: edge$(),
      positionDialog: edge$(),
      alert: edge$(),
      confirm: edge$(),
      fail: edge$(),
      measureTextWidth: edge$(),
      invokeH2O: edge$(),
      requestFrames: edge$(),
      requestFramesAndCompatibleModels: edge$(),
      requestFrame: edge$(),
      requestFrameAndCompatibleModels: edge$(),
      requestScoringOnFrame: edge$(),
      requestModels: edge$(),
      requestModelsAndCompatibleFrames: edge$(),
      requestModel: edge$(),
      requestModelAndCompatibleFrames: edge$(),
      putLocalObject: edge$(),
      getLocalObject: edge$(),
      getLocalObjects: edge$(),
      deleteLocalObject: edge$(),
      putIntoCache: edge$(),
      getFromCache: edge$(),
      removeFromCache: edge$(),
      switchTopic: edge$(),
      switchToFrames: edge$(),
      switchToModels: edge$(),
      switchToScoring: edge$(),
      switchToNotifications: edge$(),
      displayEmpty: edge$(),
      loadFrames: edge$(),
      refreshFrames: edge$(),
      framesLoaded: edge$(),
      displayFrame: edge$(),
      promptForFrame: edge$(),
      loadModels: edge$(),
      refreshModels: edge$(),
      displayModel: edge$(),
      modelSelectionChanged: edge$(),
      modelSelectionCleared: edge$(),
      deselectAllModels: edge$(),
      clearModelSelection: edge$(),
      loadNotifications: edge$(),
      displayNotification: edge$(),
      loadScorings: edge$(),
      displayScoring: edge$(),
      scoringSelectionChanged: edge$(),
      scoringSelectionCleared: edge$(),
      scoringsSelected: edge$(),
      scoringsDeselected: edge$(),
      deselectAllScorings: edge$(),
      clearScoringSelection: edge$(),
      deleteScorings: edge$(),
      deleteActiveScoring: edge$(),
      scoringAvailable: edge$(),
      rescore: edge$(),
      configureStripPlot: edge$(),
      configureScoringVisualization: edge$(),
      filterScorings: edge$()
    });
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.Timers = function(_) {
    var _timeouts, _timers;
    _timers = {};
    _timeouts = {};
    link$(_.timeout, function(id, ms, func) {
      var timeout;
      console.assert(isFunction(func));
      if (timeout = _timeouts[id]) {
        clearInterval(timeout.id);
        return timeout.id = setInterval(func, ms);
      } else {
        return _timeouts[id] = {
          id: setInterval(func, ms)
        };
      }
    });
    link$(_.schedule, function(ms, func) {
      var tick, timer, timerId;
      console.assert(isFunction(func));
      if (timer = _timers[ms]) {
        return push(timer.functions, func);
      } else {
        tick = function() {
          var f, _i, _len, _ref;
          _ref = _timers[ms].functions;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            f = _ref[_i];
            if (f) {
              f();
            }
          }
        };
        timerId = setInterval(tick, ms);
        return _timers[ms] = {
          id: timerId,
          functions: [func]
        };
      }
    });
    return link$(_.unschedule, function(ms, func) {
      var timer;
      if (timer = _timers[ms]) {
        if (func) {
          remove(timer.functions, func);
          if (timer.functions.length === 0) {
            clearInterval(timer.id);
            delete _timers[ms];
          }
        } else {
          clearInterval(timer.id);
          delete _timers[ms];
        }
      }
    });
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.Router = function(_, routes) {
    var handler, notifyCrossroads, route;
    crossroads.routed.add(function(route, data) {
      return _.onRouteSucceeded(route);
    });
    crossroads.bypassed.add(function(route) {
      return _.onRouteFailed(route);
    });
    for (route in routes) {
      handler = routes[route];
      crossroads.addRoute(route, handler);
    }
    notifyCrossroads = function(newHash, oldHash) {
      return crossroads.parse(newHash);
    };
    hasher.initialized.add(notifyCrossroads);
    hasher.changed.add(notifyCrossroads);
    link$(_.route, hasher.setHash);
    link$(_.getRoute, hasher.getHash);
    link$(_.setRoute, function(address) {
      hasher.changed.active = false;
      hasher.setHash(address);
      return hasher.changed.active = true;
    });
    hasher.init();
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.Routes = function(_) {};

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ErrorMonitor = function(_) {
    return window.onerror = function(message, url, lineNumber) {
      return _.fatal(message, {
        url: url,
        lineNumber: lineNumber
      });
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.EventLog = function(_) {
    var log, logError;
    log = function(level, message, data, cause) {
      return _.notify({
        level: level,
        message: message,
        data: data,
        cause: cause,
        timestamp: new Date()
      });
    };
    logError = function(level, message, data, error) {
      var stackTrace;
      stackTrace = error ? printStackTrace({
        e: error
      }) : printStackTrace();
      return log(level, message, data, {
        error: error,
        stackTrace: stackTrace
      });
    };
    link$(_.info, function(message, data) {
      if (message == null) {
        message = '';
      }
      return log('info', message, data);
    });
    link$(_.warn, function(message, data) {
      if (message == null) {
        message = '';
      }
      return log('warn', message, data);
    });
    link$(_.error, function(message, data, error) {
      if (message == null) {
        message = '';
      }
      return logError('error', message, data, error);
    });
    link$(_.fatal, function(message, data, error) {
      if (message == null) {
        message = '';
      }
      return logError('fatal', message, data, error);
    });
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.Cache = function(_) {
    var _cache;
    _cache = {};
    link$(_.putIntoCache, function(key, value) {
      return _cache[key] = value;
    });
    link$(_.getFromCache, function(key) {
      return _cache[key];
    });
    return link$(_.removeFromCache, function(key) {
      return delete _cache[key];
    });
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.LocalStorage = function(_) {
    var deleteLocalObject, getLocalObject, getLocalObjects, putLocalObject, _hasLocalStorage;
    _hasLocalStorage = (function() {
      var error;
      try {
        localStorage.setItem('test', 'test');
        localStorage.removeItem('test');
        return true;
      } catch (_error) {
        error = _error;
        return false;
      }
    })();
    if (!_hasLocalStorage) {
      return;
    }
    putLocalObject = function(key, value) {
      return localStorage.setItem(key, JSON.stringify(value));
    };
    getLocalObject = function(key) {
      var value;
      value = localStorage.getItem(key);
      if (isDefined(value)) {
        return JSON.parse(value);
      } else {
        return void 0;
      }
    };
    getLocalObjects = function(predicate) {
      var hasPredicate, index, value, values, _i, _ref;
      values = [];
      hasPredicate = isFunction(predicate);
      for (index = _i = 0, _ref = localStorage.length; 0 <= _ref ? _i < _ref : _i > _ref; index = 0 <= _ref ? ++_i : --_i) {
        value = getLocalObject(localStorage.key(index));
        if (hasPredicate) {
          if (predicate(value)) {
            values.push(value);
          }
        } else {
          values.push(value);
        }
      }
      return values;
    };
    deleteLocalObject = function(key) {
      return localStorage.removeItem(key);
    };
    link$(_.putLocalObject, putLocalObject);
    link$(_.getLocalObject, getLocalObject);
    link$(_.getLocalObjects, getLocalObjects);
    link$(_.deleteLocalObject, deleteLocalObject);
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.Xhr = function(_) {
    var createResponse, h2oHttpAddress, h2oHttpPort, makeHttpRequest;
    createResponse = function(status, data, xhr) {
      return {
        status: status,
        data: data,
        xhr: xhr
      };
    };
    if (typeof exports !== "undefined" && exports !== null) {
      h2oHttpAddress = process.env.STEAM_NODE_ADDR;
      h2oHttpPort = process.env.STEAM_NODE_PORT;
      if (!h2oHttpAddress) {
        h2oHttpAddress = '127.0.0.1';
        h2oHttpPort = 54321;
      }
      makeHttpRequest = function(method, host, port, path, go) {
        var url;
        url = "http://" + host + ":" + port + path;
        return httpRequest(url, function(error, response, body) {
          if (error) {
            return go(error);
          } else {
            return go(null, createResponse(response.statusCode, body, response));
          }
        });
      };
      return link$(_.invokeH2O, function(method, path, go) {
        return makeHttpRequest(method, h2oHttpAddress, h2oHttpPort, path, function(error, response) {
          var json;
          if (error) {
            return go(error);
          } else {
            switch (response.status) {
              case 200:
                try {
                  json = JSON.parse(response.data);
                  if (json) {
                    return go(null, createResponse(response.status, json, response.xhr));
                  } else {
                    return go(response);
                  }
                } catch (_error) {
                  error = _error;
                  return go(response);
                }
                break;
              default:
                return go(response);
            }
          }
        });
      });
    } else {
      return link$(_.invokeH2O, function(method, path, go) {
        return $.getJSON(path).done(function(data, status, xhr) {
          return go(null, createResponse(status, data, xhr));
        }).fail(function(xhr, status, error) {
          return go(createResponse(status, xhr.responseJSON, xhr));
        });
      });
    }
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.H2OProxy = function(_) {
    var composePath, filterOutUnhandledModels, request, requestFrames, requestModels;
    composePath = function(path, opts) {
      var params;
      if (opts) {
        params = mapWithKey(opts, function(v, k) {
          return "" + k + "=" + v;
        });
        return path + '?' + join(params, '&');
      } else {
        return path;
      }
    };
    request = function(path, opts, go) {
      return _.invokeH2O('GET', composePath(path, opts), function(error, result) {
        if (error) {
          return go(error, result);
        } else {
          if (result.data.response.status === 'error') {
            return go(result.data.error, result.data);
          } else {
            return go(error, result.data);
          }
        }
      });
    };
    filterOutUnhandledModels = function(models) {
      return filter(models, function(model) {
        return model.state === 'DONE' && model.model_category === 'Binomial';
      });
    };
    requestFrames = function(go, opts) {
      return request('/2/Frames.json', opts, function(error, result) {
        var frame, frameKey, frames, metrics, model, modelKey, models, response;
        if (error) {
          return go(error, result);
        } else {
          frames = result.frames, models = result.models, metrics = result.metrics, response = result.response;
          for (modelKey in models) {
            model = models[modelKey];
            model.key = modelKey;
          }
          for (frameKey in frames) {
            frame = frames[frameKey];
            frame.key = frameKey;
            frame.compatible_models = filterOutUnhandledModels(map(frame.compatible_models, function(modelKey) {
              return models[modelKey];
            }));
          }
          return go(error, {
            response: response,
            frames: values(frames),
            metrics: metrics
          });
        }
      });
    };
    requestModels = function(go, opts) {
      return request('/2/Models.json', opts, function(error, result) {
        var frame, frameKey, frames, model, modelKey, models, response;
        if (error) {
          return go(error, result);
        } else {
          frames = result.frames, models = result.models, response = result.response;
          for (frameKey in frames) {
            frame = frames[frameKey];
            frame.key = frameKey;
          }
          for (modelKey in models) {
            model = models[modelKey];
            model.key = modelKey;
            model.compatible_frames = map(model.compatible_frames, function(frameKey) {
              return frames[frameKey];
            });
          }
          return go(error, {
            response: response,
            models: filterOutUnhandledModels(values(models))
          });
        }
      });
    };
    link$(_.requestFrames, function(go) {
      return requestFrames(go);
    });
    link$(_.requestFramesAndCompatibleModels, function(go) {
      return requestFrames(go, {
        find_compatible_models: true
      });
    });
    link$(_.requestFrame, function(key, go) {
      return requestFrames(go, {
        key: encodeURIComponent(key)
      });
    });
    link$(_.requestFrameAndCompatibleModels, function(key, go) {
      return requestFrames(go, {
        key: encodeURIComponent(key),
        find_compatible_models: true
      });
    });
    link$(_.requestScoringOnFrame, function(frameKey, modelKey, go) {
      return requestFrames(go, {
        key: encodeURIComponent(frameKey),
        score_model: modelKey
      });
    });
    link$(_.requestModels, function(go) {
      return requestModels(go);
    });
    link$(_.requestModelsAndCompatibleFrames, function(go) {
      return requestModels(go, {
        find_compatible_frames: true
      });
    });
    link$(_.requestModel, function(key, go) {
      return requestModels(go, {
        key: encodeURIComponent(key)
      });
    });
    return link$(_.requestModelAndCompatibleFrames, function(key, go) {
      return requestModels(go, {
        key: encodeURIComponent(key),
        find_compatible_frames: true
      });
    });
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.HelpServer = function(_) {
    var createHelpView;
    createHelpView = function(title, content) {
      return $("<h1>" + title + "</h1><div>" + content + "</div>");
    };
    return link$(_.man, function(id) {
      var $help, entry;
      if (id == null) {
        id = 'home';
      }
      entry = Steam.Help[id];
      if (entry) {
        $help = createHelpView(entry.title, entry.content || 'No help available.');
        $('a', $help).each(function() {
          var $self, url;
          $self = $(this);
          url = $self.attr('href');
          if (url) {
            if (0 === url.indexOf('help:')) {
              $self.removeAttr('href');
              return $self.click(function() {
                return _.help(url.substr(1 + url.indexOf(':')));
              });
            } else {
              return $self.attr('target', '_blank');
            }
          }
        });
        return $help;
      } else {
        return createHelpView('Help not found', 'Could not find help content for this item.');
      }
    });
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.TextMetrics = function(_) {
    var createMeasurementBox, measureTextWidth, _$box;
    _$box = null;
    createMeasurementBox = function() {
      var $box, $container;
      if (!_$box) {
        $container = $(document.createElement('div'));
        $container.attr('style', 'position:absolute;left:0;top:0;width:0;height:0;overflow:hidden');
        $box = $(document.createElement('span'));
        $box.attr('style', 'font-size:11px');
        $container.append($box);
        $('body').append($container);
        _$box = $box;
      }
      return _$box;
    };
    measureTextWidth = function(text) {
      var $box;
      $box = createMeasurementBox();
      $box.text(text);
      return $box.width();
    };
    return link$(_.measureTextWidth, measureTextWidth);
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.Help = {
    'model.key': {
      title: 'Model Key',
      content: ''
    },
    'model.method': {
      title: 'Model Method',
      content: ''
    },
    'model.category': {
      title: 'Model Category',
      content: ''
    },
    'model.response_column': {
      title: 'Model Response Column',
      content: ''
    },
    'model.category.binomial': {
      title: 'Binomial',
      content: ''
    },
    'model.method.deep_learning': {
      title: 'Deep Learning',
      content: ''
    },
    'model.method.speed_drf': {
      title: 'SpeeDRF',
      content: ''
    },
    'model.method.drf': {
      title: 'DRF',
      content: ''
    },
    'model.method.glm': {
      title: 'GLM',
      content: ''
    },
    'model.method.gbm': {
      title: 'GBM',
      content: ''
    }
  };

  (function() {
    var h2, icon, li, p, span, ul, _ref;
    _ref = geyser.generate(words('h2 p ul li i.fa.fa-question-circle span')), h2 = _ref[0], p = _ref[1], ul = _ref[2], li = _ref[3], icon = _ref[4], span = _ref[5];
    return Steam.Help.home = {
      title: 'Welcome to H<sub>2</sub>O',
      content: geyser.render([p('H<sub>2</sub>O by 0xdata brings better algorithms to big data. H<sub>2</sub>O is the open source math and machine learning platform for speed and scale. With H<sub>2</sub>O, enterprises can use all of their data (instead of sampling) in real-time for better predictions. Data Scientists can take both simple and sophisticated models to production from H<sub>2</sub>O the same interactive platform used for modeling, within R and JSON. H<sub>2</sub>O is also used as an algorithms library for Making Hadoop Do Math.'), h2('User Guide'), ul([li([icon(), span(' General')]), li([icon(), span(' Data')]), li([icon(), span(' Model')]), li([icon(), span(' Score')]), li([icon(), span(' Administration')])]), h2('Walkthroughs'), ul([li([icon(), span(' GLM')]), li([icon(), span(' GLM Grid')]), li([icon(), span(' K Means')]), li([icon(), span(' Random Forest')]), li([icon(), span(' PCA')]), li([icon(), span(' GBM')]), li([icon(), span(' GBM Grid')])])])
    };
  })();

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  var __slice = [].slice;

  Steam.DialogManager = function(_) {
    var initialize, linkDialog;
    initialize = function() {
      linkDialog(_.alert, Steam.AlertDialog);
      linkDialog(_.fail, Steam.ErrorDialog);
      linkDialog(_.confirm, Steam.ConfirmDialog);
      linkDialog(_.promptForFrame, Steam.SelectFrameDialog);
      linkDialog(_.configureStripPlot, Steam.ConfigureStripPlotDialog);
      linkDialog(_.configureScoringVisualization, Steam.ScoringVisualizationDialog);
      return linkDialog(_.filterScorings, Steam.ScoringFilterDialog);
    };
    linkDialog = function(edge, createDialog) {
      return link$(edge, function() {
        var dialog, go, requestArgs, _i;
        requestArgs = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), go = arguments[_i++];
        if (!isFunction(go)) {
          throw new Error('No continuation provided.');
        }
        requestArgs.unshift(_);
        requestArgs.push(function() {
          var responseArgs;
          responseArgs = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
          _.unloadDialog(dialog);
          return go.apply(null, responseArgs);
        });
        return _.loadDialog(dialog = createDialog.apply(null, requestArgs));
      });
    };
    link$(_.positionDialog, function(element) {
      var $dialog, $dialogBody, $dialogContainer, $dialogHeader, dialogBodyHeight, dialogHeaderHeight, dialogHeight, dialogLeft, dialogTop, dialogWidth, parentWidth, _ref;
      if (element.nodeType !== 1) {
        return;
      }
      $dialogContainer = $(element);
      $dialog = $($dialogContainer.children()[0]);
      _ref = map($dialog.children(), function(child) {
        return $(child);
      }), $dialogHeader = _ref[0], $dialogBody = _ref[1];
      dialogWidth = parseInt($dialog.attr('data-dialog-width'));
      dialogHeight = parseInt($dialog.attr('data-dialog-height'));
      parentWidth = $dialog.parent().parent().width();
      if (!(dialogWidth > 0)) {
        dialogWidth = parentWidth * 0.75;
      }
      $dialog.width(dialogWidth);
      if (!(dialogHeight > 0)) {
        dialogHeight = $dialog.height();
      }
      dialogLeft = -dialogWidth / 2;
      dialogTop = -dialogHeight / 2;
      dialogHeaderHeight = $dialogHeader.height();
      dialogBodyHeight = dialogHeight - dialogHeaderHeight;
      $dialog.attr('style', "position:absolute;width:" + dialogWidth + "px;height:" + dialogHeight + "px;left:" + dialogLeft + "px;top:" + dialogTop + "px");
      $dialogHeader.attr('style', 'position:absolute;top:0;left:0;right:0');
      return $dialogBody.attr('style', "position:absolute;left:0;right:0;bottom:0;top:" + dialogHeaderHeight + "px");
    });
    initialize();
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.AlertDialog = function(_, _title, _message, _go) {
    var cancel, confirm;
    confirm = function() {
      return _go('confirm');
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      title: _title,
      message: _message,
      confirm: confirm,
      cancel: cancel,
      template: 'alert-dialog'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ErrorDialog = function(_, _title, _message, error, _go) {
    var cancel, confirm;
    confirm = function() {
      return _go('confirm');
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      title: _title,
      message: _message,
      confirm: confirm,
      cancel: cancel,
      error: error,
      template: 'error-dialog'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ConfirmDialog = function(_, _message, _opts, _go) {
    var cancel, confirm;
    confirm = function() {
      return _go('confirm');
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      title: _opts.title || 'Confirm',
      confirmCaption: _opts.confirmCaption || 'Yes',
      cancelCaption: _opts.cancelCaption || 'No',
      message: _message,
      confirm: confirm,
      cancel: cancel,
      template: 'confirm-dialog'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.SelectFrameDialog = function(_, _frames, _go) {
    var cancel, confirm, createItem, initialize, selectItem, _hasSelection, _items, _selectedItem;
    _items = nodes$();
    _selectedItem = node$(null);
    _hasSelection = lift$(_selectedItem, isTruthy);
    initialize = function(frames) {
      var items;
      _items(items = map(frames, createItem));
      return selectItem(head(items));
    };
    selectItem = function(target) {
      var item, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isActive(item === target);
      }
      return _selectedItem(target);
    };
    createItem = function(frame) {
      var self;
      return self = {
        data: frame,
        key: frame.key,
        count: describeCount(frame.column_names.length, 'column'),
        timestamp: frame.creation_epoch_time_millis,
        select: function() {
          return selectItem(self);
        },
        isActive: node$(false)
      };
    };
    confirm = function() {
      return _go('confirm', _selectedItem().data.key);
    };
    cancel = function() {
      return _go('cancel');
    };
    initialize(_frames);
    return {
      items: _items,
      hasSelection: _hasSelection,
      confirm: confirm,
      cancel: cancel,
      template: 'select-frame-dialog'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ConfigureStripPlotDialog = function(_, parameters, _go) {
    var cancel, confirm, wrap, _parameters;
    wrap = function(parameter) {
      return {
        id: parameter.id,
        caption: parameter.caption,
        isSelected: node$(parameter.isSelected()),
        source: parameter
      };
    };
    _parameters = {
      group1: map(parameters.group1(), wrap),
      group2: map(parameters.group2(), wrap),
      group3: map(parameters.group3(), wrap)
    };
    confirm = function() {
      return _go(_parameters);
    };
    cancel = function() {
      return _go(null);
    };
    return {
      parameters: _parameters,
      confirm: confirm,
      cancel: cancel,
      template: 'configure-strip-plot-dialog'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ScoringVisualizationDialog = function(_, _title, _parameters, _go) {
    var cancel, confirm, _axisXVariable, _axisYVariable, _canConfirm, _variables, _visualizationType;
    _visualizationType = node$(_parameters.visualizationType);
    _axisXVariable = node$(_parameters.variableX);
    _axisYVariable = node$(_parameters.variableY);
    _canConfirm = lift$(_axisXVariable, _axisYVariable, function(x, y) {
      return x && y;
    });
    _variables = lift$(_visualizationType, function(visualizationType) {
      return visualizationType.variables;
    });
    confirm = function() {
      return _go('confirm', {
        visualizationType: _visualizationType(),
        variableX: _axisXVariable(),
        variableY: _axisYVariable()
      });
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      title: _title,
      visualizationTypes: _parameters.visualizationTypes,
      visualizationType: _visualizationType,
      variables: _variables,
      variableX: _axisXVariable,
      variableY: _axisYVariable,
      canConfirm: _canConfirm,
      confirm: confirm,
      cancel: cancel,
      template: 'scoring-visualization-dialog'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ScoringFilterDialog = function(_, _filters, go) {
    var cancel, confirm, createFilterView, _filterViews;
    createFilterView = function(filter) {
      var items;
      items = map(filter.items, function(item) {
        return {
          caption: item.factor.caption,
          data: item,
          isChecked: node$(item.isSelected)
        };
      });
      return {
        caption: filter.variable.caption,
        data: filter,
        items: items
      };
    };
    _filterViews = map(_filters, createFilterView);
    confirm = function() {
      return go('confirm', map(_filterViews, function(filterView) {
        var item, predicate, _i, _len, _ref;
        predicate = {};
        _ref = filterView.items;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          item = _ref[_i];
          predicate[item.data.factor.value] = item.isChecked();
        }
        return predicate;
      }));
    };
    cancel = function() {
      return go('cancel');
    };
    return {
      filters: _filterViews,
      confirm: confirm,
      cancel: cancel,
      template: 'scoring-filter-dialog'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.TopicListView = function(_, _topics) {
    return {
      template: 'topic-list-view',
      topics: _topics
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.FrameListView = function(_) {
    var activateAndDisplayItem, clearPredicate, createItem, displayActiveItem, displayFrames, displayItem, loadFrames, _canClearPredicate, _hasItems, _items, _predicate, _predicateCaption;
    _predicate = node$({
      type: 'all'
    });
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    _canClearPredicate = lift$(_predicate, function(predicate) {
      return predicate.type !== 'all';
    });
    _predicateCaption = lift$(_predicate, function(predicate) {
      switch (predicate.type) {
        case 'all':
          return 'Showing\nall datasets';
        case 'compatibleWithModel':
          return "Showing datasets compatible with\n" + predicate.modelKey;
        default:
          throw new Error('Invalid predicate type');
      }
    });
    displayItem = function(item) {
      if (item) {
        return _.displayFrame(item.data);
      } else {
        return _.displayEmpty();
      }
    };
    displayActiveItem = function() {
      return displayItem(find(_items(), function(item) {
        return item.isActive();
      }));
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    createItem = function(frame) {
      var self;
      console.assert(isArray(frame.column_names));
      return self = {
        data: frame,
        title: frame.key,
        caption: (describeCount(frame.column_names.length, 'column')) + ': ' + join(head(frame.column_names, 5), ', '),
        timestamp: frame.creation_epoch_time_millis,
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false)
      };
    };
    displayFrames = function(frames) {
      var items;
      _items(items = map(frames, createItem));
      activateAndDisplayItem(head(items));
      return _.framesLoaded();
    };
    loadFrames = function(predicate) {
      console.assert(isDefined(predicate));
      switch (predicate.type) {
        case 'all':
          _.requestFramesAndCompatibleModels(function(error, data) {
            if (error) {

            } else {
              return displayFrames(data.frames);
            }
          });
          break;
        case 'compatibleWithModel':
          _.requestModelAndCompatibleFrames(predicate.modelKey, function(error, data) {
            var compatibleFramesByKey;
            if (error) {

            } else {
              compatibleFramesByKey = indexBy((head(data.models)).compatible_frames, function(frame) {
                return frame.key;
              });
              return _.requestFramesAndCompatibleModels(function(error, data) {
                var compatibleFrames, nonRawFrames;
                if (error) {

                } else {
                  compatibleFrames = filter(data.frames, function(frame) {
                    if (compatibleFramesByKey[frame.key]) {
                      return true;
                    } else {
                      return false;
                    }
                  });
                  nonRawFrames = filter(compatibleFrames, function(frame) {
                    return !frame.is_raw_frame;
                  });
                  return displayFrames(nonRawFrames);
                }
              });
            }
          });
      }
      _predicate(predicate);
    };
    clearPredicate = function() {
      return loadFrames({
        type: 'all'
      });
    };
    link$(_.loadFrames, function(predicate) {
      if (predicate) {
        return loadFrames(predicate);
      } else {
        return displayActiveItem();
      }
    });
    link$(_.refreshFrames, function() {
      return loadFrames(_predicate());
    });
    return {
      items: _items,
      predicateCaption: _predicateCaption,
      clearPredicate: clearPredicate,
      canClearPredicate: _canClearPredicate,
      hasItems: _hasItems,
      template: 'frame-list-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ModelListView = function(_) {
    var activateAndDisplayItem, clearPredicate, createItem, deselectAllModels, displayActiveItem, displayItem, displayModels, loadModels, _canClearPredicate, _hasItems, _isLive, _isSelectAll, _items, _predicate, _predicateCaption;
    _predicate = node$({
      type: 'all'
    });
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    _isSelectAll = node$(false);
    _isLive = node$(true);
    apply$(_isSelectAll, function(isSelected) {
      var item, _i, _len, _ref;
      _isLive(false);
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected(isSelected);
      }
      _isLive(true);
    });
    _canClearPredicate = lift$(_predicate, function(predicate) {
      return predicate.type !== 'all';
    });
    _predicateCaption = lift$(_predicate, function(predicate) {
      switch (predicate.type) {
        case 'all':
          return 'Showing\nall models';
        case 'compatibleWithFrame':
          return "Showing models compatible with\n" + predicate.frameKey;
        default:
          return '';
      }
    });
    displayItem = function(item) {
      if (item) {
        return _.displayModel(item.data);
      } else {
        return _.displayEmpty();
      }
    };
    displayActiveItem = function() {
      return displayItem(find(_items(), function(item) {
        return item.isActive();
      }));
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    createItem = function(model) {
      var self;
      console.assert(isArray(model.input_column_names));
      console.assert(has(model, 'model_algorithm'));
      console.assert(has(model, 'model_category'));
      console.assert(isObject(model.critical_parameters));
      console.assert(isObject(model.secondary_parameters));
      console.assert(isObject(model.expert_parameters));
      console.assert(has(model, 'response_column_name'));
      console.assert(has(model, 'state'));
      self = {
        data: model,
        title: model.key,
        caption: "" + model.response_column_name + " (" + model.model_category + ")",
        timestamp: model.creation_epoch_time_millis,
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false),
        isSelected: node$(false)
      };
      apply$(_isLive, self.isSelected, function(isLive, isSelected) {
        if (isLive) {
          return _.modelSelectionChanged(isSelected, self);
        }
      });
      return self;
    };
    displayModels = function(models) {
      var items;
      _items(items = map(models, createItem));
      return activateAndDisplayItem(head(items));
    };
    apply$(_predicate, function(predicate) {
      console.assert(isDefined(predicate));
      _.modelSelectionCleared();
      switch (predicate.type) {
        case 'all':
          _.requestModelsAndCompatibleFrames(function(error, data) {
            if (error) {

            } else {
              return displayModels(data.models);
            }
          });
          break;
        case 'compatibleWithFrame':
          _.requestFrameAndCompatibleModels(predicate.frameKey, function(error, data) {
            var compatibleModelsByKey;
            if (error) {

            } else {
              compatibleModelsByKey = indexBy((head(data.frames)).compatible_models, function(model) {
                return model.key;
              });
              return _.requestModelsAndCompatibleFrames(function(error, data) {
                if (error) {

                } else {
                  return displayModels(filter(data.models, function(model) {
                    if (compatibleModelsByKey[model.key]) {
                      return true;
                    } else {
                      return false;
                    }
                  }));
                }
              });
            }
          });
      }
    });
    deselectAllModels = function() {
      var item, _i, _len, _ref;
      _isLive(false);
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected(false);
      }
      return _isLive(true);
    };
    clearPredicate = function() {
      deselectAllModels();
      return _predicate({
        type: 'all'
      });
    };
    loadModels = function(predicate) {
      if (predicate) {
        return _predicate(predicate);
      } else {
        return displayActiveItem();
      }
    };
    link$(_.loadModels, loadModels);
    link$(_.deselectAllModels, deselectAllModels);
    link$(_.refreshModels, function() {
      return loadModels(_predicate());
    });
    return {
      items: _items,
      hasItems: _hasItems,
      predicateCaption: _predicateCaption,
      clearPredicate: clearPredicate,
      canClearPredicate: _canClearPredicate,
      isSelectAll: _isSelectAll,
      template: 'model-list-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ScoringListView = function(_) {
    var activateAndDisplayItem, clearPredicate, createComparisonItem, createScoringItem, createScoringJobs, deleteActiveScoring, deleteScorings, deselectAllScorings, displayItem, findActiveItem, loadScorings, runScoringJobs, _canClearPredicate, _hasItems, _isLive, _isSelectAll, _items, _predicate, _predicateCaption;
    _predicate = node$({
      type: 'all'
    });
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    _isSelectAll = node$(false);
    _isLive = node$(true);
    apply$(_isSelectAll, function(isSelected) {
      var item, _i, _len, _ref;
      _isLive(false);
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected(isSelected);
      }
      _isLive(true);
    });
    _canClearPredicate = false;
    _predicateCaption = 'Showing\nall scorings';
    displayItem = function(item) {
      if (item) {
        _.displayScoring(item);
        return _.scoringAvailable(true);
      } else {
        _.displayEmpty();
        return _.scoringAvailable(false);
      }
    };
    findActiveItem = function() {
      return find(_items(), function(item) {
        return item.isActive();
      });
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    createScoringItem = function(scoring) {
      var self;
      self = {
        type: 'scoring',
        data: {
          input: scoring,
          output: null
        },
        title: "Scoring on " + scoring.frameKey,
        caption: "" + scoring.model.key + " (" + scoring.model.response_column_name + ")",
        timestamp: scoring.timestamp,
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false),
        isSelected: node$(false),
        state: node$('waiting'),
        isReady: node$(false),
        hasFailed: node$(false)
      };
      apply$(_isLive, self.isSelected, function(isLive, isSelected) {
        if (isLive) {
          return _.scoringSelectionChanged(isSelected, self);
        }
      });
      return self;
    };
    createComparisonItem = function(comparison) {
      var self;
      self = {
        type: 'comparison',
        data: comparison,
        title: 'Comparison',
        caption: describeCount(comparison.scorings.length, 'scoring'),
        timestamp: node$(comparison.timestamp),
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false),
        isSelected: node$(false),
        isReady: node$(true),
        hasFailed: node$(false)
      };
      apply$(_isLive, self.isSelected, function(isLive, isSelected) {
        if (isLive) {
          return _.scoringSelectionChanged(isSelected, self);
        }
      });
      return self;
    };
    runScoringJobs = function(jobs, go) {
      var queue, runNext;
      queue = copy(jobs);
      runNext = function() {
        var job;
        if (job = shift(queue)) {
          return job.run(function() {
            return defer(runNext);
          });
        } else {
          return go();
        }
      };
      return defer(runNext);
    };
    createScoringJobs = function(items) {
      return map(items, function(item) {
        var frameKey, modelKey;
        frameKey = item.data.input.frameKey;
        modelKey = item.data.input.model.key;
        return {
          run: function(go) {
            item.state('running');
            return _.requestScoringOnFrame(frameKey, modelKey, function(error, result) {
              if (error) {
                _.error('Scoring failed', {
                  frameKey: frameKey,
                  modelKey: modelKey
                }, error);
                item.state('error');
                item.hasFailed(true);
                item.data.output = result;
              } else {
                item.state('success');
                item.hasFailed(false);
                item.data.output = result;
              }
              item.isReady(true);
              return go();
            });
          }
        };
      });
    };
    loadScorings = function(predicate) {
      var item, items, jobs;
      console.assert(isDefined(predicate));
      switch (predicate.type) {
        case 'scoring':
          items = map(predicate.scorings, createScoringItem);
          _items.splice.apply(_items, [0, 0].concat(items));
          jobs = createScoringJobs(items);
          runScoringJobs(jobs, function() {
            var item, _i, _len;
            for (_i = 0, _len = items.length; _i < _len; _i++) {
              item = items[_i];
              if (!item.hasFailed()) {
                item.timestamp = (head(item.data.output.metrics)).scoring_time;
              }
            }
            if (items.length > 1) {
              return _.loadScorings({
                type: 'comparison',
                scorings: items,
                timestamp: Date.now()
              });
            } else {
              return activateAndDisplayItem(head(items));
            }
          });
          break;
        case 'comparison':
          item = createComparisonItem({
            scorings: predicate.scorings,
            timestamp: predicate.timestamp
          });
          _items.unshift(item);
          activateAndDisplayItem(item);
      }
      _predicate(predicate);
    };
    link$(_.loadScorings, function(predicate) {
      if (predicate) {
        return loadScorings(predicate);
      } else {
        return displayItem(findActiveItem());
      }
    });
    deselectAllScorings = function() {
      var item, _i, _len, _ref;
      _isLive(false);
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected(false);
      }
      _isLive(true);
      return _.scoringSelectionCleared();
    };
    link$(_.rescore, function() {
      var allFrames, compatibleFrames, item, model, models, scoring, _i, _len, _ref;
      scoring = findActiveItem();
      models = [];
      allFrames = [];
      switch (scoring.type) {
        case 'scoring':
          model = scoring.data.input.model;
          push(models, model);
          pushAll(allFrames, model.compatible_frames);
          break;
        case 'comparison':
          _ref = scoring.data.scorings;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            item = _ref[_i];
            model = item.data.input.model;
            push(models, model);
            pushAll(allFrames, model.compatible_frames);
          }
      }
      compatibleFrames = unique(allFrames, function(frame) {
        return frame.id;
      });
      return _.promptForFrame(compatibleFrames, function(action, frameKey) {
        switch (action) {
          case 'confirm':
            return _.switchToScoring({
              type: 'scoring',
              scorings: map(models, function(model) {
                return {
                  frameKey: frameKey,
                  model: model,
                  status: null,
                  time: null,
                  result: null,
                  timestamp: Date.now()
                };
              })
            });
        }
      });
    });
    deleteActiveScoring = function() {
      _items.remove(findActiveItem());
      return displayItem(null);
    };
    deleteScorings = function(scorings) {
      deselectAllScorings();
      _items.removeAll(scorings);
      if (!findActiveItem()) {
        return displayItem(null);
      }
    };
    clearPredicate = function() {};
    link$(_.deselectAllScorings, deselectAllScorings);
    link$(_.deleteScorings, deleteScorings);
    link$(_.deleteActiveScoring, deleteActiveScoring);
    return {
      items: _items,
      hasItems: _hasItems,
      predicateCaption: _predicateCaption,
      clearPredicate: clearPredicate,
      canClearPredicate: _canClearPredicate,
      isSelectAll: _isSelectAll,
      template: 'scoring-list-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.NotificationListView = function(_) {
    var activateAndDisplayItem, createItem, displayActiveItem, displayItem, _hasItems, _items;
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    displayItem = function(item) {
      if (item) {
        return _.displayNotification(item.data);
      } else {
        return _.displayEmpty();
      }
    };
    displayActiveItem = function() {
      return displayItem(find(_items(), function(item) {
        return item.isActive();
      }));
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    createItem = function(notification) {
      var self;
      return self = {
        data: notification,
        title: notification.level,
        caption: notification.message,
        cutline: notification.timestamp.toString(),
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false)
      };
    };
    link$(_.notify, function(notification) {
      return _items.unshift(createItem(notification));
    });
    link$(_.loadNotifications, function() {
      return displayActiveItem();
    });
    return {
      items: _items,
      hasItems: _hasItems,
      template: 'notification-list-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  var helpIndex;

  helpIndex = {
    modelCategories: {
      Binomial: 'model.category.binomial'
    },
    modelMethods: {
      DeepLearning: 'model.method.deep_learning',
      GBM: 'model.method.gbm',
      GLM: 'model.method.glm',
      DRF: 'model.method.drf',
      SpeeDRF: 'model.method.speed_drf'
    }
  };

  Steam.FrameView = function(_, _frame) {
    var createCompatibleModelItem, loadCompatibleModels;
    createCompatibleModelItem = function(model) {
      return {
        key: model.key,
        algorithm: model.model_algorithm,
        category: model.model_category,
        responseColumnName: model.response_column_name,
        inspect: function() {
          return _.inspect(Steam.ModelInspectionView(_, model));
        },
        inspectAlgorithm: function() {
          return _.help(helpIndex.modelMethods[model.model_algorithm]);
        },
        inspectCategory: function() {
          return _.help(helpIndex.modelCategories[model.model_category]);
        }
      };
    };
    loadCompatibleModels = function() {
      return _.switchToModels({
        type: 'compatibleWithFrame',
        frameKey: _frame.key
      });
    };
    return {
      data: _frame,
      key: _frame.key,
      timestamp: _frame.creation_epoch_time_millis,
      title: _frame.key,
      columns: _frame.column_names,
      columnCount: "(" + _frame.column_names.length + ")",
      compatibleModels: map(_frame.compatible_models, createCompatibleModelItem),
      compatibleModelsCount: "(" + _frame.compatible_models.length + ")",
      hasCompatibleModels: _frame.compatible_models.length > 0,
      loadCompatibleModels: loadCompatibleModels,
      isRawFrame: _frame.is_raw_frame,
      parseUrl: "/2/Parse2.query?source_key=" + (encodeURIComponent(_frame.key)),
      dispose: function() {},
      template: 'frame-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  var computeCumulativeScaledValues, createVariableImportanceChart, createVariableImportanceModel, renderVariableImportanceChart;

  createVariableImportanceChart = function(varImp, measureTextWidth, showPareto) {
    var div, render;
    div = geyser.generate(['div'])[0];
    render = function($element) {
      return $element.empty().append(renderVariableImportanceChart(varImp, measureTextWidth, showPareto));
    };
    return {
      markup: div(),
      behavior: render
    };
  };

  renderVariableImportanceChart = function(varImp, measureTextWidth, showPareto) {
    var axis, axisPadding, axisX, axisXHeight, axisY, axisYWidth, barHeight, columnNames, datumWithLongestLabel, el, height, line, margin, pointX, pointY, scaleX, scaleXPercent, scaleY, svg, tickCount, tickFormatX, width;
    tickCount = 10;
    axisPadding = 15;
    barHeight = 20;
    columnNames = map(varImp.data, function(datum) {
      return datum.columnName;
    });
    scaleX = d3.scale.linear().domain([
      0, 1.1 * d3.max(varImp.data, function(datum) {
        return datum.value;
      })
    ]).nice(tickCount);
    scaleY = d3.scale.ordinal().domain(columnNames);
    tickFormatX = scaleX.tickFormat(tickCount);
    axisXHeight = axisPadding + measureTextWidth(max(map(scaleX.ticks(tickCount), tickFormatX), function(tick) {
      return tick.length;
    }));
    datumWithLongestLabel = max(varImp.data, function(datum) {
      return datum.columnName.length;
    });
    axisYWidth = axisPadding + measureTextWidth(datumWithLongestLabel.columnName);
    margin = {
      top: 20,
      right: 20,
      bottom: axisXHeight,
      left: axisYWidth
    };
    width = 500 - margin.left - margin.right;
    height = varImp.data.length * barHeight;
    scaleX.range([0, width]);
    scaleXPercent = d3.scale.linear().domain([0, 110]).range([0, width]);
    scaleY.rangeRoundBands([0, height], .1);
    axisX = d3.svg.axis().scale(scaleX).orient('bottom').ticks(tickCount);
    axisY = d3.svg.axis().scale(scaleY).orient('left');
    el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg = (d3.select(el)).attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
    axis = svg.append('g').attr('class', 'x axis').attr('transform', "translate(0," + height + ")").call(axisX);
    axis.selectAll('text').style('text-anchor', 'end').attr('dx', '-.8em').attr('dy', '-.5em').attr('transform', 'rotate(-90)');
    axis.append('text').attr('x', width).attr('dy', '-.7em').style('text-anchor', 'end').text(varImp.method);
    svg.append('g').attr('class', 'y axis').call(axisY);
    svg.selectAll('.bar').data(varImp.data).enter().append('rect').attr('class', 'bar').attr('x', function(d) {
      return scaleX(0);
    }).attr('width', function(d) {
      return scaleX(d.value);
    }).attr('y', function(d) {
      return scaleY(d.columnName);
    }).attr('height', scaleY.rangeBand());
    svg.selectAll('.bar-label').data(varImp.data).enter().append('text').attr('class', 'bar-label').attr('x', function(d) {
      return scaleX(d.value);
    }).attr('y', function(d) {
      return scaleY(d.columnName);
    }).attr('dx', '0.2em').attr('dy', '1.2em').text(function(d) {
      return tickFormatX(d.value);
    });
    if (showPareto) {
      pointX = function(d) {
        return scaleXPercent(d.cumulativeScaledValue);
      };
      pointY = function(d) {
        return barHeight / 2 + scaleY(d.columnName);
      };
      line = d3.svg.line().x(pointX).y(pointY);
      svg.selectAll('.dot').data(varImp.data).enter().append('circle').attr('class', 'dot').attr('r', 2).attr('cx', pointX).attr('cy', pointY);
      svg.append('path').datum(varImp.data).attr('class', 'curve').attr('d', line);
      svg.selectAll('.dot-label').data(varImp.data).enter().append('text').attr('class', 'dot-label').attr('x', pointX).attr('y', pointY).attr('dx', '0.25em').attr('dy', '-0.25em').text(function(d) {
        return (Math.round(d.cumulativeScaledValue)) + '%';
      });
    }
    return el;
  };

  computeCumulativeScaledValues = function(varImp) {
    var cumulativeSum, datum, sum, _i, _j, _len, _len1, _ref, _ref1;
    sum = 0;
    _ref = varImp.data;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      datum = _ref[_i];
      sum += datum.value;
    }
    cumulativeSum = 0;
    _ref1 = varImp.data;
    for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
      datum = _ref1[_j];
      datum.cumulativeScaledValue = cumulativeSum += datum.value / sum * 100;
    }
    varImp.hasCumulativeScaledValues = true;
  };

  createVariableImportanceModel = function(inputColumnNames, variableImportances) {
    var data, sortedData, variables;
    variables = variableImportances.variables || inputColumnNames;
    data = times(variableImportances.varimp.length, function(index) {
      return {
        columnName: variables[index] || '',
        value: variableImportances.varimp[index],
        cumulativeScaledValue: 0,
        hasCumulativeScaledValues: false
      };
    });
    sortedData = sortBy(data, function(datum) {
      return -datum.value;
    });
    return {
      method: variableImportances.method,
      data: sortedData.length < variableImportances.max_var ? sortedData : sortedData.slice(0, variableImportances.max_var)
    };
  };

  Steam.ModelView = function(_, _model) {
    var collateCompatibleFrames, collateParameters, collateSummary, kv, loadCompatibleFrames, stringify, _compatibleFrames, _compatibleFramesCount, _hasVariableImportance, _nonRawFrames, _showParetoCurve, _variableImportanceChart, _variableImportances;
    stringify = function(value) {
      if (isArray(value)) {
        return join(value, ', ');
      } else {
        return value;
      }
    };
    kv = function(key, value) {
      return {
        key: key,
        value: stringify(value)
      };
    };
    collateSummary = function(model) {
      return [kv('Response Column', model.response_column_name), kv('Model Category', model.model_category)];
    };
    collateParameters = function(model) {
      var parameters;
      parameters = [pairs(model.critical_parameters), pairs(model.secondary_parameters), pairs(model.expert_parameters)];
      return map(flatten(parameters, true), function(_arg) {
        var key, value;
        key = _arg[0], value = _arg[1];
        return kv(key, value);
      });
    };
    collateCompatibleFrames = function(frames) {
      return map(frames, function(frame) {
        return {
          frameKey: frame.key,
          columns: join(frame.column_names, ', '),
          inspect: function() {
            return _.inspect(Steam.FrameInspectionView(_, frame));
          }
        };
      });
    };
    _nonRawFrames = filter(_model.compatible_frames, function(frame) {
      return !frame.is_raw_frame;
    });
    _compatibleFrames = collateCompatibleFrames(_nonRawFrames);
    _compatibleFramesCount = "(" + _nonRawFrames.length + ")";
    _hasVariableImportance = isTruthy(_model.variable_importances);
    if (_hasVariableImportance) {
      _variableImportances = createVariableImportanceModel(_model.input_column_names, _model.variable_importances);
      _showParetoCurve = node$(false);
      _variableImportanceChart = lift$(_showParetoCurve, function(showParetoCurve) {
        if (showParetoCurve) {
          if (!_variableImportances.hasCumulativeScaledValues) {
            computeCumulativeScaledValues(_variableImportances);
          }
          return createVariableImportanceChart(_variableImportances, _.measureTextWidth, true);
        } else {
          return createVariableImportanceChart(_variableImportances, _.measureTextWidth, false);
        }
      });
    }
    loadCompatibleFrames = function() {
      return _.switchToFrames({
        type: 'compatibleWithModel',
        modelKey: _model.key
      });
    };
    return {
      data: _model,
      key: _model.key,
      timestamp: _model.creation_epoch_time_millis,
      summary: collateSummary(_model),
      parameters: collateParameters(_model),
      inputColumns: _model.input_column_names,
      inputColumnsCount: "(" + _model.input_column_names.length + ")",
      compatibleFrames: _compatibleFrames,
      compatibleFramesCount: _compatibleFramesCount,
      loadCompatibleFrames: loadCompatibleFrames,
      hasVariableImportance: _hasVariableImportance,
      variableImportanceChart: _variableImportanceChart,
      showParetoCurve: _showParetoCurve,
      template: 'model-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.FrameInspectionView = function(_, _frame) {
    return {
      title: _frame.key,
      key: _frame.key,
      columns: _frame.column_names,
      columnCount: "(" + _frame.column_names.length + ")",
      isRawFrame: _frame.is_raw_frame,
      template: 'frame-inspection-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.ModelInspectionView = function(_, _model) {
    var collateParameters, collateSummary, kv, stringify;
    stringify = function(value) {
      if (isArray(value)) {
        return join(value, ', ');
      } else {
        return value;
      }
    };
    kv = function(key, value) {
      return {
        key: key,
        value: stringify(value)
      };
    };
    collateSummary = function(model) {
      return [kv('Response Column', model.response_column_name), kv('Model Category', model.model_category)];
    };
    collateParameters = function(model) {
      var parameters;
      parameters = [pairs(model.critical_parameters), pairs(model.secondary_parameters), pairs(model.expert_parameters)];
      return map(flatten(parameters, true), function(_arg) {
        var key, value;
        key = _arg[0], value = _arg[1];
        return kv(key, value);
      });
    };
    return {
      data: _model,
      key: _model.key,
      timestamp: _model.creation_epoch_time_millis,
      summary: collateSummary(_model),
      parameters: collateParameters(_model),
      inputColumns: _model.input_column_names,
      inputColumnsCount: "(" + _model.input_column_names.length + ")",
      template: 'model-inspection-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  var defaultScoringSelectionMessage;

  defaultScoringSelectionMessage = 'Score selected models.';

  Steam.ModelSelectionView = function(_) {
    var clearSelections, scoreSelections, tryScoreSelections, _canScoreSelections, _caption, _compatibleFrames, _hasSelection, _modelSelectionMessage, _selections;
    _selections = nodes$([]);
    _hasSelection = lift$(_selections, function(selections) {
      return selections.length > 0;
    });
    _caption = lift$(_selections, function(selections) {
      return "" + (describeCount(selections.length, 'model')) + " selected.";
    });
    _compatibleFrames = lift$(_selections, function(selections) {
      var commonFrameKeys, framesByKey, framesPerModel;
      framesPerModel = map(selections, function(selection) {
        return selection.data.compatible_frames;
      });
      framesByKey = indexBy(flatten(framesPerModel), function(frame) {
        return frame.key;
      });
      commonFrameKeys = sortBy(intersection.apply(null, map(framesPerModel, function(frames) {
        return map(frames, function(frame) {
          return frame.key;
        });
      })));
      return map(commonFrameKeys, function(key) {
        return framesByKey[key];
      });
    });
    _canScoreSelections = lift$(_compatibleFrames, function(frames) {
      return frames.length > 0;
    });
    _modelSelectionMessage = lift$(_compatibleFrames, function(frames) {
      if (frames.length) {
        return defaultScoringSelectionMessage;
      } else {
        return 'No compatible datasets found.';
      }
    });
    scoreSelections = function() {
      return _.promptForFrame(_compatibleFrames(), function(action, frameKey) {
        var scorings;
        switch (action) {
          case 'confirm':
            scorings = map(_selections(), function(selection) {
              return {
                frameKey: frameKey,
                model: selection.data,
                status: null,
                time: null,
                result: null,
                timestamp: Date.now()
              };
            });
            _.switchToScoring({
              type: 'scoring',
              scorings: scorings
            });
            return _.deselectAllModels();
        }
      });
    };
    tryScoreSelections = function(hover) {
      return _.status(hover ? _modelSelectionMessage() : null);
    };
    clearSelections = function() {
      return _.deselectAllModels();
    };
    link$(_.modelSelectionChanged, function(isSelected, model) {
      if (isSelected) {
        return _selections.push(model);
      } else {
        return _selections.remove(model);
      }
    });
    link$(_.modelSelectionCleared, function() {
      return _selections.removeAll();
    });
    return {
      caption: _caption,
      hasSelection: _hasSelection,
      clearSelections: clearSelections,
      canScoreSelections: _canScoreSelections,
      tryScoreSelections: tryScoreSelections,
      scoreSelections: scoreSelections,
      template: 'model-selection-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  var aucCategories, aucCategoryMap, aucCriteria, aucCriteriaMap, aucOutputMap, aucOutputs, aucVariableMap, aucVariables, createRocMarkInspection, createScoringInspection, createStripPlotRowInspection, createStripPlotValueInspection, createThresholdPlotInspection, format4f;

  if (typeof exports === "undefined" || exports === null) {
    format4f = d3.format('.4f');
  }

  aucCriteria = [
    {
      key: 'maximum F1',
      caption: 'Max F1'
    }, {
      key: 'maximum F2',
      caption: 'Max F2'
    }, {
      key: 'maximum F0point5',
      caption: 'Max F0.5'
    }, {
      key: 'maximum Accuracy',
      caption: 'Max Accuracy'
    }, {
      key: 'maximum Precision',
      caption: 'Max Precision'
    }, {
      key: 'maximum Recall',
      caption: 'Max Recall'
    }, {
      key: 'maximum Specificity',
      caption: 'Max Specificity'
    }, {
      key: 'maximum absolute MCC',
      caption: 'Max Absolute MCC'
    }, {
      key: 'minimizing max per class Error',
      caption: 'Min MPCE'
    }
  ];

  aucOutputs = [
    {
      key: 'threshold_for_criteria',
      caption: 'Threshold',
      domain: [0, 1]
    }, {
      key: 'error_for_criteria',
      caption: 'Error',
      domain: [0, 1]
    }, {
      key: 'F0point5_for_criteria',
      caption: 'F0.5',
      domain: [0, 1]
    }, {
      key: 'F1_for_criteria',
      caption: 'F1',
      domain: [0, 1]
    }, {
      key: 'F2_for_criteria',
      caption: 'F2',
      domain: [0, 1]
    }, {
      key: 'accuracy_for_criteria',
      caption: 'Accuracy',
      domain: [0, 1]
    }, {
      key: 'precision_for_criteria',
      caption: 'Precision',
      domain: [0, 1]
    }, {
      key: 'recall_for_criteria',
      caption: 'Recall',
      domain: [0, 1]
    }, {
      key: 'specificity_for_criteria',
      caption: 'Specificity',
      domain: [0, 1]
    }, {
      key: 'mcc_for_criteria',
      caption: 'MCC',
      domain: [-1, 1]
    }, {
      key: 'max_per_class_error_for_criteria',
      caption: 'MPCE',
      domain: [0, 1]
    }
  ];

  aucCategories = (function() {
    var categories, criterion, criterionIndex, output, _i, _j, _len, _len1;
    categories = [
      {
        index: 0,
        key: 'AUC',
        caption: 'AUC',
        domain: [0, 1],
        isGrouped: false
      }, {
        index: 0,
        key: 'Gini',
        caption: 'Gini',
        domain: [0, 1],
        isGrouped: false
      }
    ];
    for (criterionIndex = _i = 0, _len = aucCriteria.length; _i < _len; criterionIndex = ++_i) {
      criterion = aucCriteria[criterionIndex];
      for (_j = 0, _len1 = aucOutputs.length; _j < _len1; _j++) {
        output = aucOutputs[_j];
        categories.push({
          index: 0,
          key: "" + criterion.caption + "\0" + output.caption,
          caption: "" + criterion.caption + " - " + output.caption,
          domain: output.domain,
          isGrouped: true,
          criterion: criterion,
          output: output,
          criterionIndex: criterionIndex
        });
      }
    }
    return map(categories, function(category, index) {
      category.index = index;
      return category;
    });
  })();

  aucVariables = [['Threshold', [0, 1]], ['Error', [0, 1]], ['F0.5', [0, 1]], ['F1', [0, 1]], ['F2', [0, 1]], ['Accuracy', [0, 1]], ['Precision', [0, 1]], ['Recall', [0, 1]], ['Specificity', [0, 1]], ['MCC', [-1, 1]], ['MPCE', [0, 1]], ['TPR', [0, 1]], ['FPR', [0, 1]]].map(function(attr) {
    var domain, key;
    key = attr[0], domain = attr[1];
    return {
      key: key,
      caption: key,
      domain: domain
    };
  });

  aucCriteriaMap = indexBy(aucCriteria, function(criterion) {
    return criterion.key;
  });

  aucOutputMap = indexBy(aucOutputs, function(output) {
    return output.key;
  });

  aucCategoryMap = indexBy(aucCategories, function(cateogory) {
    return cateogory.key;
  });

  aucVariableMap = indexBy(aucVariables, function(variable) {
    return variable.key;
  });

  createThresholdPlotInspection = function(series, mark) {
    var div, formatConfusionMatrix, grid, h1, h2, table, tabulateProperties, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed table.table.table-bordered tbody tr th td')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], grid = _ref[4], tbody = _ref[5], tr = _ref[6], th = _ref[7], td = _ref[8];
    formatConfusionMatrix = function(domain, cm) {
      var d1, d2, fn, fp, tn, tp, _ref1, _ref2;
      d1 = domain[0], d2 = domain[1];
      (_ref1 = cm[0], tn = _ref1[0], fp = _ref1[1]), (_ref2 = cm[1], fn = _ref2[0], tp = _ref2[1]);
      return grid([tr([th(''), th(d1), th(d2)]), tr([th(d1), td(tn), td(fp)]), tr([th(d2), td(fn), td(tp)])]);
    };
    tabulateProperties = function(mark) {
      return table(tbody(map(aucVariables, function(variable) {
        var term, value;
        term = property[0], value = property[1];
        return tr([th(variable.caption), td(format4f(mark[variable.key]))]);
      })));
    };
    return div([h1(series.caption), h2('Outputs'), tabulateProperties(mark), h2('Confusion Matrix'), formatConfusionMatrix(series.metrics.auc.actual_domain, mark['Confusion Matrix'])]);
  };

  createRocMarkInspection = function(metrics, mark) {
    var auc, collectProperties, div, formatConfusionMatrix, grid, h1, h2, table, tabulateProperties, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed table.table.table-bordered tbody tr th td')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], grid = _ref[4], tbody = _ref[5], tr = _ref[6], th = _ref[7], td = _ref[8];
    formatConfusionMatrix = function(domain, cm) {
      var d1, d2, fn, fp, tn, tp, _ref1, _ref2;
      d1 = domain[0], d2 = domain[1];
      (_ref1 = cm[0], tn = _ref1[0], fp = _ref1[1]), (_ref2 = cm[1], fn = _ref2[0], tp = _ref2[1]);
      return grid([tr([th(''), th(d1), th(d2)]), tr([th(d1), td(tn), td(fp)]), tr([th(d2), td(fn), td(tp)])]);
    };
    collectProperties = function(auc, index) {
      return [['Threshold', format4f(auc.thresholds[index])], ['Error', format4f(auc.errorr[index])], ['F0.5', format4f(auc.F0point5[index])], ['F1', format4f(auc.F1[index])], ['F2', format4f(auc.F2[index])], ['Accuracy', format4f(auc.accuracy[index])], ['Precision', format4f(auc.precision[index])], ['Recall', format4f(auc.recall[index])], ['Specificity', format4f(auc.specificity[index])], ['MCC', format4f(auc.mcc[index])], ['MPCE', format4f(auc.max_per_class_error[index])], ['False Positive Rate', format4f(mark.fpr)], ['True Positive Rate', format4f(mark.tpr)]];
    };
    tabulateProperties = function(auc, index) {
      var properties;
      properties = collectProperties(auc, index);
      return table(tbody(map(properties, function(property) {
        var term, value;
        term = property[0], value = property[1];
        return tr([th(term), td(value)]);
      })));
    };
    auc = metrics.metrics.auc;
    return div([h1(metrics.caption), h2('Outputs'), tabulateProperties(auc, mark.index), h2('Confusion Matrix'), formatConfusionMatrix(auc.actual_domain, auc.confusion_matrices[mark.index])]);
  };

  createStripPlotRowInspection = function(series, category) {
    var div, h1, rows, sortedRows, table, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 table.table.table-condensed tbody tr th td')), div = _ref[0], h1 = _ref[1], table = _ref[2], tbody = _ref[3], tr = _ref[4], th = _ref[5], td = _ref[6];
    rows = map(series, function(series) {
      return {
        caption: series.caption,
        value: series.outputs[category.key]
      };
    });
    sortedRows = sortBy(rows, function(row) {
      return -row.value;
    });
    return div([
      h1(category.caption), table(tbody(map(sortedRows, function(row) {
        return tr([th(row.caption), td(isNaN(row.value) ? 'NaN' : format4f(row.value))]);
      })))
    ]);
  };

  createStripPlotValueInspection = function(series) {
    var div, h1, h2, table, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed tbody tr th td')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], tbody = _ref[4], tr = _ref[5], th = _ref[6], td = _ref[7];
    return div([
      h1(series.caption), table(tbody(map(aucCategories, function(category) {
        var value;
        value = series.outputs[category.key];
        return tr([th(category.caption), td(isNaN(value) ? 'NaN' : format4f(value))]);
      })))
    ]);
  };

  createScoringInspection = function(series) {
    var createStripPlotMarkInspectionTable, div, groupedCategories, groupedCategoriesByOutput, h1, h2, table, tbody, td, th, tr, ungroupedCategories, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed tbody tr th td')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], tbody = _ref[4], tr = _ref[5], th = _ref[6], td = _ref[7];
    createStripPlotMarkInspectionTable = function(series, categories) {
      return table(tbody(map(categories, function(category) {
        var value;
        value = series.outputs[category.key];
        return tr([th(category.isGrouped ? category.criterion.caption : category.caption), td(isNaN(value) ? 'NaN' : format4f(value))]);
      })));
    };
    ungroupedCategories = filter(aucCategories, function(category) {
      return !category.isGrouped;
    });
    groupedCategories = filter(aucCategories, function(category) {
      return category.isGrouped;
    });
    groupedCategoriesByOutput = groupBy(groupedCategories, function(category) {
      return category.output.caption;
    });
    return div([
      h1(series.caption), h2('Outputs'), createStripPlotMarkInspectionTable(series, ungroupedCategories), div(mapWithKey(groupedCategoriesByOutput, function(categories, caption) {
        return div([h2(caption), createStripPlotMarkInspectionTable(series, categories)]);
      }))
    ]);
  };

  Steam.ScoringView = function(_, _scoring) {
    var buildAucCategories, collateInputParameters, combineInputParameters, compareInputParameters, computeTPRandFPR, computeTPRandFPR2, configureStripPlot, createComparisonTable, createInputAndOutputVariables, createInputParameterAndValue, createInputParameterForDisplay, createMarkForScoringMetrics, createMarksForThresholdMetrics, createMetricsPlot, createModelSummary, createRocCurve, createScoringList, createSeriesFromMetrics, createStripPlot, createStripPlotParameters2, createStripPlotParameters3, createThresholdPlot, generateComparison, initialize, markAsDifferent, renderMetricsPlot, renderRocCurve, renderStripPlot, renderThresholdPlot, switchToAdvancedView, switchToSheetView, switchToTabularView, _caption, _categories, _comparisonMode, _comparisonPlot, _comparisonTable, _failure, _hasFailed, _inputOutputCategories, _inputOutputPlot, _inputOutputPlotX, _inputOutputPlotY, _isAdvancedComparisonView, _isComparisonView, _isScoringView, _isSheetView, _isTabularComparisonView, _modelSummary, _multiRocPlot, _scoringList, _scoringType, _selectedCategory, _sheetView, _stripPlot, _stripPlotParameters, _tag, _thresholdPlot, _thresholdPlotVariables, _thresholdPlotX, _thresholdPlotY, _timestamp;
    _tag = node$('');
    _caption = node$('');
    _timestamp = node$(Date.now());
    _comparisonTable = node$(null);
    _scoringList = node$(null);
    _categories = node$(null);
    _selectedCategory = node$(aucCategoryMap.AUC);
    _comparisonPlot = node$(null);
    _inputOutputCategories = node$(null);
    _inputOutputPlotX = node$(null);
    _inputOutputPlotY = node$(null);
    _inputOutputPlot = node$(null);
    _multiRocPlot = node$(null);
    _thresholdPlotVariables = sortBy(aucVariables, function(variable) {
      return variable.caption;
    });
    _thresholdPlotX = node$(aucVariableMap.Threshold);
    _thresholdPlotY = node$(aucVariableMap.Error);
    _thresholdPlot = node$(null);
    _stripPlot = node$(null);
    _stripPlotParameters = {
      group1: node$(null),
      group2: node$(null),
      group3: node$(null)
    };
    _modelSummary = nodes$([]);
    _hasFailed = node$(false);
    _failure = node$(null);
    _scoringType = node$(null);
    _isScoringView = lift$(_scoringType, function(type) {
      return type === 'scoring';
    });
    _isComparisonView = lift$(_scoringType, function(type) {
      return type === 'comparison';
    });
    _comparisonMode = node$('tabular');
    _isTabularComparisonView = lift$(_comparisonMode, function(mode) {
      return mode === 'tabular';
    });
    _isAdvancedComparisonView = lift$(_comparisonMode, function(mode) {
      return mode === 'advanced';
    });
    _isSheetView = lift$(_comparisonMode, function(mode) {
      return mode === 'sheet';
    });
    switchToTabularView = function() {
      return _comparisonMode('tabular');
    };
    switchToAdvancedView = function() {
      return _comparisonMode('advanced');
    };
    switchToSheetView = function() {
      return _comparisonMode('sheet');
    };
    _sheetView = node$(null);
    createModelSummary = function(model) {
      return [
        {
          key: 'Model Category',
          value: model.model_category
        }, {
          key: 'Response Column',
          value: model.response_column_name
        }
      ];
    };
    initialize = function(item) {
      var comparison, input, scoring, scorings;
      switch (item.type) {
        case 'scoring':
          scoring = item;
          input = scoring.data.input;
          _tag('Scoring');
          _caption("Scoring on " + input.frameKey);
          _modelSummary(createModelSummary(input.model));
          apply$(scoring.isReady, scoring.hasFailed, function(isReady, hasFailed) {
            if (isReady) {
              if (hasFailed) {
                _hasFailed(true);
                return _failure(scoring.data.output);
              } else {
                _timestamp((head(scoring.data.output.metrics)).scoring_time);
                return _comparisonTable(createComparisonTable([scoring]));
              }
            }
          });
          break;
        case 'comparison':
          comparison = item;
          _tag('Comparison');
          _caption("Scoring Comparison");
          _timestamp(comparison.data.timestamp);
          _modelSummary(null);
          scorings = comparison.data.scorings;
          apply$(_comparisonMode, function(mode) {
            var areModelsComparable, defaultInputVariable, defaultOutputVariable, inputAndOutputVariables, inputParameterKeys, inputParameters, series, sheetView, _ref, _ref1, _ref2;
            switch (mode) {
              case 'tabular':
                if (scorings.length > 0) {
                  return _comparisonTable(createComparisonTable(scorings));
                } else {
                  return _comparisonTable(null);
                }
                break;
              case 'advanced':
                if (scorings.length > 0) {
                  series = createSeriesFromMetrics(scorings);
                  areModelsComparable = same(series, function(a, b) {
                    return a.model.model_category === b.model.model_category && a.model.model_algorithm === b.model.model_algorithm;
                  });
                  if (areModelsComparable) {
                    _ref = collateInputParameters(series), inputParameterKeys = _ref[0], inputParameters = _ref[1];
                    _ref1 = createInputAndOutputVariables(inputParameterKeys, inputParameters, aucCategories), inputAndOutputVariables = _ref1[0], defaultInputVariable = _ref1[1], defaultOutputVariable = _ref1[2];
                  } else {
                    _ref2 = createInputAndOutputVariables([], [], aucCategories), inputAndOutputVariables = _ref2[0], defaultInputVariable = _ref2[1], defaultOutputVariable = _ref2[2];
                  }
                  _inputOutputPlotX(defaultInputVariable);
                  _inputOutputPlotY(defaultOutputVariable);
                  _inputOutputCategories(inputAndOutputVariables);
                  apply$(_inputOutputPlotX, _inputOutputPlotY, function(x, y) {
                    return _inputOutputPlot(createMetricsPlot(series, x, y));
                  });
                  _scoringList(createScoringList(series));
                  _categories(aucCategories);
                  apply$(_selectedCategory, function(category) {
                    return _comparisonPlot(generateComparison(category, series));
                  });
                  _multiRocPlot(createThresholdPlot(series, 'FPR', 'TPR', true));
                  apply$(_thresholdPlotX, _thresholdPlotY, function(x, y) {
                    return _thresholdPlot(createThresholdPlot(series, x.key, y.key, false));
                  });
                  _stripPlotParameters.group1([]);
                  _stripPlotParameters.group2(map(aucCriteria, createStripPlotParameters2));
                  _stripPlotParameters.group3(map(aucOutputs, createStripPlotParameters3));
                  return _stripPlot(createStripPlot(series, aucCategories));
                } else {
                  _scoringList(null);
                  _comparisonPlot(null);
                  _multiRocPlot(null);
                  _thresholdPlot(null);
                  return _stripPlot(null);
                }
                break;
              case 'sheet':
                sheetView = _sheetView();
                if (!sheetView) {
                  return _sheetView(Steam.ScoringSheetView(_, scorings));
                }
            }
          });
      }
      return _scoringType(item.type);
    };
    createStripPlotParameters2 = function(criterion) {
      return {
        id: "y-" + (uniqueId()),
        caption: criterion.caption,
        criterion: criterion,
        isSelected: node$(false)
      };
    };
    createStripPlotParameters3 = function(output) {
      var isSelected;
      isSelected = node$(false);
      return {
        id: "y-" + (uniqueId()),
        caption: output.caption,
        output: output,
        isSelected: node$(false)
      };
    };
    renderRocCurve = function(data) {
      var axisX, axisY, el, height, line, margin, svg, width, x, y;
      margin = {
        top: 20,
        right: 20,
        bottom: 20,
        left: 30
      };
      width = 175;
      height = 175;
      x = d3.scale.linear().domain([0, 1]).range([0, width]);
      y = d3.scale.linear().domain([0, 1]).range([height, 0]);
      axisX = d3.svg.axis().scale(x).orient('bottom').ticks(5);
      axisY = d3.svg.axis().scale(y).orient('left').ticks(5);
      line = d3.svg.line().x(function(d) {
        return x(d.fpr);
      }).y(function(d) {
        return y(d.tpr);
      });
      el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      svg = (d3.select(el)).attr('class', 'y-roc-curve').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
      svg.append('g').attr('class', 'x axis').attr('transform', "translate(0, " + height + ")").call(axisX).append('text').attr('x', width).attr('y', -6).style('text-anchor', 'end').text('FPR');
      svg.append('g').attr('class', 'y axis').call(axisY).append('text').attr('transform', 'rotate(-90)').attr('y', 6).attr('dy', '.71em').style('text-anchor', 'end').text('TPR');
      svg.append('line').attr('class', 'guide').attr('stroke-dasharray', '3,3').attr({
        x1: x(0),
        y1: y(0),
        x2: x(1),
        y2: y(1)
      });
      svg.selectAll('.dot').data(data).enter().append('circle').attr('class', 'dot').attr('r', 1).attr('cx', function(d) {
        return x(d.fpr);
      }).attr('cy', function(d) {
        return y(d.tpr);
      });
      svg.append('path').datum(data).attr('class', 'line').attr('d', line);
      return el;
    };
    computeTPRandFPR2 = function(cm, index) {
      var fn, fp, tn, tp, _ref, _ref1;
      (_ref = cm[0], tn = _ref[0], fp = _ref[1]), (_ref1 = cm[1], fn = _ref1[0], tp = _ref1[1]);
      return [tp / (tp + fn), fp / (fp + tn)];
    };
    computeTPRandFPR = function(cm, index) {
      var fn, fp, tn, tp, _ref, _ref1;
      (_ref = cm[0], tn = _ref[0], fp = _ref[1]), (_ref1 = cm[1], fn = _ref1[0], tp = _ref1[1]);
      return {
        cm: cm,
        index: index,
        tpr: tp / (tp + fn),
        fpr: fp / (fp + tn)
      };
    };
    createRocCurve = function(cms) {
      var rates;
      rates = map(cms, computeTPRandFPR);
      return renderRocCurve(rates);
    };
    createInputParameterForDisplay = function(key, value, isVisible) {
      var scalarValue;
      scalarValue = isArray(value) ? value.join(', ') : value;
      return {
        key: key,
        value: scalarValue,
        isVisible: isVisible,
        isDifferent: false
      };
    };
    createInputParameterAndValue = function(value, key) {
      var scalarValue;
      scalarValue = isArray(value) ? value.join(', ') : value;
      return {
        key: key,
        value: scalarValue,
        isNumber: isNumber(value)
      };
    };
    createInputAndOutputVariables = function(inputKeys, inputParameters, aucVariables) {
      var allVariables, defaultInputVariable, defaultOutputVariable, inputVariables, outputVariables;
      inputVariables = map(inputKeys, function(inputKey) {
        var values;
        values = map(inputParameters, function(parameter) {
          return parameter[inputKey];
        });
        return {
          type: 'input',
          key: inputKey,
          caption: "Input: " + inputKey,
          domain: d3.extent(values)
        };
      });
      outputVariables = map(aucVariables, function(variable) {
        return {
          type: 'output',
          key: variable.key,
          caption: "Output: " + variable.caption,
          variable: variable
        };
      });
      allVariables = sortBy(flatten([inputVariables, outputVariables]), function(variable) {
        return variable.caption;
      });
      defaultInputVariable = inputVariables.length > 0 ? head(inputVariables) : outputVariables[1];
      defaultOutputVariable = head(outputVariables);
      return [allVariables, defaultInputVariable, defaultOutputVariable];
    };
    collateInputParameters = function(series) {
      var i, inputParameters, key, models, numericParametersByModel, parameter, parameters, parametersByKey, parametersByModel, plottableParameterKeys, _i, _j, _len, _len1, _ref;
      models = map(series, function(series) {
        return series.model;
      });
      parametersByModel = map(models, function(model) {
        return flatten([mapWithKey(model.critical_parameters, createInputParameterAndValue), mapWithKey(model.secondary_parameters, createInputParameterAndValue), mapWithKey(model.expert_parameters, createInputParameterAndValue)]);
      });
      numericParametersByModel = map(parametersByModel, function(parameters) {
        return filter(parameters, function(parameter) {
          return parameter.isNumber;
        });
      });
      parametersByKey = groupBy(flatten(numericParametersByModel), function(parameter) {
        return parameter.key;
      });
      plottableParameterKeys = [];
      for (key in parametersByKey) {
        parameters = parametersByKey[key];
        if (parameters.length === models.length) {
          plottableParameterKeys.push(key);
        }
      }
      inputParameters = times(models.length, function() {
        return {};
      });
      for (_i = 0, _len = plottableParameterKeys.length; _i < _len; _i++) {
        key = plottableParameterKeys[_i];
        _ref = parametersByKey[key];
        for (i = _j = 0, _len1 = _ref.length; _j < _len1; i = ++_j) {
          parameter = _ref[i];
          inputParameters[i][key] = parameter.value;
        }
      }
      forEach(series, function(series, i) {
        return series.inputs = inputParameters[i];
      });
      return [plottableParameterKeys, inputParameters];
    };
    combineInputParameters = function(model) {
      var critical, secondary;
      critical = mapWithKey(model.critical_parameters, function(value, key) {
        return createInputParameterForDisplay(key, value, true);
      });
      secondary = mapWithKey(model.secondary_parameters, function(value, key) {
        return createInputParameterForDisplay(key, value, false);
      });
      return concat(critical, secondary);
    };
    markAsDifferent = function(parametersArray, index) {
      var parameter, parameters, _i, _len;
      for (_i = 0, _len = parametersArray.length; _i < _len; _i++) {
        parameters = parametersArray[_i];
        parameter = parameters[index];
        parameter.isDifferent = true;
        parameter.isVisible = true;
      }
    };
    compareInputParameters = function(parametersArray) {
      var headParameters, index, parameters, tailParameters, tailParametersArray, _i, _j, _len, _len1;
      headParameters = head(parametersArray);
      tailParametersArray = tail(parametersArray);
      for (index = _i = 0, _len = headParameters.length; _i < _len; index = ++_i) {
        parameters = headParameters[index];
        for (_j = 0, _len1 = tailParametersArray.length; _j < _len1; _j++) {
          tailParameters = tailParametersArray[_j];
          if (parameters.value !== tailParameters[index].value) {
            markAsDifferent(parametersArray, index);
            break;
          }
        }
      }
    };
    renderStripPlot = function(series, categories) {
      var axis, el, g, height, line, margin, path, rowHeight, scaleX, scaleY, svg, width, x;
      margin = {
        top: 20,
        right: 70,
        bottom: 20,
        left: 140
      };
      width = 140;
      rowHeight = 18;
      height = categories.length * rowHeight;
      scaleX = zipObject(map(categories, function(category) {
        scaleX = d3.scale.linear().domain(category.domain).range([0, width]);
        return [category.key, scaleX];
      }));
      scaleY = d3.scale.ordinal().domain(map(categories, function(category) {
        return category.key;
      })).rangePoints([0, height], 1);
      line = d3.svg.line();
      axis = d3.svg.axis().orient('left');
      x = function(value) {
        if (isNaN(value)) {
          return 0;
        } else {
          return value;
        }
      };
      path = function(d) {
        return line(map(categories, function(category) {
          var key;
          key = category.key;
          return [scaleX[key](x(d.outputs[key])), scaleY(key)];
        }));
      };
      el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      svg = (d3.select(el)).attr('class', 'y-strip-plot').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
      line = svg.append('g').attr('class', 'line').selectAll('path').data(series).enter().append('path').attr('d', path).attr('id', function(d) {
        return "strip-plot-" + d.id + "-path";
      });
      forEach(series, function(series) {
        return svg.append('g').attr('id', "strips-" + series.id).selectAll('.strip').data(categories).enter().append('line').attr('class', 'strip').attr('x1', function(d) {
          return scaleX[d.key](x(series.outputs[d.key]));
        }).attr('y1', function(d) {
          return -5 + scaleY(d.key);
        }).attr('x2', function(d) {
          return scaleX[d.key](x(series.outputs[d.key]));
        }).attr('y2', function(d) {
          return 5 + scaleY(d.key);
        }).attr('stroke', series.color).on('mouseover', function(d) {
          svg.select("#strip-plot-" + series.id + "-path").style('stroke', '#ddd');
          return svg.select("#strip-plot-" + series.id + "-labels").style('display', 'block');
        }).on('mouseout', function(d) {
          svg.select("#strip-plot-" + series.id + "-path").style('stroke', 'none');
          return svg.select("#strip-plot-" + series.id + "-labels").style('display', 'none');
        }).on('click', function(d) {
          return _.inspect({
            content: createStripPlotValueInspection(series),
            template: 'geyser'
          });
        });
      });
      g = svg.selectAll('.category').data(categories).enter().append('g').attr('transform', function(d) {
        return "translate(" + (-margin.left) + ", " + (scaleY(d.key)) + ")";
      });
      g.append('text').attr('class', 'labels').attr('dy', 5).text(function(d) {
        return d.caption;
      }).on('click', function(d) {
        return _.inspect({
          content: createStripPlotRowInspection(series, d),
          template: 'geyser'
        });
      });
      forEach(series, function(series) {
        return svg.append('g').attr('id', "strip-plot-" + series.id + "-labels").attr('transform', function(d) {
          return "translate(" + (width + 10) + ")";
        }).style('display', 'none').selectAll('.label').data(categories).enter().append('text').attr('transform', function(d) {
          return "translate(0, " + (scaleY(d.key)) + ")";
        }).attr('dy', 5).text(function(d) {
          var value;
          value = series.outputs[d.key];
          if (isNaN(value)) {
            return 'NaN';
          } else {
            return format4f(value);
          }
        });
      });
      g.append('line').attr('class', 'guide').attr('x1', 0).attr('y1', rowHeight / 2).attr('x2', margin.left + width).attr('y2', rowHeight / 2);
      return el;
    };
    buildAucCategories = function() {
      var categories, criterion, criterionIndex, id, output, _i, _j, _len, _len1;
      categories = [];
      id = 0;
      for (criterionIndex = _i = 0, _len = aucCriteria.length; _i < _len; criterionIndex = ++_i) {
        criterion = aucCriteria[criterionIndex];
        for (_j = 0, _len1 = aucOutputs.length; _j < _len1; _j++) {
          output = aucOutputs[_j];
          categories.push({
            id: id,
            caption: "" + criterion.caption + " - " + output.caption,
            criterion: criterion,
            output: output,
            criterionIndex: criterionIndex,
            domain: [0, 1]
          });
          id++;
        }
      }
      return {
        criteria: aucCriteria,
        outputs: aucOutputs,
        categories: categories
      };
    };
    generateComparison = function(category, series) {
      var filteredSeries, scale, sortedSeries, span;
      filteredSeries = filter(series, function(series) {
        return !isNaN(series.outputs[category.key]);
      });
      sortedSeries = sortBy(filteredSeries, function(series) {
        return -series.outputs[category.key];
      });
      span = 300;
      scale = d3.scale.linear().domain(category.domain).range([0, span]);
      return map(sortedSeries, function(series) {
        var left, origin, value, width, x;
        value = series.outputs[category.key];
        origin = scale(0);
        x = scale(value);
        if (x > origin) {
          left = origin;
          width = x - origin;
        } else if (x < origin) {
          left = x;
          width = origin - x;
        } else {
          left = 0;
          width = 1;
        }
        return {
          caption: series.caption,
          value: format4f(value),
          span: "" + span + "px",
          width: "" + width + "px",
          left: "" + left + "px",
          color: series.color,
          inspect: function() {
            return _.inspect({
              content: createScoringInspection(series),
              template: 'geyser'
            });
          }
        };
      });
    };
    createScoringList = function(series) {
      return map(series, function(series) {
        return {
          caption: series.caption,
          color: series.color,
          inspect: function() {
            return _.inspect({
              content: createScoringInspection(series),
              template: 'geyser'
            });
          }
        };
      });
    };
    createSeriesFromMetrics = function(scores) {
      var colorScale, createUniqueScoringName, palette, uniqueScoringNames;
      uniqueScoringNames = {};
      createUniqueScoringName = function(frameKey, modelKey) {
        var index, name;
        name = "" + modelKey + " on " + frameKey;
        if (index = uniqueScoringNames[name]) {
          uniqueScoringNames[name] = index++;
          name += ' #' + index;
        } else {
          uniqueScoringNames[name] = 1;
        }
        return name;
      };
      palette = scores.length > 10 ? d3.scale.category20 : d3.scale.category10;
      colorScale = palette().domain(d3.range(scores.length));
      return map(scores, function(score, index) {
        var metrics, model;
        metrics = head(score.data.output.metrics);
        model = score.data.input.model;
        return {
          id: index,
          caption: createUniqueScoringName(metrics.frame.key, metrics.model.key),
          model: model,
          inputs: null,
          metrics: metrics,
          outputs: createMarkForScoringMetrics(metrics),
          thresholdMarks: createMarksForThresholdMetrics(metrics),
          color: colorScale(index)
        };
      });
    };
    createMarkForScoringMetrics = function(metrics) {
      var auc, category, mark, _i, _len;
      auc = metrics.auc;
      mark = {};
      for (_i = 0, _len = aucCategories.length; _i < _len; _i++) {
        category = aucCategories[_i];
        if (category.isGrouped) {
          mark[category.key] = +auc[category.output.key][category.criterionIndex];
        } else {
          mark[category.key] = +auc[category.key];
        }
      }
      return mark;
    };
    createMarksForThresholdMetrics = function(metrics) {
      var auc;
      auc = metrics.auc;
      return map(auc.thresholds, function(threshold, index) {
        var cm, fpr, tpr, _ref;
        cm = auc.confusion_matrices[index];
        _ref = computeTPRandFPR2(cm), tpr = _ref[0], fpr = _ref[1];
        return {
          'Threshold': +threshold,
          'Error': +auc.errorr[index],
          'F0.5': +auc.F0point5[index],
          'F1': +auc.F1[index],
          'F2': +auc.F2[index],
          'Accuracy': +auc.accuracy[index],
          'Precision': +auc.precision[index],
          'Recall': +auc.recall[index],
          'Specificity': +auc.specificity[index],
          'MCC': +auc.mcc[index],
          'MPCE': +auc.max_per_class_error[index],
          'Confusion Matrix': cm,
          'TPR': tpr,
          'FPR': fpr
        };
      });
    };
    renderMetricsPlot = function(series, variableX, variableY) {
      var axisX, axisY, el, height, isInputX, isInputY, line, margin, readX, readY, scaleX, scaleY, svg, width;
      margin = {
        top: 20,
        right: 20,
        bottom: 20,
        left: 30
      };
      width = 300;
      height = 300;
      isInputX = variableX.type === 'input';
      isInputY = variableY.type === 'input';
      readX = function(series) {
        if (isInputX) {
          return series.inputs[variableX.key];
        } else {
          return series.outputs[variableX.key];
        }
      };
      readY = function(series) {
        if (isInputY) {
          return series.inputs[variableY.key];
        } else {
          return series.outputs[variableY.key];
        }
      };
      scaleX = d3.scale.linear().domain(isInputX ? variableX.domain : variableX.variable.domain).range([0, width]).nice();
      scaleY = d3.scale.linear().domain(isInputY ? variableY.domain : variableY.variable.domain).range([height, 0]).nice();
      axisX = d3.svg.axis().scale(scaleX).orient('bottom').ticks(5);
      axisY = d3.svg.axis().scale(scaleY).orient('left').ticks(5);
      line = d3.svg.line().x(function(d) {
        return scaleX(readX(d));
      }).y(function(d) {
        return scaleY(readY(d));
      });
      el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      svg = (d3.select(el)).attr('class', 'y-metrics-plot').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
      svg.append('g').attr('class', 'x axis').attr('transform', "translate(0, " + height + ")").call(axisX).append('text').attr('x', width).attr('y', -6).style('text-anchor', 'end').text(variableX.caption);
      svg.append('g').attr('class', 'y axis').call(axisY).append('text').attr('transform', 'rotate(-90)').attr('y', 6).attr('dy', '.71em').style('text-anchor', 'end').text(variableY.caption);
      svg.selectAll('.dot').data(series).enter().append('circle').attr('class', 'dot').attr('r', 5).attr('cx', function(d) {
        return scaleX(readX(d));
      }).attr('cy', function(d) {
        return scaleY(readY(d));
      }).attr('stroke', function(d) {
        return d.color;
      }).on('click', function(d) {
        return _.inspect({
          content: createStripPlotValueInspection(d),
          template: 'geyser'
        });
      });
      return el;
    };
    renderThresholdPlot = function(series, attrX, attrY, showReferenceLine) {
      var axisX, axisY, curve, el, height, line, margin, scaleX, scaleY, svg, validMarks, variableX, variableY, width;
      variableX = aucVariableMap[attrX];
      variableY = aucVariableMap[attrY];
      margin = {
        top: 20,
        right: 20,
        bottom: 20,
        left: 30
      };
      width = 300;
      height = 300;
      validMarks = zipObject(map(series, function(series) {
        var marks;
        marks = filter(series.thresholdMarks, function(mark) {
          return (!isNaN(mark[attrX])) && (!isNaN(mark[attrY]));
        });
        return [series.id, marks];
      }));
      scaleX = d3.scale.linear().domain(variableX.domain).range([0, width]);
      scaleY = d3.scale.linear().domain(variableY.domain).range([height, 0]);
      axisX = d3.svg.axis().scale(scaleX).orient('bottom').ticks(5);
      axisY = d3.svg.axis().scale(scaleY).orient('left').ticks(5);
      line = d3.svg.line().x(function(d) {
        return scaleX(d[attrX]);
      }).y(function(d) {
        return scaleY(d[attrY]);
      });
      el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      svg = (d3.select(el)).attr('class', 'y-custom-plot').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
      svg.append('g').attr('class', 'x axis').attr('transform', "translate(0, " + height + ")").call(axisX).append('text').attr('x', width).attr('y', -6).style('text-anchor', 'end').text(variableX.caption);
      svg.append('g').attr('class', 'y axis').call(axisY).append('text').attr('transform', 'rotate(-90)').attr('y', 6).attr('dy', '.71em').style('text-anchor', 'end').text(variableY.caption);
      if (showReferenceLine) {
        svg.append('line').attr('class', 'guide').attr('stroke-dasharray', '3,3').attr({
          x1: scaleX(0),
          y1: scaleY(0),
          x2: scaleX(1),
          y2: scaleY(1)
        });
      }
      curve = svg.selectAll('.y-curve').data(series).enter().append('g').attr('class', 'y-curve');
      curve.append('path').attr('id', function(d) {
        return "curve" + d.id;
      }).attr('class', 'line').attr('d', function(d) {
        return line(validMarks[d.id]);
      }).style('stroke', function(d) {
        return d.color;
      });
      forEach(series, function(series) {
        return svg.append('g').selectAll('.dot').data(validMarks[series.id]).enter().append('circle').attr('class', 'dot').attr('r', 5).attr('cx', function(d) {
          return scaleX(d[attrX]);
        }).attr('cy', function(d) {
          return scaleY(d[attrY]);
        }).on('click', function(d) {
          return _.inspect({
            content: createThresholdPlotInspection(series, d),
            template: 'geyser'
          });
        }).on('mouseover', function(d) {
          return d3.select(this).style('stroke', series.color);
        }).on('mouseout', function(d) {
          return d3.select(this).style('stroke', 'none');
        });
      });
      return el;
    };
    createMetricsPlot = function(series, variableX, variableY) {
      var div, render;
      div = geyser.generate(['div'])[0];
      render = function($element) {
        var plot;
        plot = renderMetricsPlot(series, variableX, variableY);
        return $element.empty().append(plot);
      };
      return {
        markup: div(),
        behavior: render
      };
    };
    createThresholdPlot = function(series, attrX, attrY, showReferenceLine) {
      var div, render;
      div = geyser.generate(['div'])[0];
      render = function($element) {
        var plot;
        plot = renderThresholdPlot(series, attrX, attrY, showReferenceLine);
        return $element.empty().append(plot);
      };
      return {
        markup: div(),
        behavior: render
      };
    };
    createStripPlot = function(series, categories) {
      var div, render;
      div = geyser.generate(['div'])[0];
      render = function($element) {
        var stripPlot;
        stripPlot = renderStripPlot(series, categories);
        return $element.empty().append(stripPlot);
      };
      return {
        markup: div(),
        behavior: render
      };
    };
    createComparisonTable = function(scores) {
      var createComparisonGrid, createParameterTable, diffSpan, div, hyperlink, kvtable, table, tbody, td, tdId, th, thIndent, thWide, thead, tr, trExpert, _ref, _ref1;
      _ref = geyser.generate(words('div table.table.table-condensed table.table-kv thead tbody tr tr.y-expert span.y-diff th th.y-indent td div.y-link')), div = _ref[0], table = _ref[1], kvtable = _ref[2], thead = _ref[3], tbody = _ref[4], tr = _ref[5], trExpert = _ref[6], diffSpan = _ref[7], th = _ref[8], thIndent = _ref[9], td = _ref[10], hyperlink = _ref[11];
      _ref1 = geyser.generate("td id='$id'", "th colspan='" + (scores.length + 1) + "' style='background:#f5f5f5'"), tdId = _ref1[0], thWide = _ref1[1];
      createParameterTable = function(_arg) {
        var parameters;
        parameters = _arg.parameters;
        return kvtable([
          tbody(map(parameters, function(parameter) {
            var trow;
            trow = parameter.isVisible ? tr : trExpert;
            return trow([th(parameter.key), td(parameter.isDifferent ? diffSpan(parameter.value) : parameter.value)]);
          }))
        ]);
      };
      createComparisonGrid = function(scores) {
        var algorithmRow, auc, aucOutput, aucRow, cm, comparisonRows, criterion, criterionIndex, durationRow, errorBadge, inputParametersRow, inputParamsByAlgorithm, inputParamsByScoreIndex, inputParamsWithAlgorithm, metrics, model, nameRow, outputRow, renderRocCurves, rocCurveRow, score, scoreIndex, scoreWithLowestError, toggleAdvancedParameters, value, _i, _j, _k, _l, _len, _len1, _len2, _len3;
        comparisonRows = [];
        comparisonRows.push(algorithmRow = [th('Method')]);
        comparisonRows.push(nameRow = [th('Name')]);
        comparisonRows.push(rocCurveRow = [th('ROC Curve')]);
        comparisonRows.push(inputParametersRow = [th([div('Input Parameters'), hyperlink('Show more')])]);
        comparisonRows.push(durationRow = [th('Time')]);
        comparisonRows.push(aucRow = [th('AUC')]);
        scoreWithLowestError = min(scores, function(score) {
          return (head(score.data.output.metrics)).error_measure;
        });
        inputParamsWithAlgorithm = map(scores, function(score) {
          var model;
          model = score.data.input.model;
          return {
            algorithm: model.model_algorithm,
            parameters: combineInputParameters(model)
          };
        });
        inputParamsByScoreIndex = map(inputParamsWithAlgorithm, function(a) {
          return a.parameters;
        });
        inputParamsByAlgorithm = values(groupBy(inputParamsWithAlgorithm, function(a) {
          return a.algorithm;
        }));
        forEach(inputParamsByAlgorithm, function(groups) {
          return compareInputParameters(map(groups, function(group) {
            return group.parameters;
          }));
        });
        for (scoreIndex = _i = 0, _len = scores.length; _i < _len; scoreIndex = ++_i) {
          score = scores[scoreIndex];
          model = score.data.input.model;
          metrics = head(score.data.output.metrics);
          auc = metrics.auc;
          cm = metrics.cm;
          errorBadge = scores.length > 1 && score === scoreWithLowestError ? ' (Lowest)' : '';
          algorithmRow.push(td(model.model_algorithm));
          nameRow.push(td(model.key));
          rocCurveRow.push(tdId('Loading...', {
            $id: "roc-" + scoreIndex
          }));
          inputParametersRow.push(td(createParameterTable({
            parameters: inputParamsByScoreIndex[scoreIndex]
          })));
          durationRow.push(td("" + metrics.duration_in_ms + " ms"));
          aucRow.push(td(format4f(auc.AUC)));
        }
        for (criterionIndex = _j = 0, _len1 = aucCriteria.length; _j < _len1; criterionIndex = ++_j) {
          criterion = aucCriteria[criterionIndex];
          comparisonRows.push([thWide("Outputs by " + criterion.caption)]);
          for (_k = 0, _len2 = aucOutputs.length; _k < _len2; _k++) {
            aucOutput = aucOutputs[_k];
            outputRow = [[th(aucOutput.caption)]];
            for (scoreIndex = _l = 0, _len3 = scores.length; _l < _len3; scoreIndex = ++_l) {
              score = scores[scoreIndex];
              model = score.data.input.model;
              metrics = head(score.data.output.metrics);
              auc = metrics.auc;
              value = auc[aucOutput.key][criterionIndex];
              outputRow.push(td(value === 'NaN' ? value : format4f(value)));
            }
            comparisonRows.push(outputRow);
          }
        }
        renderRocCurves = function($element) {
          forEach(scores, function(score, scoreIndex) {
            return defer(function() {
              var rocCurve;
              rocCurve = createRocCurve((head(score.data.output.metrics)).auc.confusion_matrices);
              return $("#roc-" + scoreIndex, $element).empty().append(rocCurve);
            });
          });
        };
        toggleAdvancedParameters = function($element) {
          var $toggleLink, isHidden;
          isHidden = true;
          $toggleLink = $('.y-link', $element);
          $toggleLink.click(function() {
            if (isHidden) {
              $('.y-expert', $element).show();
              $toggleLink.text('Show less');
            } else {
              $('.y-expert', $element).hide();
              $toggleLink.text('Show more');
            }
            isHidden = !isHidden;
          });
        };
        return {
          markup: table(tbody(map(comparisonRows, function(row) {
            return tr(row);
          }))),
          behavior: function($element) {
            renderRocCurves($element);
            return toggleAdvancedParameters($element);
          }
        };
      };
      return createComparisonGrid(scores);
    };
    configureStripPlot = function() {
      return _.configureStripPlot(_stripPlotParameters, function(parameters) {
        var parameter, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2;
        if (parameters) {
          _ref = parameters.group1;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            parameter = _ref[_i];
            parameter.source.isSelected(parameter.isSelected());
          }
          _ref1 = parameters.group2;
          for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
            parameter = _ref1[_j];
            parameter.source.isSelected(parameter.isSelected());
          }
          _ref2 = parameters.group3;
          for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
            parameter = _ref2[_k];
            parameter.source.isSelected(parameter.isSelected());
          }
        }
      });
    };
    initialize(_scoring);
    return {
      tag: _tag,
      caption: _caption,
      timestamp: _timestamp,
      isScoringView: _isScoringView,
      isComparisonView: _isComparisonView,
      isTabularComparisonView: _isTabularComparisonView,
      isAdvancedComparisonView: _isAdvancedComparisonView,
      isSheetView: _isSheetView,
      switchToTabularView: switchToTabularView,
      switchToAdvancedView: switchToAdvancedView,
      switchToSheetView: switchToSheetView,
      modelSummary: _modelSummary,
      comparisonTable: _comparisonTable,
      scoringList: _scoringList,
      multiRocPlot: _multiRocPlot,
      categories: _categories,
      selectedCategory: _selectedCategory,
      comparisonPlot: _comparisonPlot,
      inputOutputCategories: _inputOutputCategories,
      inputOutputPlotX: _inputOutputPlotX,
      inputOutputPlotY: _inputOutputPlotY,
      inputOutputPlot: _inputOutputPlot,
      thresholdPlot: _thresholdPlot,
      thresholdPlotX: _thresholdPlotX,
      thresholdPlotY: _thresholdPlotY,
      thresholdPlotVariables: _thresholdPlotVariables,
      stripPlot: _stripPlot,
      configureStripPlot: configureStripPlot,
      sheetView: _sheetView,
      hasFailed: _hasFailed,
      failure: _failure,
      template: 'scoring-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  var collateInputParameters, collateInputVariables, computeFPR, computeTPR, createFilter, createInputParameterAndValue, createInputParameterAndValue2, createInputVariable, createInputVariables, createInspectionColorSwatch, createMetricFrameFromScorings, createMetricInspection, createMetricsVisualization, createThresholdInspection, createThresholdVisualization, determineType, format4f, formatInteger, getSortedNumericVariables, inputsVariable, isNumericVariable, metricCriteriaVariable, metricTypeVariable, metricVariables, metricVariablesIndex, renderMetricsVisualization, renderThresholdVisualization, scoringVariable, thresholdVariables, thresholdVariablesIndex;

  if (typeof exports === "undefined" || exports === null) {
    format4f = d3.format('.4f');
    formatInteger = d3.format('d');
  } else {
    format4f = null;
    formatInteger = null;
  }

  computeTPR = function(cm) {
    var fn, fp, tn, tp, _ref, _ref1;
    (_ref = cm[0], tn = _ref[0], fp = _ref[1]), (_ref1 = cm[1], fn = _ref1[0], tp = _ref1[1]);
    return tp / (tp + fn);
  };

  computeFPR = function(cm) {
    var fn, fp, tn, tp, _ref, _ref1;
    (_ref = cm[0], tn = _ref[0], fp = _ref[1]), (_ref1 = cm[1], fn = _ref1[0], tp = _ref1[1]);
    return fp / (fp + tn);
  };

  isNumericVariable = function(variable) {
    return variable.type === 'float' || variable.type === 'integer';
  };

  getSortedNumericVariables = function(variables) {
    return sortBy(filter(variables, isNumericVariable), function(variable) {
      return variable.caption;
    });
  };

  metricCriteriaVariable = {
    id: uniqueId(),
    name: 'metricCriteria',
    caption: 'Metric Criteria',
    type: 'string',
    format: identity,
    domain: [
      {
        value: 'maximum F1',
        caption: 'Max F1',
        isImportant: true
      }, {
        value: 'maximum F2',
        caption: 'Max F2',
        isImportant: false
      }, {
        value: 'maximum F0point5',
        caption: 'Max F0.5',
        isImportant: false
      }, {
        value: 'maximum Accuracy',
        caption: 'Max Accuracy',
        isImportant: false
      }, {
        value: 'maximum Precision',
        caption: 'Max Precision',
        isImportant: false
      }, {
        value: 'maximum Recall',
        caption: 'Max Recall',
        isImportant: false
      }, {
        value: 'maximum Specificity',
        caption: 'Max Specificity',
        isImportant: false
      }, {
        value: 'maximum absolute MCC',
        caption: 'Max Absolute MCC',
        isImportant: false
      }, {
        value: 'minimizing max per class Error',
        caption: 'Min MPCE',
        isImportant: false
      }
    ]
  };

  metricTypeVariable = {
    id: uniqueId(),
    name: 'metricType',
    caption: 'Metric Type',
    type: 'string',
    format: identity,
    domain: [
      {
        value: 'threshold_for_criteria',
        caption: 'Threshold',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'error_for_criteria',
        caption: 'Error',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'F0point5_for_criteria',
        caption: 'F0.5',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'F1_for_criteria',
        caption: 'F1',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'F2_for_criteria',
        caption: 'F2',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'accuracy_for_criteria',
        caption: 'Accuracy',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'precision_for_criteria',
        caption: 'Precision',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'recall_for_criteria',
        caption: 'Recall',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'specificity_for_criteria',
        caption: 'Specificity',
        domain: [0, 1],
        isImportant: true
      }, {
        value: 'mcc_for_criteria',
        caption: 'MCC',
        domain: [-1, 1],
        isImportant: true
      }, {
        value: 'max_per_class_error_for_criteria',
        caption: 'MPCE',
        domain: [0, 1],
        isImportant: true
      }
    ]
  };

  scoringVariable = {
    id: uniqueId(),
    name: 'scoring',
    caption: 'Scoring',
    type: 'string',
    read: function(metric) {
      return metric.caption;
    },
    domain: [],
    format: identity
  };

  inputsVariable = {
    id: uniqueId(),
    name: 'inputs',
    caption: 'Inputs',
    type: 'string',
    read: function(metric) {
      return 'NA';
    },
    domain: [],
    format: identity
  };

  metricVariables = [];

  metricVariables.push({
    id: uniqueId(),
    name: 'method',
    caption: 'Method',
    type: 'string',
    read: function(metric) {
      return metric.model.model_algorithm;
    },
    format: identity,
    domain: [0, 1],
    extent: []
  });

  metricVariables.push({
    id: uniqueId(),
    name: 'auc',
    caption: 'AUC',
    type: 'float',
    read: function(metric) {
      return +metric.data.auc.AUC;
    },
    format: format4f,
    domain: [0, 1],
    extent: []
  });

  metricVariables.push({
    id: uniqueId(),
    name: 'gini',
    caption: 'Gini',
    type: 'float',
    read: function(metric) {
      return +metric.data.auc.Gini;
    },
    format: format4f,
    domain: [0, 1],
    extent: []
  });

  metricVariables.push({
    id: uniqueId(),
    name: 'trainingTime',
    caption: 'Training Time (ms)',
    type: 'integer',
    read: function(metric) {
      return metric.model.training_duration_in_ms;
    },
    format: formatInteger,
    domain: [0, 1],
    extent: []
  });

  metricVariables.push({
    id: uniqueId(),
    name: 'scoringTime',
    caption: 'Scoring Time (ms)',
    type: 'integer',
    read: function(metric) {
      return metric.data.duration_in_ms;
    },
    format: formatInteger,
    domain: [0, 1],
    extent: []
  });

  forEach(metricCriteriaVariable.domain, function(metricCriterion, metricCriterionIndex) {
    return forEach(metricTypeVariable.domain, function(metricType) {
      return metricVariables.push({
        id: uniqueId(),
        name: "" + metricCriterion.value + "-" + metricType.value,
        caption: "" + metricType.caption + " (" + metricCriterion.caption + ")",
        type: 'float',
        read: function(metric) {
          return +metric.data.auc[metricType.value][metricCriterionIndex];
        },
        format: format4f,
        domain: [0, 1],
        extent: [],
        meta: {
          metricType: metricType,
          metricCriterion: metricCriterion,
          metricCriterionIndex: metricCriterionIndex
        }
      });
    });
  });

  metricVariables.push(scoringVariable);

  metricVariables.push({
    id: uniqueId(),
    name: 'frameKey',
    caption: 'Frame',
    type: 'string',
    read: function(metric) {
      return metric.data.frame.key;
    },
    format: identity,
    domain: [0, 1],
    extent: []
  });

  metricVariables.push({
    id: uniqueId(),
    name: 'modelKey',
    caption: 'Model',
    type: 'string',
    read: function(metric) {
      return metric.model.key;
    },
    format: identity,
    domain: [0, 1],
    extent: []
  });

  metricVariablesIndex = indexBy(metricVariables, function(variable) {
    return variable.name;
  });

  thresholdVariables = [
    {
      name: 'threshold',
      caption: 'Threshold',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.thresholds[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'error',
      caption: 'Error',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.errorr[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'f0.5',
      caption: 'F0.5',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.F0point5[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'f1',
      caption: 'F1',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.F1[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'f2',
      caption: 'F2',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.F2[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'accuracy',
      caption: 'Accuracy',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.accuracy[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'precision',
      caption: 'Precision',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.precision[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'recall',
      caption: 'Recall',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.recall[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'specificity',
      caption: 'Specificity',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.specificity[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'mcc',
      caption: 'MCC',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.mcc[index];
      },
      format: format4f,
      domain: [-1, 1],
      extent: []
    }, {
      name: 'mpce',
      caption: 'MPCE',
      type: 'float',
      read: function(metric, index) {
        return +metric.data.auc.max_per_class_error[index];
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'cm',
      caption: 'Confusion Matrix',
      type: 'blob',
      read: function(metric, index) {
        return {
          domain: metric.data.auc.actual_domain,
          cm: metric.data.auc.confusion_matrices[index]
        };
      },
      format: function(blob) {
        var d1, d2, fn, fp, grid, td, th, tn, tp, tr, _ref, _ref1, _ref2, _ref3, _ref4;
        _ref = geyser.generate(words('table.table.table-bordered tr th td')), grid = _ref[0], tr = _ref[1], th = _ref[2], td = _ref[3];
        _ref1 = blob.domain, d1 = _ref1[0], d2 = _ref1[1];
        _ref2 = blob.cm, (_ref3 = _ref2[0], tn = _ref3[0], fp = _ref3[1]), (_ref4 = _ref2[1], fn = _ref4[0], tp = _ref4[1]);
        return grid([tr([th(''), th(d1), th(d2)]), tr([th(d1), td(tn), td(fp)]), tr([th(d2), td(fn), td(tp)])]);
      },
      domain: null,
      extent: []
    }, {
      name: 'tpr',
      caption: 'TPR',
      type: 'float',
      read: function(metric, index) {
        return computeTPR(metric.data.auc.confusion_matrices[index]);
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }, {
      name: 'fpr',
      caption: 'FPR',
      type: 'float',
      read: function(metric, index) {
        return computeFPR(metric.data.auc.confusion_matrices[index]);
      },
      format: format4f,
      domain: [0, 1],
      extent: []
    }
  ];

  thresholdVariablesIndex = indexBy(thresholdVariables, function(variable) {
    return variable.name;
  });

  createInputVariable = function(algorithm, key, caption, type, inputType, domain, hasDifferences) {
    var extent, format, read;
    read = function(metric) {
      if (metric.model.model_algorithm === algorithm) {
        switch (inputType) {
          case 'critical':
            return metric.model.critical_parameters[key];
          case 'secondary':
            return metric.model.secondary_parameters[key];
          case 'expert':
            return metric.model.expert_parameters[key];
        }
      } else {
        return void 0;
      }
    };
    extent = isArray(domain) ? domain.length === 2 ? domain[0] === domain[1] ? [domain[0] - 1, domain[1] + 1] : domain : [0, 1] : [0, 1];
    format = function(value) {
      if (isUndefined(value)) {
        return '-';
      } else {
        switch (type) {
          case 'integer':
            return formatInteger(value);
          case 'float':
            return format4f(value);
          case 'string':
            return value;
          case 'array':
            return value.join(', ');
          default:
            return JSON.stringify(value);
        }
      }
    };
    return {
      id: uniqueId(),
      name: caption,
      caption: caption,
      type: type,
      read: read,
      format: format,
      domain: domain,
      extent: extent,
      meta: {
        inputType: inputType,
        hasDifferences: hasDifferences
      }
    };
  };

  createInputParameterAndValue2 = function(algorithm, type, key, value) {
    return {
      key: key,
      algorithm: algorithm,
      type: type,
      value: value
    };
  };

  createInputParameterAndValue = function(value, key) {
    var scalarValue;
    scalarValue = isArray(value) ? value.join(', ') : value;
    return {
      key: key,
      value: scalarValue,
      isNumber: isNumber(value)
    };
  };

  determineType = function(value) {
    if (isNumber(value)) {
      return 'float';
    } else if (isString(value)) {
      return 'string';
    } else if (isArray(value)) {
      return 'array';
    } else {
      return 'blob';
    }
  };

  createInputVariables = function(inputParametersByCaption) {
    var algorithm, caption, domain, hasDifferences, input, inputType, inputs, key, type, valid, variables, _i, _len;
    variables = [];
    for (caption in inputParametersByCaption) {
      inputs = inputParametersByCaption[caption];
      type = null;
      key = null;
      algorithm = null;
      inputType = null;
      valid = false;
      for (_i = 0, _len = inputs.length; _i < _len; _i++) {
        input = inputs[_i];
        if (type === null) {
          type = determineType(input.value);
          key = input.key;
          algorithm = input.algorithm;
          inputType = input.type;
          valid = true;
        } else {
          if (type !== determineType(input.value)) {
            valid = false;
            continue;
          }
        }
      }
      if (valid) {
        switch (type) {
          case 'float':
            domain = d3.extent(inputs, function(input) {
              return input.value;
            });
            if (every(inputs, function(input) {
              return isInteger(input.value);
            })) {
              type = 'integer';
            }
            break;
          case 'string':
            domain = unique(map(inputs, function(input) {
              return input.value;
            }));
            break;
          default:
            domain = null;
        }
        hasDifferences = domain === null || (domain !== null && !same(domain));
        variables.push(createInputVariable(algorithm, key, caption, type, inputType, domain, hasDifferences));
      }
    }
    return sortBy(variables, function(variable) {
      return variable.caption;
    });
  };

  collateInputVariables = function(metrics) {
    var inputParameters, inputParametersByKey;
    inputParameters = map(metrics, function(metric) {
      var model;
      model = metric.model;
      return flatten([
        mapWithKey(model.critical_parameters, function(value, key) {
          return createInputParameterAndValue2(model.model_algorithm, 'critical', key, value);
        }), mapWithKey(model.secondary_parameters, function(value, key) {
          return createInputParameterAndValue2(model.model_algorithm, 'secondary', key, value);
        }), mapWithKey(model.expert_parameters, function(value, key) {
          return createInputParameterAndValue2(model.model_algorithm, 'expert', key, value);
        })
      ]);
    });
    inputParametersByKey = groupBy(flatten(inputParameters), function(parameter) {
      return "" + parameter.algorithm + "." + parameter.key;
    });
    return createInputVariables(inputParametersByKey);
  };

  collateInputParameters = function(metrics) {
    var i, inputParameters, key, models, numericParametersByModel, parameter, parameters, parametersByKey, parametersByModel, plottableParameterKeys, _i, _j, _len, _len1, _ref;
    models = map(metrics, function(metric) {
      return metric.model;
    });
    parametersByModel = map(models, function(model) {
      return flatten([mapWithKey(model.critical_parameters, createInputParameterAndValue), mapWithKey(model.secondary_parameters, createInputParameterAndValue), mapWithKey(model.expert_parameters, createInputParameterAndValue)]);
    });
    numericParametersByModel = map(parametersByModel, function(parameters) {
      return filter(parameters, function(parameter) {
        return parameter.isNumber;
      });
    });
    parametersByKey = groupBy(flatten(numericParametersByModel), function(parameter) {
      return parameter.key;
    });
    plottableParameterKeys = [];
    for (key in parametersByKey) {
      parameters = parametersByKey[key];
      if (parameters.length === models.length) {
        plottableParameterKeys.push(key);
      }
    }
    inputParameters = times(models.length, function() {
      return {};
    });
    for (_i = 0, _len = plottableParameterKeys.length; _i < _len; _i++) {
      key = plottableParameterKeys[_i];
      _ref = parametersByKey[key];
      for (i = _j = 0, _len1 = _ref.length; _j < _len1; i = ++_j) {
        parameter = _ref[i];
        inputParameters[i][key] = parameter.value;
      }
    }
    forEach(metrics, function(metric, i) {
      return metric.inputs = inputParameters[i];
    });
    return [plottableParameterKeys, inputParameters];
  };

  createMetricFrameFromScorings = function(scores) {
    var colorScale, createUniqueScoringName, extent, extents, inputVariables, l, metrics, palette, u, uniqueScoringNames, variable, _i, _j, _len, _len1;
    uniqueScoringNames = {};
    createUniqueScoringName = function(frameKey, modelKey) {
      var index, name;
      name = "" + modelKey + " on " + frameKey;
      if (index = uniqueScoringNames[name]) {
        uniqueScoringNames[name] = index++;
        name += ' #' + index;
      } else {
        uniqueScoringNames[name] = 1;
      }
      return name;
    };
    palette = scores.length > 10 ? d3.scale.category20 : d3.scale.category10;
    colorScale = palette().domain(d3.range(scores.length));
    metrics = map(scores, function(score, index) {
      var metric, model;
      model = score.data.input.model;
      metric = head(score.data.output.metrics);
      return {
        id: index,
        caption: createUniqueScoringName(metric.frame.key, metric.model.key),
        model: model,
        data: metric,
        color: colorScale(index)
      };
    });
    for (_i = 0, _len = metricVariables.length; _i < _len; _i++) {
      variable = metricVariables[_i];
      if (!(isNumericVariable(variable))) {
        continue;
      }
      extent = d3.extent(metrics, variable.read);
      l = extent[0], u = extent[1];
      variable.extent = (isNumber(l)) && (isNumber(u)) && l < u ? extent : variable.domain;
    }
    for (_j = 0, _len1 = thresholdVariables.length; _j < _len1; _j++) {
      variable = thresholdVariables[_j];
      if (!(isNumericVariable(variable))) {
        continue;
      }
      extents = map(metrics, function(metric) {
        return d3.extent(times(metric.data.auc.thresholds.length, function(index) {
          return variable.read(metric, index);
        }));
      });
      l = d3.min(extents, function(extent) {
        return head(extent);
      });
      u = d3.max(extents, function(extent) {
        return last(extent);
      });
      variable.extent = (isNumber(l)) && (isNumber(u)) && l < u ? [l, u] : variable.domain;
    }
    inputVariables = collateInputVariables(metrics);
    return {
      metrics: metrics,
      inputVariables: inputVariables,
      metricVariables: metricVariables,
      thresholdVariables: thresholdVariables
    };
  };

  createMetricsVisualization = function(metrics, variableX, variableY, inspect) {
    var div, render;
    div = geyser.generate(['div'])[0];
    render = function($element) {
      var plot;
      plot = renderMetricsVisualization(metrics, variableX, variableY, inspect);
      return $element.empty().append(plot);
    };
    return {
      markup: div(),
      behavior: render
    };
  };

  createThresholdVisualization = function(metrics, variableX, variableY, showReferenceLine, inspect) {
    var div, render;
    div = geyser.generate(['div'])[0];
    render = function($element) {
      var plot;
      plot = renderThresholdVisualization(metrics, variableX, variableY, showReferenceLine, inspect);
      return $element.empty().append(plot);
    };
    return {
      markup: div(),
      behavior: render
    };
  };

  createInspectionColorSwatch = function() {
    return pop(geyser.generate(["div style='display:inline-block;width:12px;height:12px;margin-right:7px;background-color:$color'"]));
  };

  createMetricInspection = function(variables, metric) {
    var div, h1, h2, span, swatch, table, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed tbody tr th td span')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], tbody = _ref[4], tr = _ref[5], th = _ref[6], td = _ref[7], span = _ref[8];
    swatch = createInspectionColorSwatch();
    return div([
      h1([
        swatch('', {
          $color: metric.color
        }), span(metric.caption)
      ]), table(tbody(map(variables, function(variable) {
        var value;
        value = variable.read(metric);
        return tr([th(variable.caption), td(isNaN(value) ? 'NaN' : variable.format(value))]);
      })))
    ]);
  };

  createThresholdInspection = function(variables, metric, index) {
    var div, grid, h1, h2, span, swatch, table, tabulateProperties, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed table.table.table-bordered tbody tr th td span')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], grid = _ref[4], tbody = _ref[5], tr = _ref[6], th = _ref[7], td = _ref[8], span = _ref[9];
    swatch = createInspectionColorSwatch();
    tabulateProperties = function(index) {
      return table(tbody(map(variables, function(variable) {
        return tr([th(variable.caption), td(variable.format(variable.read(metric, index)))]);
      })));
    };
    return div([
      h1([
        swatch('', {
          $color: metric.color
        }), span(metric.caption)
      ]), h2('Outputs'), tabulateProperties(index)
    ]);
  };

  renderMetricsVisualization = function(metrics, variableX, variableY, inspect) {
    var axisX, axisY, el, height, line, margin, readX, readY, scaleX, scaleY, svg, width;
    margin = {
      top: 20,
      right: 20,
      bottom: 30,
      left: 30
    };
    width = 200;
    height = 200;
    readX = function(metric) {
      return variableX.read(metric);
    };
    readY = function(metric) {
      return variableY.read(metric);
    };
    scaleX = d3.scale.linear().domain(variableX.extent).range([0, width]).nice();
    scaleY = d3.scale.linear().domain(variableY.extent).range([height, 0]).nice();
    axisX = d3.svg.axis().scale(scaleX).orient('bottom').ticks(5);
    axisY = d3.svg.axis().scale(scaleY).orient('left').ticks(5);
    line = d3.svg.line().x(function(d) {
      return scaleX(readX(d));
    }).y(function(d) {
      return scaleY(readY(d));
    });
    el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg = (d3.select(el)).attr('class', 'y-metrics-plot').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
    svg.append('g').attr('class', 'x axis').attr('transform', "translate(0, " + height + ")").call(axisX).append('text').attr('x', width).attr('y', -6).style('text-anchor', 'end').text(variableX.caption);
    svg.append('g').attr('class', 'y axis').call(axisY).append('text').attr('transform', 'rotate(-90)').attr('y', 6).attr('dy', '.71em').style('text-anchor', 'end').text(variableY.caption);
    svg.selectAll('.dot').data(metrics).enter().append('circle').attr('class', 'dot').attr('r', 5).attr('cx', function(d) {
      return scaleX(readX(d));
    }).attr('cy', function(d) {
      return scaleY(readY(d));
    }).attr('stroke', function(d) {
      return d.color;
    }).on('click', function(d) {
      return inspect(d);
    }).append('title').text(function(d) {
      return d.caption;
    });
    return el;
  };

  renderThresholdVisualization = function(metrics, variableX, variableY, showReferenceLine, inspect) {
    var axisX, axisY, curve, el, height, line, margin, scaleX, scaleY, svg, validIndices, width;
    margin = {
      top: 20,
      right: 20,
      bottom: 20,
      left: 30
    };
    width = 200;
    height = 200;
    validIndices = zipObject(map(metrics, function(metric) {
      var indices;
      indices = filter(range(metric.data.auc.thresholds.length), function(index) {
        var x, y;
        x = variableX.read(metric, index);
        y = variableY.read(metric, index);
        return (!isNaN(x)) && (!isNaN(y));
      });
      return [metric.id, indices];
    }));
    scaleX = d3.scale.linear().domain(variableX.extent).range([0, width]);
    scaleY = d3.scale.linear().domain(variableY.extent).range([height, 0]);
    axisX = d3.svg.axis().scale(scaleX).orient('bottom').ticks(5);
    axisY = d3.svg.axis().scale(scaleY).orient('left').ticks(5);
    line = function(metric) {
      return d3.svg.line().x(function(index) {
        return scaleX(variableX.read(metric, index));
      }).y(function(index) {
        return scaleY(variableY.read(metric, index));
      });
    };
    el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg = (d3.select(el)).attr('class', 'y-custom-plot').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
    svg.append('g').attr('class', 'x axis').attr('transform', "translate(0, " + height + ")").call(axisX).append('text').attr('x', width).attr('y', -6).style('text-anchor', 'end').text(variableX.caption);
    svg.append('g').attr('class', 'y axis').call(axisY).append('text').attr('transform', 'rotate(-90)').attr('y', 6).attr('dy', '.71em').style('text-anchor', 'end').text(variableY.caption);
    if (showReferenceLine) {
      svg.append('line').attr('class', 'guide').attr('stroke-dasharray', '3,3').attr({
        x1: scaleX(0),
        y1: scaleY(0),
        x2: scaleX(1),
        y2: scaleY(1)
      });
    }
    curve = svg.selectAll('.y-curve').data(metrics).enter().append('g').attr('class', 'y-curve');
    curve.append('path').attr('id', function(metric) {
      return "curve" + metric.id;
    }).attr('class', 'line').attr('d', function(metric) {
      return line(metric)(validIndices[metric.id]);
    }).style('stroke', function(metric) {
      return metric.color;
    });
    forEach(metrics, function(metric) {
      return svg.append('g').selectAll('.dot').data(validIndices[metric.id]).enter().append('circle').attr('class', 'dot').attr('r', 5).attr('cx', function(index) {
        return scaleX(variableX.read(metric, index));
      }).attr('cy', function(index) {
        return scaleY(variableY.read(metric, index));
      }).on('click', function(index) {
        return inspect(metric, index);
      }).on('mouseover', function(index) {
        return d3.select(this).style('stroke', metric.color);
      }).on('mouseout', function(index) {
        return d3.select(this).style('stroke', 'none');
      }).append('title').text(metric.caption);
    });
    return el;
  };

  createFilter = function(variable) {
    var item, items, predicate, _i, _len;
    items = map(variable.domain, function(factor) {
      return {
        factor: factor,
        isSelected: factor.isImportant
      };
    });
    predicate = {};
    for (_i = 0, _len = items.length; _i < _len; _i++) {
      item = items[_i];
      predicate[item.factor.value] = item.isSelected;
    }
    return {
      variable: variable,
      items: items,
      predicate: predicate
    };
  };

  Steam.ScoringSheetView = function(_, _scorings) {
    var addVisualization, applyFilter, configureVisualization, confirmVisualizationDeletion, createMetricTable, createMetricsVisualizationPane, createThresholdVisualizationPane, createVisualizationPane, displayFilters, initialize, invalidate, replaceVisualization, updateFiltering, _allFilters, _filteredInputVariables, _filteredMetricVariables, _filteredMetrics, _inputsFilter, _metricCriteriaFilter, _metricFrame, _metricTable, _metricTypeFilter, _metricsVisualizationType, _scoringFilter, _sortAscending, _sortByVariable, _thresholdVisualizationType, _visualizationTypes, _visualizations;
    _metricFrame = null;
    _metricTable = node$(null);
    _sortByVariable = metricVariablesIndex.auc;
    _sortAscending = false;
    _visualizations = nodes$([]);
    _metricsVisualizationType = null;
    _thresholdVisualizationType = null;
    _visualizationTypes = null;
    _filteredMetricVariables = null;
    _filteredInputVariables = null;
    _filteredMetrics = null;
    _scoringFilter = null;
    _inputsFilter = null;
    _metricTypeFilter = null;
    _metricCriteriaFilter = null;
    _allFilters = null;
    initialize = function(scorings) {
      var areModelsComparable;
      _metricFrame = createMetricFrameFromScorings(scorings);
      scoringVariable.domain = map(_metricFrame.metrics, function(metric) {
        return {
          value: metric.id,
          caption: metric.caption,
          isImportant: true
        };
      });
      inputsVariable.domain = map(_metricFrame.inputVariables, function(variable) {
        return {
          value: variable.id,
          caption: variable.caption,
          isImportant: (variable.meta.inputType === 'critical') || variable.meta.hasDifferences
        };
      });
      areModelsComparable = same(_metricFrame.metrics, function(a, b) {
        return a.model.model_category === b.model.model_category && a.model.model_algorithm === b.model.model_algorithm;
      });
      _metricsVisualizationType = {
        type: 'scoring',
        caption: 'Scoring',
        variables: getSortedNumericVariables(areModelsComparable ? _metricFrame.inputVariables.concat(metricVariables) : metricVariables)
      };
      _thresholdVisualizationType = {
        type: 'threshold',
        caption: 'Threshold',
        variables: getSortedNumericVariables(thresholdVariables)
      };
      _visualizationTypes = [_metricsVisualizationType, _thresholdVisualizationType];
      _scoringFilter = createFilter(scoringVariable);
      _inputsFilter = createFilter(inputsVariable);
      _metricTypeFilter = createFilter(metricTypeVariable);
      _metricCriteriaFilter = createFilter(metricCriteriaVariable);
      _allFilters = [_scoringFilter, _inputsFilter, _metricTypeFilter, _metricCriteriaFilter];
      updateFiltering();
      _metricTable(createMetricTable());
      return _visualizations.push(createThresholdVisualizationPane(thresholdVariablesIndex.fpr, thresholdVariablesIndex.tpr, true));
    };
    updateFiltering = function() {
      _filteredMetricVariables = filter(_metricFrame.metricVariables, function(variable) {
        if (variable.meta) {
          if (_metricTypeFilter.predicate[variable.meta.metricType.value] && _metricCriteriaFilter.predicate[variable.meta.metricCriterion.value]) {
            return true;
          } else {
            return false;
          }
        } else {
          return true;
        }
      });
      _filteredInputVariables = filter(_metricFrame.inputVariables, function(variable) {
        return _inputsFilter.predicate[variable.id];
      });
      return _filteredMetrics = filter(_metricFrame.metrics, function(metric) {
        return _scoringFilter.predicate[metric.id];
      });
    };
    invalidate = function() {
      var newVisualizations;
      _metricTable(createMetricTable());
      newVisualizations = [];
      forEach(_visualizations(), function(oldVisualization) {
        var type, variableX, variableY, _ref;
        _ref = oldVisualization.data, type = _ref.type, variableX = _ref.variableX, variableY = _ref.variableY;
        return createVisualizationPane(type, variableX, variableY, function(visualization) {
          return newVisualizations.push(visualization);
        });
      });
      return _visualizations(newVisualizations);
    };
    createMetricTable = function() {
      var behavior, checkbox, columnHeader, columnVariables, div, filterButton, filterOutButton, headers, markup, rows, scoringLink, selectAllCheckbox, swatch, table, tbody, td, th, thAsc, thDesc, thead, tr, _ref, _ref1;
      _ref = geyser.generate(words('div table.table.table-condensed thead tbody tr th th.y-sorted-asc th.y-sorted-desc td')), div = _ref[0], table = _ref[1], thead = _ref[2], tbody = _ref[3], tr = _ref[4], th = _ref[5], thAsc = _ref[6], thDesc = _ref[7], td = _ref[8];
      _ref1 = geyser.generate(["a.y-header data-variable-id='$id'", "a.y-scoring-link data-scoring-id='$id'", ".y-legend-swatch style='background-color:$color'", "input.y-select-one-checkbox type='checkbox' data-scoring-id='$id'", "input.y-select-all-checkbox type='checkbox'", 'button.btn.y-filter-button', "button.btn.y-filter-out-button style='margin-left:7px'"]), columnHeader = _ref1[0], scoringLink = _ref1[1], swatch = _ref1[2], checkbox = _ref1[3], selectAllCheckbox = _ref1[4], filterButton = _ref1[5], filterOutButton = _ref1[6];
      _filteredMetrics = sortBy(_filteredMetrics, function(metric) {
        return _sortByVariable.read(metric);
      });
      if (!_sortAscending) {
        _filteredMetrics.reverse();
      }
      columnVariables = clone(_filteredMetricVariables);
      columnVariables.splice.apply(columnVariables, flatten([columnVariables.length - 3, 0, _filteredInputVariables]));
      headers = map(columnVariables, function(variable) {
        var tag;
        tag = variable !== _sortByVariable ? th : _sortAscending ? thAsc : thDesc;
        return tag(columnHeader(variable.caption, {
          $id: variable.id
        }));
      });
      headers.unshift(th('&nbsp;'));
      headers.unshift(th(selectAllCheckbox('')));
      rows = map(_filteredMetrics, function(metric) {
        var cells;
        cells = map(columnVariables, function(variable) {
          if (variable.name === 'method' || variable.name === 'scoring') {
            return td(scoringLink(variable.read(metric), {
              $id: metric.id
            }));
          } else {
            return td(variable.format(variable.read(metric)));
          }
        });
        cells.unshift(td(swatch('', {
          $color: metric.color
        })));
        cells.unshift(td(checkbox('', {
          $id: metric.id
        })));
        return cells;
      });
      markup = div([table([thead(tr(headers)), tbody(map(rows, tr))]), div([filterButton('Edit this table&hellip;'), filterOutButton('Remove selected')])]);
      behavior = function($element) {
        $('a.y-header', $element).each(function() {
          var $anchor;
          $anchor = $(this);
          return $anchor.click(function() {
            var sortById;
            sortById = $anchor.attr('data-variable-id');
            _sortByVariable = find(columnVariables, function(variable) {
              return variable.id === sortById;
            });
            _sortAscending = $anchor.parents('th').hasClass('y-sorted-desc');
            return invalidate();
          });
        });
        $('a.y-scoring-link', $element).each(function() {
          var $anchor;
          $anchor = $(this);
          return $anchor.click(function() {
            var metric, metricId;
            metricId = parseInt($anchor.attr('data-scoring-id'));
            metric = find(_metricFrame.metrics, function(metric) {
              return metric.id === metricId;
            });
            if (metric) {
              return _.inspect({
                content: createMetricInspection(_metricFrame.metricVariables, metric),
                template: 'geyser'
              });
            }
          });
        });
        $('.y-select-all-checkbox', $element).change(function() {
          var $checkbox;
          $checkbox = $(this);
          return $('.y-select-one-checkbox', $element).prop('checked', $checkbox.is(':checked'));
        });
        $('.y-filter-button', $element).click(function() {
          return displayFilters();
        });
        return $('.y-filter-out-button', $element).click(function() {
          var scoringFilterPredicate;
          scoringFilterPredicate = {};
          $('.y-select-one-checkbox', $element).each(function() {
            var $checkbox, metricId;
            $checkbox = $(this);
            metricId = parseInt($checkbox.attr('data-scoring-id'));
            scoringFilterPredicate[metricId] = !$checkbox.is(':checked');
          });
          applyFilter(_scoringFilter, scoringFilterPredicate);
          updateFiltering();
          return invalidate();
        });
      };
      return {
        markup: markup,
        behavior: behavior
      };
    };
    applyFilter = function(filter, predicate) {
      var item, _i, _len, _ref;
      filter.predicate = predicate;
      _ref = filter.items;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected = predicate[item.factor.value];
      }
    };
    displayFilters = function() {
      return _.filterScorings(_allFilters, function(action, predicates) {
        var i, predicate, _i, _len;
        switch (action) {
          case 'confirm':
            for (i = _i = 0, _len = predicates.length; _i < _len; i = ++_i) {
              predicate = predicates[i];
              applyFilter(_allFilters[i], predicate);
            }
            updateFiltering();
            return invalidate();
        }
      });
    };
    confirmVisualizationDeletion = function(go) {
      var confirmDialogOpts;
      confirmDialogOpts = {
        title: 'Delete Visualization?',
        confirmCaption: 'Delete',
        cancelCaption: 'Keep'
      };
      return _.confirm('This visualization will be deleted. Are you sure?', confirmDialogOpts, function(response) {
        if (response === 'confirm') {
          return go();
        }
      });
    };
    replaceVisualization = function(oldVisualization, newVisualization) {
      var index;
      index = _visualizations.indexOf(oldVisualization);
      if (index >= 0) {
        _visualizations.splice(index, 1, newVisualization);
      }
    };
    createMetricsVisualizationPane = function(variableX, variableY) {
      var edit, remove, rendering, self;
      rendering = createMetricsVisualization(_filteredMetrics, variableX, variableY, function(metric) {
        return _.inspect({
          content: createMetricInspection(_metricFrame.metricVariables, metric),
          template: 'geyser'
        });
      });
      edit = function() {
        return configureVisualization('Edit Visualization', self.data.type, self.data.variableX, self.data.variableY, function(visualization) {
          return replaceVisualization(self, visualization);
        });
      };
      remove = function() {
        return confirmVisualizationDeletion(function() {
          return _visualizations.remove(self);
        });
      };
      self = {
        caption: "" + variableX.caption + " vs " + variableY.caption,
        data: {
          type: _metricsVisualizationType,
          variableX: variableX,
          variableY: variableY
        },
        rendering: rendering,
        edit: edit,
        remove: remove
      };
      return self;
    };
    createThresholdVisualizationPane = function(variableX, variableY, showReferenceLine) {
      var edit, remove, rendering, self;
      rendering = createThresholdVisualization(_filteredMetrics, variableX, variableY, showReferenceLine, function(metric, index) {
        return _.inspect({
          content: createThresholdInspection(_metricFrame.thresholdVariables, metric, index),
          template: 'geyser'
        });
      });
      edit = function() {
        return configureVisualization('Edit Visualization', self.data.type, self.data.variableX, self.data.variableY, function(visualization) {
          return replaceVisualization(self, visualization);
        });
      };
      remove = function() {
        return confirmVisualizationDeletion(function() {
          return _visualizations.remove(self);
        });
      };
      self = {
        caption: variableX === thresholdVariablesIndex.fpr && variableY === thresholdVariablesIndex.tpr ? 'ROC Chart' : "" + variableX.caption + " vs " + variableY.caption,
        data: {
          type: _thresholdVisualizationType,
          variableX: variableX,
          variableY: variableY
        },
        rendering: rendering,
        edit: edit,
        remove: remove
      };
      return self;
    };
    createVisualizationPane = function(visualizationType, variableX, variableY, go) {
      switch (visualizationType) {
        case _metricsVisualizationType:
          return go(createMetricsVisualizationPane(variableX, variableY));
        case _thresholdVisualizationType:
          return go(createThresholdVisualizationPane(variableX, variableY, false));
      }
    };
    configureVisualization = function(caption, type, variableX, variableY, go) {
      var parameters;
      parameters = {
        visualizationTypes: _visualizationTypes,
        visualizationType: type,
        variableX: variableX,
        variableY: variableY
      };
      return _.configureScoringVisualization(caption, parameters, function(action, response) {
        switch (action) {
          case 'confirm':
            return createVisualizationPane(response.visualizationType, response.variableX, response.variableY, go);
        }
      });
    };
    addVisualization = function() {
      return configureVisualization('Add Visualization', _metricsVisualizationType, null, null, function(visualization) {
        return _visualizations.push(visualization);
      });
    };
    initialize(_scorings);
    return {
      metricTable: _metricTable,
      visualizations: _visualizations,
      displayFilters: displayFilters,
      addVisualization: addVisualization
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  Steam.NotificationView = function(_, _notification) {
    return {
      title: _notification.message,
      level: _notification.level,
      data: _notification.data,
      cause: _notification.cause,
      timestamp: _notification.timestamp.toString(),
      dispose: function() {},
      template: 'notification-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  var defaultScoringComparisonMessage;

  defaultScoringComparisonMessage = 'Compare selected scorings.';

  Steam.ScoringSelectionView = function(_) {
    var clearSelections, compareScorings, deleteActiveScoring, deleteScorings, rescore, tryCompareScorings, _canCompareScorings, _caption, _hasScorings, _hasSelection, _scoringComparisonMessage, _selections;
    _selections = nodes$();
    _hasSelection = lift$(_selections, function(selections) {
      return selections.length > 0;
    });
    _caption = lift$(_selections, function(selections) {
      return "" + (describeCount(selections.length, 'item')) + " selected";
    });
    _scoringComparisonMessage = lift$(_selections, function(selections) {
      if (selections.length < 2) {
        return 'Select two or more scorings to compare.';
      }
      if (some(selections, function(selection) {
        return !selection.isReady();
      })) {
        return 'Remove pending scorings from your selection.';
      }
      if (some(selections, function(selection) {
        return selection.hasFailed();
      })) {
        return 'Remove failed scorings from your selection.';
      }
      if (some(selections, function(selection) {
        return selection.type === 'comparison';
      })) {
        return 'Remove comparison tables from your selection.';
      }
      if (!valuesAreEqual(selections, function(selection) {
        return selection.data.input.model.model_category;
      })) {
        return 'Ensure that all selected scorings belong to the same model category.';
      }
      if (!valuesAreEqual(selections, function(selection) {
        return selection.data.input.model.response_column_name;
      })) {
        return 'Ensure that all selected scorings refer to the same response column.';
      }
      return defaultScoringComparisonMessage;
    });
    _canCompareScorings = lift$(_scoringComparisonMessage, function(message) {
      return message === defaultScoringComparisonMessage;
    });
    _hasScorings = node$(false);
    compareScorings = function() {
      _.loadScorings({
        type: 'comparison',
        scorings: clone(_selections()),
        timestamp: Date.now()
      });
      return _.deselectAllScorings();
    };
    tryCompareScorings = function(hover) {
      return _.status(hover ? _scoringComparisonMessage() : null);
    };
    deleteActiveScoring = function() {
      var confirmDialogOpts;
      confirmDialogOpts = {
        title: 'Delete Scoring?',
        confirmCaption: 'Delete',
        cancelCaption: 'Keep'
      };
      return _.confirm('This scoring will be permanently deleted. Are you sure?', confirmDialogOpts, function(response) {
        if (response === 'confirm') {
          return _.deleteActiveScoring();
        }
      });
    };
    deleteScorings = function() {
      var confirmDialogOpts;
      confirmDialogOpts = {
        title: 'Delete Scorings?',
        confirmCaption: 'Delete',
        cancelCaption: 'Keep'
      };
      return _.confirm('These scorings will be permanently deleted. Are you sure?', confirmDialogOpts, function(response) {
        if (response === 'confirm') {
          return _.deleteScorings(clone(_selections()));
        }
      });
    };
    clearSelections = function() {
      return _.deselectAllScorings();
    };
    rescore = function() {
      return _.rescore();
    };
    link$(_.scoringSelectionChanged, function(isSelected, scoring) {
      if (isSelected) {
        return _selections.push(scoring);
      } else {
        return _selections.remove(scoring);
      }
    });
    link$(_.scoringSelectionCleared, function() {
      return _selections.removeAll();
    });
    link$(_.scoringAvailable, _hasScorings);
    return {
      caption: _caption,
      hasSelection: _hasSelection,
      clearSelections: clearSelections,
      canCompareScorings: _canCompareScorings,
      tryCompareScorings: tryCompareScorings,
      rescore: rescore,
      compareScorings: compareScorings,
      hasScorings: _hasScorings,
      deleteScorings: deleteScorings,
      deleteActiveScoring: deleteActiveScoring,
      template: 'scoring-selection-view'
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  var defaultStatusMessage;

  defaultStatusMessage = 'Ready.';

  Steam.MainView = function(_) {
    var createTopic, displayStatus, fixDialogPlacement, help, initialize, inspect, navigateHelp, navigateHelpBack, navigateHelpForward, navigateHelpHome, refresh, switchListView, switchModalView, switchPageView, switchSelectionView, switchToFrames, switchToModels, switchToNotifications, switchToScoring, switchTopic, switchView, template, toggleInspector, toggleTopics, _administrationTopic, _canNavigateHelpBack, _canNavigateHelpForward, _clusterTopic, _frameListView, _frameTopic, _hasModalDialog, _hasModalView, _help, _helpHistory, _helpHistoryIndex, _inspectorViews, _isDisplayingTopics, _isInspectorHidden, _isListMasked, _isNavigatorMasked, _isViewMasked, _jobTopic, _listViews, _modalDialogs, _modalViews, _modelListView, _modelSelectionView, _modelTopic, _notificationListView, _notificationTopic, _pageViews, _scoringListView, _scoringSelectionView, _scoringTopic, _selectionViews, _status, _timelineTopic, _topic, _topicListView, _topicTitle, _topics;
    _help = node$(null);
    _helpHistory = [];
    _helpHistoryIndex = -1;
    _canNavigateHelpBack = node$(false);
    _canNavigateHelpForward = node$(false);
    _status = node$(defaultStatusMessage);
    _listViews = nodes$();
    _selectionViews = nodes$();
    _pageViews = nodes$();
    _modalViews = nodes$();
    _modalDialogs = nodes$();
    _inspectorViews = nodes$(null);
    _isInspectorHidden = node$(false);
    _topic = node$(null);
    _isDisplayingTopics = node$(false);
    _hasModalView = lift$(_modalViews, function(modalViews) {
      return modalViews.length > 0;
    });
    _hasModalDialog = lift$(_modalDialogs, function(modalDialogs) {
      return modalDialogs.length > 0;
    });
    _isNavigatorMasked = lift$(_hasModalDialog, _hasModalView, function(hasModalDialog, hasModalView) {
      return hasModalDialog || hasModalView;
    });
    _isListMasked = lift$(_hasModalDialog, identity);
    _isViewMasked = lift$(_hasModalDialog, _isDisplayingTopics, function(hasModalDialog, isDisplayingTopics) {
      return hasModalDialog || isDisplayingTopics;
    });
    _topicTitle = lift$(_topic, _isDisplayingTopics, function(topic, isDisplayingTopics) {
      if (isDisplayingTopics) {
        return 'Menu';
      } else if (topic) {
        return topic.title;
      } else {
        return '';
      }
    });
    toggleTopics = function() {
      return _isDisplayingTopics(!_isDisplayingTopics());
    };
    toggleInspector = function() {
      return _isInspectorHidden(!_isInspectorHidden());
    };
    apply$(_isDisplayingTopics, function(isDisplayingTopics) {
      if (isDisplayingTopics) {
        return _listViews.push(_topicListView);
      } else {
        return _listViews.remove(_topicListView);
      }
    });
    initialize = function() {
      navigateHelpHome();
      return switchToFrames({
        type: 'all'
      });
    };
    createTopic = function(title, handle) {
      var self;
      return self = {
        title: title,
        isDisabled: !isFunction(handle),
        display: function() {
          if (handle) {
            return handle();
          }
        }
      };
    };
    switchTopic = function(topic) {
      switch (topic) {
        case _frameTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_frameListView);
            switchSelectionView(null);
          }
          break;
        case _modelTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_modelListView);
            switchSelectionView(_modelSelectionView);
          }
          break;
        case _scoringTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_scoringListView);
            switchSelectionView(_scoringSelectionView);
          }
          break;
        case _notificationTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_notificationListView);
            switchSelectionView(null);
          }
      }
      _isDisplayingTopics(false);
    };
    switchToFrames = function(predicate) {
      switchTopic(_frameTopic);
      return _.loadFrames(predicate);
    };
    switchToModels = function(predicate) {
      switchTopic(_modelTopic);
      return _.loadModels(predicate);
    };
    switchToScoring = function(predicate) {
      switchTopic(_scoringTopic);
      return _.loadScorings(predicate);
    };
    switchToNotifications = function(predicate) {
      switchTopic(_notificationTopic);
      return _.loadNotifications(predicate);
    };
    _topics = node$([_frameTopic = createTopic('Datasets', switchToFrames), _modelTopic = createTopic('Models', switchToModels), _scoringTopic = createTopic('Scoring', switchToScoring), _timelineTopic = createTopic('Timeline', null), _notificationTopic = createTopic('Notifications', switchToNotifications), _jobTopic = createTopic('Jobs', null), _clusterTopic = createTopic('Cluster', null), _administrationTopic = createTopic('Administration', null)]);
    _topicListView = Steam.TopicListView(_, _topics);
    _frameListView = Steam.FrameListView(_);
    _modelListView = Steam.ModelListView(_);
    _scoringListView = Steam.ScoringListView(_);
    _notificationListView = Steam.NotificationListView(_);
    _modelSelectionView = Steam.ModelSelectionView(_);
    _scoringSelectionView = Steam.ScoringSelectionView(_);
    switchView = function(views, view) {
      var oldView, _i, _len, _ref;
      _ref = views();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        oldView = _ref[_i];
        if (isFunction(oldView.dispose)) {
          oldView.dispose();
        }
      }
      if (view) {
        return views([view]);
      } else {
        return views([]);
      }
    };
    switchListView = function(view) {
      return switchView(_listViews, view);
    };
    switchSelectionView = function(view) {
      return switchView(_selectionViews, view);
    };
    switchPageView = function(view) {
      return switchView(_pageViews, view);
    };
    switchModalView = function(view) {
      return switchView(_modalViews, view);
    };
    fixDialogPlacement = function(element) {
      return _.positionDialog(element);
    };
    refresh = function() {
      switch (_topic()) {
        case _frameTopic:
          _.refreshFrames();
          break;
        case _modelTopic:
          _.refreshModels();
      }
    };
    displayStatus = function(message) {
      if (message) {
        _status(message);
        return _.timeout('status', 7000, function() {
          return _.status(null);
        });
      } else {
        return _status(defaultStatusMessage);
      }
    };
    inspect = function(view) {
      if (view) {
        switchView(_inspectorViews, view);
      } else {
        switchView(_inspectorViews, null);
      }
    };
    navigateHelpHome = function() {
      return help('home');
    };
    navigateHelp = function() {
      _help(_.man(_helpHistory[_helpHistoryIndex]));
      _canNavigateHelpBack(_helpHistoryIndex > 0);
      return _canNavigateHelpForward(_helpHistoryIndex < _helpHistory.length - 1);
    };
    navigateHelpBack = function() {
      if (_helpHistoryIndex > 0) {
        _helpHistoryIndex--;
        return navigateHelp();
      }
    };
    navigateHelpForward = function() {
      if (_helpHistoryIndex < _helpHistory.length - 1) {
        _helpHistoryIndex++;
        return navigateHelp();
      }
    };
    help = function(id) {
      if (_helpHistory[_helpHistoryIndex] !== id) {
        if (_helpHistoryIndex < _helpHistory.length - 1) {
          _helpHistory.length = _helpHistoryIndex + 1;
          _helpHistoryIndex = _helpHistory.length - 1;
        }
        if (_helpHistory.length > 50) {
          _helpHistory.splice(0, _helpHistory.length - 50);
          _helpHistoryIndex = _helpHistory.length - 1;
        }
        _helpHistory.push(id);
        return navigateHelpForward();
      }
    };
    template = function(view) {
      return view.template;
    };
    link$(_.loadDialog, function(dialog) {
      return _modalDialogs.push(dialog);
    });
    link$(_.unloadDialog, function(dialog) {
      return _modalDialogs.remove(dialog);
    });
    link$(_.displayEmpty, function() {
      return switchPageView({
        template: 'empty-view'
      });
    });
    link$(_.displayFrame, function(frame) {
      if (_topic() === _frameTopic) {
        return switchPageView(Steam.FrameView(_, frame));
      }
    });
    link$(_.displayModel, function(model) {
      if (_topic() === _modelTopic) {
        return switchPageView(Steam.ModelView(_, model));
      }
    });
    link$(_.displayScoring, function(scoring) {
      if (_topic() === _scoringTopic) {
        return switchPageView(Steam.ScoringView(_, scoring));
      }
    });
    link$(_.displayNotification, function(notification) {
      if (_topic() === _notificationTopic) {
        return switchPageView(Steam.NotificationView(_, notification));
      }
    });
    link$(_.switchToFrames, switchToFrames);
    link$(_.switchToModels, switchToModels);
    link$(_.switchToScoring, switchToScoring);
    link$(_.switchToNotifications, switchToNotifications);
    link$(_.inspect, inspect);
    link$(_.status, displayStatus);
    link$(_.help, help);
    initialize();
    return {
      topicTitle: _topicTitle,
      toggleTopics: toggleTopics,
      toggleInspector: toggleInspector,
      listViews: _listViews,
      selectionViews: _selectionViews,
      pageViews: _pageViews,
      modalViews: _modalViews,
      modalDialogs: _modalDialogs,
      hasModalView: _hasModalView,
      hasModalDialog: _hasModalDialog,
      isNavigatorMasked: _isNavigatorMasked,
      isListMasked: _isListMasked,
      isViewMasked: _isViewMasked,
      isInspectorHidden: _isInspectorHidden,
      inspectorViews: _inspectorViews,
      refresh: refresh,
      help: _help,
      navigateHelpHome: navigateHelpHome,
      canNavigateHelpBack: _canNavigateHelpBack,
      navigateHelpBack: navigateHelpBack,
      canNavigateHelpForward: _canNavigateHelpForward,
      navigateHelpForward: navigateHelpForward,
      status: _status,
      fixDialogPlacement: fixDialogPlacement,
      template: template
    };
  };

}).call(this);
// Generated by CoffeeScript 1.7.1
(function() {
  $(function() {
    var steam;
    window.steam = steam = Steam.Application(Steam.ApplicationContext());
    return ko.applyBindings(steam);
  });

}).call(this);
}).call(this);
