### R code from vignette source 'joineR.Rnw'

###################################################
### code chunk number 1: joineR.Rnw:107-109
###################################################
library(joineR)
data(heart.valve)


###################################################
### code chunk number 2: joineR.Rnw:125-127
###################################################
dim(heart.valve)
names(heart.valve)


###################################################
### code chunk number 3: joineR.Rnw:141-143
###################################################
heart.valve.cov <- UniqueVariables(heart.valve, c("emergenc", "age", "sex"), 
id.col = "num")


###################################################
### code chunk number 4: joineR.Rnw:150-151
###################################################
heart.valve.cov[11:15, ]


###################################################
### code chunk number 5: joineR.Rnw:157-159
###################################################
heart.valve.cov <- UniqueVariables(heart.valve, c(2, 3, 5, 6, 12:25), id.col = "num")
dim(heart.valve.cov)


###################################################
### code chunk number 6: joineR.Rnw:176-179
###################################################
data(liver)
dim(liver)
names(liver)


###################################################
### code chunk number 7: joineR.Rnw:190-191
###################################################
liver[liver$id %in% 29:30,]


###################################################
### code chunk number 8: joineR.Rnw:208-209
###################################################
data(mental)


###################################################
### code chunk number 9: joineR.Rnw:221-222
###################################################
mental[1:5,]


###################################################
### code chunk number 10: joineR.Rnw:236-237
###################################################
table(mental$cens[is.na(mental$Y.t8)])


###################################################
### code chunk number 11: joineR.Rnw:256-258
###################################################
data(epileptic)
epileptic[1:3, ]


###################################################
### code chunk number 12: joineR.Rnw:268-272
###################################################
mental.unbalanced <- to.unbalanced(mental, id.col = 1, times = c(0, 1, 2, 4, 6, 8),
Y.col = 2:7, other.col = 8:11)
names(mental.unbalanced)
names(mental.unbalanced)[3] <- "Y"


###################################################
### code chunk number 13: joineR.Rnw:276-280
###################################################
mental.balanced <- to.balanced(mental.unbalanced, id.col = 1, time.col = 2,
Y.col = 3, other.col = 4:7)
dim(mental.balanced)
names(mental.balanced)


###################################################
### code chunk number 14: joineR.Rnw:289-293
###################################################
epileptic.balanced <- to.balanced(epileptic, id.col = 1, time.col = 3, 
Y.col = 2, other.col = 4:11)
dim(epileptic.balanced)
sum(is.na(epileptic.balanced))


###################################################
### code chunk number 15: joineR.Rnw:298-299
###################################################
summarybal(mental, Y.col = 2:7, times = c(0, 1, 2, 4, 6, 8), na.rm = TRUE)


###################################################
### code chunk number 16: joineR.Rnw:315-320
###################################################
liver.long <- liver[, 1:3]
liver.surv <- UniqueVariables(liver, var.col = c("survival", "cens"), id.col = "id")
liver.baseline <- UniqueVariables(liver, var.col = 4 , id.col = "id")
liver.jd <- jointdata(longitudinal = liver.long, survival = liver.surv, 
 baseline = liver.baseline, id.col = "id", time.col = "time")


###################################################
### code chunk number 17: joineR.Rnw:327-332
###################################################
heart.surv <- UniqueVariables(heart.valve, var.col = c("fuyrs", "status"), 
 id.col = "num")
heart.long <- heart.valve[, c(1, 4, 5, 7, 8, 9, 10, 11)]
heart.jd <- jointdata(longitudinal = heart.long, survival = heart.surv, 
 id.col = "num", time.col = "time")


###################################################
### code chunk number 18: joineR.Rnw:337-338
###################################################
summary(heart.jd)


###################################################
### code chunk number 19: joineR.Rnw:344-346
###################################################
take <- heart.jd$survival$num[heart.jd$survival$status == 0]
heart.jd.cens <- subset(heart.jd, take)


###################################################
### code chunk number 20: joineR.Rnw:354-356
###################################################
set.seed(94561)
heart.jd.sample <- sample.jointdata(heart.jd, size = 10)


###################################################
### code chunk number 21: heartplot
###################################################
plot(heart.jd)


###################################################
### code chunk number 22: ls_plot
###################################################
par(mfrow=c(1,2))
plot(heart.jd.cens, Y.col = 4, main = "gradient: censored")
take <- heart.jd$survival$num[heart.jd$survival$status == 1]
heart.jd.uncens <- subset(heart.jd, take)
plot(heart.jd.uncens, Y.col = 4, main = "gradient: failed")


###################################################
### code chunk number 23: jointplot
###################################################
jointplot(heart.jd, Y.col = "log.lvmi", Cens.col = "status", lag = 5, 
 col1 = "black", col2 = "gray", ylab = "log(lvmi)")


###################################################
### code chunk number 24: joineR.Rnw:459-473
###################################################
y <- as.matrix(mental[, 2:7]) 
# converts mental from list format to numeric matrix format
means <- matrix(0,3,6)
for (trt in 1:3) {
   ysub <- y[mental$treat == trt,]
   means[trt,] <- apply(ysub, 2, mean, na.rm = TRUE)
   }
residuals <- matrix(0, 150, 6)
for (i in 1:150) {
   residuals[i,] <- y[i,] - means[mental$treat[i],]
   }
V <- cov(residuals, use = "pairwise")
R <- cor(residuals, use = "pairwise")
round(cbind(diag(V), R), 3)


###################################################
### code chunk number 25: joineR.Rnw:499-502
###################################################
vgm <- variogram(indv = mental.unbalanced[, 1], time = mental.unbalanced[, 2], 
 Y = mental.unbalanced[, 3])
vgm$sigma2


###################################################
### code chunk number 26: joineR.Rnw:514-518 (eval = FALSE)
###################################################
## par(mfrow = c(1, 3))
## plot(vgm$svar[, 1], vgm$svar[, 2], pch = 19, cex = 0.5, xlab = "u", ylab = "V(u)")
## plot(vgm, points = FALSE, ylim = c(0, 200)) 
## plot(vgm)


###################################################
### code chunk number 27: variogram
###################################################
par(mfrow = c(1, 3))
plot(vgm$svar[, 1], vgm$svar[, 2], pch = 19, cex = 0.5, xlab = "u", ylab = "V(u)")
plot(vgm, points = FALSE, ylim = c(0, 200)) 
plot(vgm)


###################################################
### code chunk number 28: joineR.Rnw:592-593
###################################################
options(continue=" ")


###################################################
### code chunk number 29: joineR.Rnw:595-600
###################################################
mental.long <- mental.unbalanced[, 1:3]
mental.surv <- UniqueVariables(mental.unbalanced, 6:7, id.col = 1)
mental.baseline <- UniqueVariables(mental.unbalanced, 4, id.col = 1)
mental.jd <- jointdata(mental.long, mental.surv, mental.baseline, id.col = "id", 
 time.col = "time")


###################################################
### code chunk number 30: joineR.Rnw:607-610
###################################################
model.jointrandom <- joint(mental.jd, Y ~ 1 + time + treat, 
 Surv(surv.time, cens.ind) ~ treat, model = "int")
names(model.jointrandom)


###################################################
### code chunk number 31: joineR.Rnw:615-616
###################################################
summary(model.jointrandom)


###################################################
### code chunk number 32: joineR.Rnw:637-639 (eval = FALSE)
###################################################
## model.jointrandom.se <- jointSE(model.jointrandom, n.boot = 100)
## model.jointrandom.se


###################################################
### code chunk number 33: joineR.Rnw:680-683 (eval = FALSE)
###################################################
## model.jointrandom.liver <- joint(liver.jd, 
##  prothrombin ~ treatment * time + I(time == 0) * treatment, 
##  Surv(survival, cens) ~ treatment)


###################################################
### code chunk number 34: joineR.Rnw:690-693 (eval = FALSE)
###################################################
## model.jointrandom.liver.sep <- joint(liver.jd, 
##  prothrombin ~ treatment * time + I(time == 0) * treatment, 
##  Surv(survival, cens) ~ treatment, sepassoc = TRUE)


###################################################
### code chunk number 35: joineR.Rnw:698-699 (eval = FALSE)
###################################################
## model.jointrandom.liver.sep$loglik$jointlhood - model.jointrandom.liver$loglik$jointlhood


###################################################
### code chunk number 36: joineR.Rnw:708-715
###################################################
heart.grad <- heart.valve[!is.na(heart.valve$grad),]
heart.grad.long <- heart.grad[,c(1, 4, 7)]
heart.grad.surv <- UniqueVariables(heart.grad, var.col = c("fuyrs", "status"), 
 id.col = "num")
heart.grad.base <- UniqueVariables(heart.grad, var.col = 2:3, id.col = "num")
heart.grad.jd <- jointdata(longitudinal = heart.grad.long, survival = heart.grad.surv,
 baseline = heart.grad.base, id.col = "num", time.col = "time")  


###################################################
### code chunk number 37: joineR.Rnw:721-724
###################################################
model.jointrandom.heart <- joint(heart.grad.jd, grad ~ age + sex, 
 Surv(fuyrs, status) ~ age + sex , model = "int")
summary(model.jointrandom.heart)


