/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.examples;

import cc.mallet.grmm.inference.JunctionTreeInferencer;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.Variable;
import java.util.Random;

public class SimpleGraphExample {
    public static void main(String[] args) {
        Variable[] allVars = new Variable[]{new Variable(2), new Variable(2), new Variable(2), new Variable(2)};
        FactorGraph mdl = new FactorGraph(allVars);
        Random r = new Random(42L);
        for (int i = 0; i < allVars.length; ++i) {
            double[] ptlarr = new double[4];
            for (int j = 0; j < ptlarr.length; ++j) {
                ptlarr[j] = Math.abs(r.nextDouble());
            }
            Variable v1 = allVars[i];
            Variable v2 = allVars[(i + 1) % allVars.length];
            mdl.addFactor(v1, v2, ptlarr);
        }
        JunctionTreeInferencer inf = new JunctionTreeInferencer();
        inf.computeMarginals(mdl);
        for (int varnum = 0; varnum < allVars.length; ++varnum) {
            Variable var = allVars[varnum];
            Factor ptl = inf.lookupMarginal(var);
            AssignmentIterator it = ptl.assignmentIterator();
            while (it.hasNext()) {
                int outcome = it.indexOfCurrentAssn();
                System.out.println(var + "  " + outcome + "   " + ptl.value(it));
                it.advance();
            }
            System.out.println();
        }
    }
}

