/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TShortIntHashMap;
import gnu.trove.TShortIntIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TShortIntHashMapDecorator
extends AbstractMap<Short, Integer>
implements Map<Short, Integer>,
Cloneable {
    protected TShortIntHashMap _map;

    public TShortIntHashMapDecorator(TShortIntHashMap map) {
        this._map = map;
    }

    public TShortIntHashMap getMap() {
        return this._map;
    }

    @Override
    public TShortIntHashMapDecorator clone() {
        try {
            TShortIntHashMapDecorator copy = (TShortIntHashMapDecorator)super.clone();
            copy._map = (TShortIntHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Integer put(Short key, Integer value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Short && val instanceof Integer) {
                    short k = this.unwrapKey(key);
                    int v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Integer get(Short key) {
        short k = this.unwrapKey(key);
        int v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Integer remove(Short key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Short, Integer>> entrySet() {
        return new AbstractSet<Map.Entry<Short, Integer>>(){

            @Override
            public int size() {
                return TShortIntHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TShortIntHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TShortIntHashMapDecorator.this.containsKey(k) && ((Integer)TShortIntHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Short, Integer>> iterator() {
                return new Iterator<Map.Entry<Short, Integer>>(){
                    private final TShortIntIterator it;
                    {
                        this.it = TShortIntHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Short, Integer> next() {
                        this.it.advance();
                        final Short key = TShortIntHashMapDecorator.this.wrapKey(this.it.key());
                        final Integer v = TShortIntHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Short, Integer>(){
                            private Integer val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Short getKey() {
                                return key;
                            }

                            @Override
                            public Integer getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Integer setValue(Integer value) {
                                this.val = value;
                                return TShortIntHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Integer o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Short, Integer>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TShortIntHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Integer> map) {
        Iterator<Map.Entry<? extends Short, ? extends Integer>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<? extends Short, ? extends Integer> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Short wrapKey(short k) {
        return new Short(k);
    }

    protected short unwrapKey(Object key) {
        return (Short)key;
    }

    protected Integer wrapValue(int k) {
        return new Integer(k);
    }

    protected int unwrapValue(Object value) {
        return (Integer)value;
    }
}

