/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.util.Resolvable;

public final class PointerType
implements Serializable {
    static final long serialVersionUID = 220886251671304256L;
    private static final int N = 1;
    private static final int V = 2;
    private static final int ADJ = 4;
    private static final int ADV = 8;
    private static final int LEXICAL = 16;
    public static final PointerType ANTONYM = new PointerType("ANTONYM", "ANTONYM_KEY", 31);
    public static final PointerType CATEGORY = new PointerType("CATEGORY_DOMAIN", "CATEGORY_DOMAIN_KEY", 31);
    public static final PointerType REGION = new PointerType("REGION_DOMAIN", "REGION_DOMAIN_KEY", 31);
    public static final PointerType USAGE = new PointerType("USAGE_DOMAIN", "USAGE_DOMAIN_KEY", 31);
    public static final PointerType HYPERNYM = new PointerType("HYPERNYM", "HYPERNYM_KEY", 3);
    public static final PointerType HYPONYM = new PointerType("HYPONYM", "HYPONYM_KEY", 3);
    public static final PointerType NOMINALIZATION = new PointerType("NOMINALIZATION", "NOMINALIZATION_KEY", 3);
    public static final PointerType ATTRIBUTE = new PointerType("ATTRIBUTE", "ATTRIBUTE_KEY", 5);
    public static final PointerType SEE_ALSO = new PointerType("ALSO_SEE", "ALSO_SEE_KEY", 23);
    public static final PointerType MEMBER_HOLONYM = new PointerType("MEMBER_HOLONYM", "MEMBER_HOLONYM_KEY", 1);
    public static final PointerType SUBSTANCE_HOLONYM = new PointerType("SUBSTANCE_HOLONYM", "SUBSTANCE_HOLONYM_KEY", 1);
    public static final PointerType PART_HOLONYM = new PointerType("PART_HOLONYM", "PART_HOLONYM_KEY", 1);
    public static final PointerType MEMBER_MERONYM = new PointerType("MEMBER_MERONYM", "MEMBER_MERONYM_KEY", 1);
    public static final PointerType SUBSTANCE_MERONYM = new PointerType("SUBSTANCE_MERONYM", "SUBSTANCE_MERONYM_KEY", 1);
    public static final PointerType PART_MERONYM = new PointerType("PART_MERONYM", "PART_MERONYM_KEY", 1);
    public static final PointerType CATEGORY_MEMBER = new PointerType("CATEGORY_MEMBER", "CATEGORY_MEMBER_KEY", 1);
    public static final PointerType REGION_MEMBER = new PointerType("REGION_MEMBER", "REGION_MEMBER_KEY", 1);
    public static final PointerType USAGE_MEMBER = new PointerType("USAGE_MEMBER", "USAGE_MEMBER_KEY", 1);
    public static final PointerType ENTAILMENT = new PointerType("ENTAILMENT", "ENTAILMENT_KEY", 2);
    public static final PointerType ENTAILED_BY = new PointerType("ENTAILED_BY", "ENTAILED_BY_KEY", 2);
    public static final PointerType CAUSE = new PointerType("CAUSE", "CAUSE_KEY", 2);
    public static final PointerType VERB_GROUP = new PointerType("VERB_GROUP", "VERB_GROUP_KEY", 2);
    public static final PointerType SIMILAR_TO = new PointerType("SIMILAR", "SIMILAR_KEY", 4);
    public static final PointerType PARTICIPLE_OF = new PointerType("PARTICIPLE_OF", "PARTICIPLE_OF_KEY", 20);
    public static final PointerType PERTAINYM = new PointerType("PERTAINYM", "PERTAINYM_KEY", 20);
    public static final PointerType DERIVED = new PointerType("DERIVED", "DERIVED_KEY", 8);
    private static final List ALL_TYPES = Collections.unmodifiableList(Arrays.asList(ANTONYM, HYPERNYM, HYPONYM, ATTRIBUTE, SEE_ALSO, ENTAILMENT, ENTAILED_BY, CAUSE, VERB_GROUP, MEMBER_MERONYM, SUBSTANCE_MERONYM, PART_MERONYM, MEMBER_HOLONYM, SUBSTANCE_HOLONYM, PART_HOLONYM, SIMILAR_TO, PARTICIPLE_OF, DERIVED, NOMINALIZATION, CATEGORY, REGION, USAGE, CATEGORY_MEMBER, REGION_MEMBER, USAGE_MEMBER));
    private static final Map POS_TO_MASK_MAP = new HashMap();
    private static final Map KEY_TO_POINTER_TYPE_MAP = new HashMap();
    private static boolean _initialized = false;
    private Resolvable _label;
    private Resolvable _key;
    private int _flags;
    private PointerType _symmetricType;
    private transient String _cachedToString = null;
    private String _flagStringCache = null;

    public static void initialize() {
        if (!_initialized) {
            POS_TO_MASK_MAP.put(POS.NOUN, new Integer(1));
            POS_TO_MASK_MAP.put(POS.VERB, new Integer(2));
            POS_TO_MASK_MAP.put(POS.ADJECTIVE, new Integer(4));
            POS_TO_MASK_MAP.put(POS.ADVERB, new Integer(8));
            Iterator itr = ALL_TYPES.iterator();
            while (itr.hasNext()) {
                PointerType pt = (PointerType)itr.next();
                KEY_TO_POINTER_TYPE_MAP.put(pt.getKey(), pt);
            }
            _initialized = true;
        }
    }

    public static boolean isSymmetric(PointerType type) {
        return type.symmetricTo(type);
    }

    public static PointerType getPointerTypeForKey(String key) {
        return (PointerType)KEY_TO_POINTER_TYPE_MAP.get(key);
    }

    public static List getAllPointerTypes() {
        return ALL_TYPES;
    }

    public static List getAllPointerTypesForPOS(POS pos) {
        ArrayList<PointerType> types = new ArrayList<PointerType>();
        Iterator itr = ALL_TYPES.iterator();
        while (itr.hasNext()) {
            PointerType pt = (PointerType)itr.next();
            if (!pt.appliesTo(pos)) continue;
            types.add(pt);
        }
        return Collections.unmodifiableList(types);
    }

    private static void setSymmetric(PointerType a, PointerType b) {
        a._symmetricType = b;
        b._symmetricType = a;
    }

    private static int getPOSMask(POS pos) {
        return (Integer)POS_TO_MASK_MAP.get(pos);
    }

    private PointerType(String label, String key, int flags) {
        this._label = new Resolvable(label);
        this._key = new Resolvable(key);
        this._flags = flags;
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_011", new Object[]{this.getLabel(), this.getKey(), this.getFlagsAsString()});
        }
        return this._cachedToString;
    }

    public String getKey() {
        return this._key.toString();
    }

    public String getLabel() {
        return this._label.toString();
    }

    public boolean appliesTo(POS pos) {
        return (this._flags & PointerType.getPOSMask(pos)) != 0;
    }

    public boolean isSymmetric() {
        return this.symmetricTo(this);
    }

    public boolean symmetricTo(PointerType type) {
        return this.getSymmetricType() != null && this.getSymmetricType().equals(type);
    }

    public PointerType getSymmetricType() {
        return this._symmetricType;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    private String getFlagsAsString() {
        if (this._flagStringCache == null) {
            String str = "";
            if ((this._flags & 1) != 0) {
                str = str + JWNL.resolveMessage("NOUN") + ", ";
            }
            if ((this._flags & 2) != 0) {
                str = str + JWNL.resolveMessage("VERB") + ", ";
            }
            if ((this._flags & 4) != 0) {
                str = str + JWNL.resolveMessage("ADJECTIVE") + ", ";
            }
            if ((this._flags & 8) != 0) {
                str = str + JWNL.resolveMessage("ADVERB") + ", ";
            }
            if ((this._flags & 0x10) != 0) {
                str = str + JWNL.resolveMessage("LEXICAL") + ", ";
            }
            this._flagStringCache = str.substring(0, str.length() - 2);
        }
        return this._flagStringCache;
    }

    static {
        PointerType.setSymmetric(ANTONYM, ANTONYM);
        PointerType.setSymmetric(HYPERNYM, HYPONYM);
        PointerType.setSymmetric(MEMBER_MERONYM, MEMBER_HOLONYM);
        PointerType.setSymmetric(SUBSTANCE_MERONYM, SUBSTANCE_HOLONYM);
        PointerType.setSymmetric(PART_MERONYM, PART_HOLONYM);
        PointerType.setSymmetric(SIMILAR_TO, SIMILAR_TO);
        PointerType.setSymmetric(ATTRIBUTE, ATTRIBUTE);
        PointerType.setSymmetric(VERB_GROUP, VERB_GROUP);
        PointerType.setSymmetric(ENTAILMENT, ENTAILED_BY);
        PointerType.setSymmetric(CATEGORY, CATEGORY_MEMBER);
        PointerType.setSymmetric(REGION, REGION_MEMBER);
        PointerType.setSymmetric(USAGE, USAGE_MEMBER);
        PointerType.setSymmetric(NOMINALIZATION, NOMINALIZATION);
    }
}

