### R code from vignette source 'medflex.Rnw'
### Encoding: UTF-8

###################################################
### code chunk number 1: medflex.Rnw:168-175
###################################################
options(prompt = "R> ", continue = "+  ", width = 80, #useFancyQuotes = "UTF-8",
        digits = 3)
  listing <- function(x, options) {
    paste("\\begin{lstlisting}[basicstyle=\\ttfamily,breaklines=true]\n",
      x, "\\end{lstlisting}\n", sep = "")
  }
  #knit_hooks$set(source=listing, output=listing)


###################################################
### code chunk number 2: medflex.Rnw:178-181
###################################################
library(medflex)
data(UPBdata)
head(UPBdata)


###################################################
### code chunk number 3: medflex.Rnw:289-291
###################################################
medFit <- glm(negaff ~ factor(attbin) + gender + educ + age, 
              family = gaussian, data = UPBdata)


###################################################
### code chunk number 4: medflex.Rnw:294-295
###################################################
expData <- neWeight(medFit)


###################################################
### code chunk number 5: medflex.Rnw:298-299
###################################################
head(expData, 4)


###################################################
### code chunk number 6: medflex.Rnw:303-306
###################################################
expData <- neWeight(negaff ~ factor(attbin) + gender + educ + age,
                    data = UPBdata)
head(expData, 4)


###################################################
### code chunk number 7: medflex.Rnw:310-312
###################################################
w <- weights(expData)
head(w, 10)


###################################################
### code chunk number 8: medflex.Rnw:361-365
###################################################
neMod1 <- neModel(UPB ~ attbin0 + attbin1 + gender + educ + age,
                  family = binomial("logit"), expData = expData, 
                  se = "robust")
summary(neMod1)


###################################################
### code chunk number 9: medflex.Rnw:378-379
###################################################
exp(confint(neMod1)[c("attbin01", "attbin11"), ])


###################################################
### code chunk number 10: medflex.Rnw:412-414
###################################################
impFit <- glm(UPB ~ factor(attbin) + negaff + gender + educ + age,
              family = binomial("logit"), data = UPBdata)


###################################################
### code chunk number 11: medflex.Rnw:418-419
###################################################
expData <- neImpute(impFit)


###################################################
### code chunk number 12: medflex.Rnw:422-424
###################################################
expData <- neImpute(UPB ~ factor(attbin) + negaff + gender + educ + age,
                    family = binomial("logit"), data = UPBdata)


###################################################
### code chunk number 13: medflex.Rnw:427-428
###################################################
head(expData, 4)


###################################################
### code chunk number 14: medflex.Rnw:433-436
###################################################
neMod1 <- neModel(UPB ~ attbin0 + attbin1 + gender + educ + age,
                  family = binomial("logit"), expData = expData, 
                  se = "robust")


###################################################
### code chunk number 15: medflex.Rnw:439-440
###################################################
summary(neMod1)


###################################################
### code chunk number 16: medflex.Rnw:475-478
###################################################
expData <- neImpute(UPB ~ attcat + negaff + gender + educ + age,
                    family = binomial, data = UPBdata)
head(expData)


###################################################
### code chunk number 17: medflex.Rnw:481-484
###################################################
neMod <- neModel(UPB ~ attcat0 + attcat1 + gender + educ + age,
                 family = binomial, expData = expData, se = "robust")
summary(neMod)


###################################################
### code chunk number 18: medflex.Rnw:487-489
###################################################
library(car)
Anova(neMod)


###################################################
### code chunk number 19: medflex.Rnw:497-500
###################################################
expData <- neImpute(UPB ~ att + negaff + gender + educ + age, 
                    family = binomial("logit"), data = UPBdata, nRep = 3)
head(expData)


###################################################
### code chunk number 20: medflex.Rnw:503-507
###################################################
neMod1 <- neModel(UPB ~ att0 + att1 + gender + educ + age,
                  family = binomial("logit"), expData = expData, 
                  se = "robust")
summary(neMod1)


###################################################
### code chunk number 21: medflex.Rnw:509-510
###################################################
summary(neMod1)


###################################################
### code chunk number 22: medflex.Rnw:539-545
###################################################
expData <- neImpute(UPB ~ att * negaff + gender + educ + age,
                    family = binomial("logit"), data = UPBdata)
neMod2 <- neModel(UPB ~ att0 * att1 + gender + educ + age,
                  family = binomial("logit"), expData = expData, 
                  se = "robust")
summary(neMod2)


###################################################
### code chunk number 23: medflex.Rnw:547-548
###################################################
summary(neMod2)


###################################################
### code chunk number 24: medflex.Rnw:558-564
###################################################
impData <- neImpute(UPB ~ (att + negaff) * gender + educ + age,
                    family = binomial("logit"), data = UPBdata)
neMod3 <- neModel(UPB ~ att0 + att1 * gender + educ + age,
                  family = binomial("logit"), expData = impData, 
                  se = "robust")
summary(neMod3)


###################################################
### code chunk number 25: medflex.Rnw:573-578
###################################################
impData <- neImpute(UPB ~ (att + negaff) * educ + gender + age,
                    family = binomial("logit"), data = UPBdata)
neMod4 <- neModel(UPB ~ (att0 + att1) * educ + gender + age,
                  family = binomial("logit"), expData = impData, 
                  se = "robust")


###################################################
### code chunk number 26: medflex.Rnw:588-591
###################################################
lht <- neLht(neMod2, linfct = c("att0 + att0:att1 = 0",
                                "att1 + att0:att1 = 0",
                                "att0 + att1 + att0:att1 = 0"))


###################################################
### code chunk number 27: medflex.Rnw:594-595
###################################################
exp(cbind(coef(lht), confint(lht)))


###################################################
### code chunk number 28: medflex.Rnw:598-599
###################################################
summary(lht)


###################################################
### code chunk number 29: medflex.Rnw:605-607
###################################################
effdecomp <- neEffdecomp(neMod2)
summary(effdecomp)


###################################################
### code chunk number 30: medflex.Rnw:633-635
###################################################
neEffdecomp(neMod3)
neEffdecomp(neMod3, covLev = c(gender = "M"))


###################################################
### code chunk number 31: medflex.Rnw:640-642
###################################################
modmed <- neLht(neMod4, linfct = c("att1:educM = 0", "att1:educH = 0"))
summary(modmed, test = Chisqtest())


###################################################
### code chunk number 32: plot2
###################################################
par(mfrow = c(1, 2))
plot(neMod2, xlab = "log odds ratio")
plot(neMod2, xlab = "odds ratio", transf = exp)


###################################################
### code chunk number 33: fig2
###################################################
par(mfrow = c(1, 2))
plot(neMod2, xlab = "log odds ratio")
plot(neMod2, xlab = "odds ratio", transf = exp)


###################################################
### code chunk number 34: medflex.Rnw:667-668
###################################################
expFit <- glm(att ~ gender + educ + age, data = UPBdata)


###################################################
### code chunk number 35: medflex.Rnw:671-673
###################################################
impData <- neImpute(UPB ~ att + negaff + gender + educ + age,
                    family = binomial("logit"), data = UPBdata)


###################################################
### code chunk number 36: medflex.Rnw:680-683
###################################################
neMod5 <- neModel(UPB ~ att0 + att1, family = binomial("logit"),
                  expData = impData, xFit = expFit, se = "robust")
summary(neMod5)


###################################################
### code chunk number 37: medflex.Rnw:686-688
###################################################
de <- neLht(neMod5, c("att0 = 0"))
ie <- neLht(neMod5, c("att1 = 0"))


###################################################
### code chunk number 38: medflex.Rnw:743-749
###################################################
impData <- neImpute(UPB ~ att + initiator * negaff + gender + educ + age,
                    family = binomial("logit"), nMed = 2, data = UPBdata)
neMod6 <- neModel(UPB ~ att0 + att1 + gender + educ + age,
                 family = binomial("logit"), expData = impData, 
                 se = "robust")
summary(neMod6)


