/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.fingerprint.FingerprinterToolTest")
public class FingerprinterTool {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(FingerprinterTool.class);

    @TestMethod(value="testIsSubset_BitSet_BitSet")
    public static boolean isSubset(BitSet bs1, BitSet bs2) {
        BitSet clone = (BitSet)bs1.clone();
        clone.and(bs2);
        return clone.equals(bs2);
    }

    @TestMethod(value="testListDifferences_BitSet_BitSet")
    public static List<Integer> listDifferences(BitSet bs1, BitSet bs2) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        logger.debug((Object)"Listing bit positions set in bs2 but not in bs1");
        for (int f = 0; f < bs2.size(); ++f) {
            if (!bs2.get(f) || bs1.get(f)) continue;
            l.add(f);
            logger.debug((Object)("Bit " + f + " not set in bs1"));
        }
        return l;
    }

    @TestMethod(value="testDifferences,testDifferences_Scenario")
    public static Set<Integer> differences(BitSet s, BitSet t) {
        BitSet u = (BitSet)s.clone();
        u.xor(t);
        TreeSet<Integer> differences = new TreeSet<Integer>();
        int i = u.nextSetBit(0);
        while (i >= 0) {
            differences.add(i);
            i = u.nextSetBit(i + 1);
        }
        return differences;
    }
}

