/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerComparator;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.tools.manipulator.AtomContainerSetManipulatorTest")
public class AtomContainerSetManipulator {
    @TestMethod(value="testGetAtomCount_IAtomContainerSet")
    public static int getAtomCount(IAtomContainerSet set) {
        int count = 0;
        for (IAtomContainer atomContainer : set.atomContainers()) {
            count += atomContainer.getAtomCount();
        }
        return count;
    }

    @TestMethod(value="testGetBondCount_IAtomContainerSet")
    public static int getBondCount(IAtomContainerSet set) {
        int count = 0;
        for (IAtomContainer atomContainer : set.atomContainers()) {
            count += atomContainer.getBondCount();
        }
        return count;
    }

    @TestMethod(value="testRemoveAtomAndConnectedElectronContainers_IAtomContainerSet_IAtom")
    public static void removeAtomAndConnectedElectronContainers(IAtomContainerSet set, IAtom atom) {
        for (IAtomContainer atomContainer : set.atomContainers()) {
            if (!atomContainer.contains(atom)) continue;
            atomContainer.removeAtomAndConnectedElectronContainers(atom);
            IAtomContainerSet molecules = ConnectivityChecker.partitionIntoMolecules(atomContainer);
            if (molecules.getAtomContainerCount() > 1) {
                set.removeAtomContainer(atomContainer);
                for (int k = 0; k < molecules.getAtomContainerCount(); ++k) {
                    set.addAtomContainer(molecules.getAtomContainer(k));
                }
            }
            return;
        }
    }

    @TestMethod(value="testRemoveElectronContainer_IAtomContainerSet_IElectronContainer")
    public static void removeElectronContainer(IAtomContainerSet set, IElectronContainer electrons) {
        for (IAtomContainer atomContainer : set.atomContainers()) {
            if (!atomContainer.contains(electrons)) continue;
            atomContainer.removeElectronContainer(electrons);
            IAtomContainerSet molecules = ConnectivityChecker.partitionIntoMolecules(atomContainer);
            if (molecules.getAtomContainerCount() > 1) {
                set.removeAtomContainer(atomContainer);
                for (int k = 0; k < molecules.getAtomContainerCount(); ++k) {
                    set.addAtomContainer(molecules.getAtomContainer(k));
                }
            }
            return;
        }
    }

    @TestMethod(value="testGetAllAtomContainers_IAtomContainerSet")
    public static List<IAtomContainer> getAllAtomContainers(IAtomContainerSet set) {
        ArrayList<IAtomContainer> atomContainerList = new ArrayList<IAtomContainer>();
        for (IAtomContainer atomContainer : set.atomContainers()) {
            atomContainerList.add(atomContainer);
        }
        return atomContainerList;
    }

    @TestMethod(value="testGetTotalCharge_IAtomContainerSet")
    public static double getTotalCharge(IAtomContainerSet set) {
        double charge = 0.0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            int thisCharge = AtomContainerManipulator.getTotalFormalCharge(set.getAtomContainer(i));
            double stoich = set.getMultiplier(i);
            charge += stoich * (double)thisCharge;
        }
        return charge;
    }

    @TestMethod(value="testGetTotalFormalCharge_IAtomContainerSet")
    public static double getTotalFormalCharge(IAtomContainerSet set) {
        int charge = 0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            int thisCharge = AtomContainerManipulator.getTotalFormalCharge(set.getAtomContainer(i));
            double stoich = set.getMultiplier(i);
            charge = (int)((double)charge + stoich * (double)thisCharge);
        }
        return charge;
    }

    @TestMethod(value="testGetTotalHydrogenCount_IAtomContainerSet")
    public static int getTotalHydrogenCount(IAtomContainerSet set) {
        int hCount = 0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            hCount += AtomContainerManipulator.getTotalHydrogenCount(set.getAtomContainer(i));
        }
        return hCount;
    }

    @TestMethod(value="testGetAllIDs_IAtomContainerSet")
    public static List<String> getAllIDs(IAtomContainerSet set) {
        ArrayList<String> idList = new ArrayList<String>();
        if (set != null) {
            if (set.getID() != null) {
                idList.add(set.getID());
            }
            for (int i = 0; i < set.getAtomContainerCount(); ++i) {
                idList.addAll(AtomContainerManipulator.getAllIDs(set.getAtomContainer(i)));
            }
        }
        return idList;
    }

    @TestMethod(value="testSetAtomProperties_IAtomContainerSet_Object_Object")
    public static void setAtomProperties(IAtomContainerSet set, Object propKey, Object propVal) {
        if (set != null) {
            for (int i = 0; i < set.getAtomContainerCount(); ++i) {
                AtomContainerManipulator.setAtomProperties(set.getAtomContainer(i), propKey, propVal);
            }
        }
    }

    @TestMethod(value="testGetRelevantAtomContainer_IAtomContainerSet_IAtom")
    public static IAtomContainer getRelevantAtomContainer(IAtomContainerSet containerSet, IAtom atom) {
        for (IAtomContainer atomContainer : containerSet.atomContainers()) {
            if (!atomContainer.contains(atom)) continue;
            return atomContainer;
        }
        return null;
    }

    @TestMethod(value="testGetRelevantAtomContainer_IAtomContainerSet_IBond")
    public static IAtomContainer getRelevantAtomContainer(IAtomContainerSet containerSet, IBond bond) {
        for (IAtomContainer atomContainer : containerSet.atomContainers()) {
            if (!atomContainer.contains(bond)) continue;
            return atomContainer;
        }
        return null;
    }

    @TestMethod(value="testGetAllChemObjects_IAtomContainerSet")
    public static List<IChemObject> getAllChemObjects(IAtomContainerSet set) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        list.add((IChemObject)set);
        for (IAtomContainer atomContainer : set.atomContainers()) {
            list.add((IChemObject)atomContainer);
        }
        return list;
    }

    @TestMethod(value="testSort_IAtomContainerSet")
    public static void sort(IAtomContainerSet atomContainerSet) {
        List<IAtomContainer> atomContainerList = AtomContainerSetManipulator.getAllAtomContainers(atomContainerSet);
        Collections.sort(atomContainerList, new AtomContainerComparator());
        atomContainerSet.removeAllAtomContainers();
        for (IAtomContainer anAtomContainerList : atomContainerList) {
            atomContainerSet.addAtomContainer(anAtomContainerList);
        }
    }

    @TestMethod(value="testContainsByID_IAtomContainerSet_IAtomContainer")
    public static boolean containsByID(IAtomContainerSet atomContainerSet, String id) {
        for (IAtomContainer ac : atomContainerSet.atomContainers()) {
            if (ac.getID() == null || !ac.getID().equals(id)) continue;
            return true;
        }
        return false;
    }
}

