/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Polar;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Real2;

public class Complex
extends Real2 {
    public Complex() {
    }

    public Complex(double a) {
        super(a, 0.0);
    }

    public Complex(double a, double b) {
        super(a, b);
    }

    public Complex(Real2 a) {
        this.x = a.x;
        this.y = a.y;
    }

    public Complex(double r, Angle th) {
        Polar p = new Polar(r, th);
        this.x = p.getX();
        this.y = p.getY();
    }

    public Complex(Polar p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public Complex(Complex a) {
        this.x = a.x;
        this.y = a.y;
    }

    public double getReal() {
        return this.x;
    }

    public double getImaginary() {
        return this.y;
    }

    public void negative() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public Complex multiply(Complex f) {
        Complex temp = new Complex(this);
        temp.x = this.x * f.x - this.y * f.y;
        temp.y = this.x * f.y + this.y * f.x;
        return temp;
    }

    public Complex divideBy(Complex f) throws EuclidRuntimeException {
        double denom = f.x * f.x + f.y * f.y;
        if (Real.isZero(denom, Real.getEpsilon())) {
            throw new EuclidRuntimeException("cannot divide by zero");
        }
        Complex temp = new Complex(f.x, -f.y);
        temp = new Complex(temp.multiply(this).multiplyBy(1.0 / denom));
        return temp;
    }

    public double getR() {
        double t = Math.sqrt(this.x * this.x + this.y * this.y);
        return t;
    }

    public Angle getTheta() {
        return new Angle(this.y, this.x);
    }

    public Polar getPolar() {
        return new Polar(this.getR(), this.getTheta());
    }

    public static Complex sqrt(Complex a) {
        Polar temp = new Polar(a);
        temp.r = Math.sqrt(temp.r);
        temp.theta *= 0.5;
        return new Complex(temp);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.x + "," + this.y);
        return sb.toString();
    }
}

