/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.dict.Dictionary;
import org.openscience.cdk.dict.DictionaryDatabase;
import org.openscience.cdk.dict.EntryReact;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.reaction.ReactionEngineTest")
public class ReactionEngine {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ReactionEngine.class);
    private Dictionary dictionary;
    public HashMap<String, Object> paramsMap;
    public IReactionMechanism mechanism;
    public List<IParameterReact> paramsMap2;

    public ReactionEngine() {
        try {
            IReactionProcess reaction = (IReactionProcess)((Object)this);
            EntryReact entry = this.initiateDictionary("reaction-processes", reaction);
            this.initiateParameterMap2(entry);
            reaction.setParameterList(this.getParameterList());
            this.extractMechanism(entry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void extractMechanism(EntryReact entry) {
        String mechanismName = "org.openscience.cdk.reaction.mechanism." + entry.getMechanism();
        try {
            this.mechanism = (IReactionMechanism)this.getClass().getClassLoader().loadClass(mechanismName).newInstance();
            logger.info((Object)"Loaded mechanism: ", new Object[]{mechanismName});
        }
        catch (ClassNotFoundException exception) {
            logger.error((Object)"Could not find this IReactionMechanism: ", new Object[]{mechanismName});
            logger.debug((Object)exception);
        }
        catch (Exception exception) {
            logger.error((Object)"Could not load this IReactionMechanism: ", new Object[]{mechanismName});
            logger.debug((Object)exception);
        }
    }

    private EntryReact initiateDictionary(String nameDict, IReactionProcess reaction) {
        DictionaryDatabase db = new DictionaryDatabase();
        this.dictionary = db.getDictionary(nameDict);
        String entryString = reaction.getSpecification().getSpecificationReference();
        entryString = entryString.substring(entryString.indexOf("#") + 1, entryString.length());
        return (EntryReact)this.dictionary.getEntry(entryString.toLowerCase());
    }

    private void initiateParameterMap2(EntryReact entry) {
        List paramDic = entry.getParameterClass();
        this.paramsMap2 = new ArrayList<IParameterReact>();
        for (List param : paramDic) {
            String paramName = "org.openscience.cdk.reaction.type.parameters." + (String)param.get(0);
            try {
                IParameterReact ipc = (IParameterReact)this.getClass().getClassLoader().loadClass(paramName).newInstance();
                ipc.setParameter(Boolean.parseBoolean((String)param.get(1)));
                ipc.setValue(param.get(2));
                logger.info((Object)"Loaded parameter class: ", new Object[]{paramName});
                this.paramsMap2.add(ipc);
            }
            catch (ClassNotFoundException exception) {
                logger.error((Object)"Could not find this IParameterReact: ", new Object[]{paramName});
                logger.debug((Object)exception);
            }
            catch (Exception exception) {
                logger.error((Object)"Could not load this IParameterReact: ", new Object[]{paramName});
                logger.debug((Object)exception);
            }
        }
    }

    @TestMethod(value="testSetParameterList_List")
    public void setParameterList(List<IParameterReact> params) throws CDKException {
        this.paramsMap2 = params;
    }

    @TestMethod(value="testGetParameterList")
    public List<IParameterReact> getParameterList() {
        return this.paramsMap2;
    }

    @TestMethod(value="testGetParameterClass_Class")
    public IParameterReact getParameterClass(Class<?> paramClass) {
        for (IParameterReact ipr : this.paramsMap2) {
            if (!ipr.getClass().equals(paramClass)) continue;
            return ipr;
        }
        return null;
    }
}

