/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.matchers;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.smsd.algorithm.matchers.AtomMatcher;

@TestClass(value="org.openscience.cdk.smsd.algorithm.vflib.VFLibTest")
public class DefaultRGraphAtomMatcher
implements AtomMatcher {
    static final long serialVersionUID = -7861469841127327812L;
    private int maximumNeighbors = -1;
    private String symbol = null;
    private IAtom qAtom = null;
    private boolean shouldMatchBonds = false;

    public boolean isBondMatchFlag() {
        return this.shouldMatchBonds;
    }

    public final void setBondMatchFlag(boolean shouldMatchBonds) {
        this.shouldMatchBonds = shouldMatchBonds;
    }

    public DefaultRGraphAtomMatcher() {
    }

    public DefaultRGraphAtomMatcher(IAtomContainer queryContainer, IAtom atom, boolean shouldMatchBonds) {
        this();
        this.qAtom = atom;
        this.symbol = atom.getSymbol();
        this.setBondMatchFlag(shouldMatchBonds);
    }

    public DefaultRGraphAtomMatcher(IAtomContainer queryContainer, IAtom template, int blockedPositions, boolean shouldMatchBonds) {
        this(queryContainer, template, shouldMatchBonds);
        this.maximumNeighbors = this.countSaturation(queryContainer, template) - blockedPositions;
    }

    @Override
    public boolean matches(IAtomContainer targetContainer, IAtom targetAtom) {
        if (this.qAtom instanceof IQueryAtom ? !((IQueryAtom)this.qAtom).matches(targetAtom) : !this.matchSymbol(targetAtom)) {
            return false;
        }
        return this.matchMaximumNeighbors(targetContainer, targetAtom);
    }

    public void setMaximumNeighbors(int maximum) {
        this.maximumNeighbors = maximum;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    private boolean matchSymbol(IAtom atom) {
        if (this.symbol == null) {
            return false;
        }
        return this.symbol.equals(atom.getSymbol());
    }

    private boolean matchMaximumNeighbors(IAtomContainer targetContainer, IAtom targetAtom) {
        if (this.maximumNeighbors == -1 || !this.isBondMatchFlag()) {
            return true;
        }
        int maximumTargetNeighbors = this.countSaturation(targetContainer, targetAtom);
        return maximumTargetNeighbors >= this.maximumNeighbors;
    }

    private int countImplicitHydrogens(IAtom atom) {
        return atom.getImplicitHydrogenCount() == null ? 0 : atom.getImplicitHydrogenCount();
    }

    private int countSaturation(IAtomContainer container, IAtom atom) {
        return this.countNeighbors(container, atom) + this.countImplicitHydrogens(atom);
    }

    private int countNeighbors(IAtomContainer container, IAtom atom) {
        return container.getConnectedAtomsCount(atom);
    }
}

