/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.smsd.helper.FinalMappings;

@TestClass(value="org.openscience.cdk.smsd.filters.PostFilterTest")
public class PostFilter {
    @TestMethod(value="testFilter")
    public static List<Map<Integer, Integer>> filter(List<List<Integer>> mappings) {
        FinalMappings final_MAPPINGS = FinalMappings.getInstance();
        if (mappings != null && !mappings.isEmpty()) {
            final_MAPPINGS.set(PostFilter.removeRedundantMapping(mappings));
            mappings.clear();
        } else {
            final_MAPPINGS.set(new ArrayList<Map<Integer, Integer>>());
        }
        return final_MAPPINGS.getFinalMapping();
    }

    private static boolean hasMap(Map<Integer, Integer> newMap, List<Map<Integer, Integer>> nonRedundantMapping) {
        for (Map<Integer, Integer> storedMap : nonRedundantMapping) {
            if (!((Object)storedMap).equals(newMap)) continue;
            return true;
        }
        return false;
    }

    private static List<Map<Integer, Integer>> removeRedundantMapping(List<List<Integer>> mapping_org) {
        ArrayList<Map<Integer, Integer>> nonRedundantMapping = new ArrayList<Map<Integer, Integer>>();
        for (List<Integer> M : mapping_org) {
            Map<Integer, Integer> newMap = PostFilter.getMappingMapFromList(M);
            if (PostFilter.hasMap(newMap, nonRedundantMapping)) continue;
            nonRedundantMapping.add(newMap);
        }
        return nonRedundantMapping;
    }

    private static Map<Integer, Integer> getMappingMapFromList(List<Integer> list) {
        TreeMap<Integer, Integer> newMap = new TreeMap<Integer, Integer>();
        for (int index = 0; index < list.size(); index += 2) {
            newMap.put(list.get(index), list.get(index + 1));
        }
        return newMap;
    }
}

