/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.ring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.smsd.ring.PathEdge;
import org.openscience.cdk.smsd.ring.PathGraph;
import org.openscience.cdk.smsd.ring.RingFinder;

public class HanserRingFinder
implements RingFinder {
    private List<List<IAtom>> rings = new ArrayList<List<IAtom>>();

    @Override
    public Collection<List<IAtom>> findRings(IAtomContainer molecule) {
        if (molecule == null) {
            return null;
        }
        this.rings.clear();
        PathGraph graph = new PathGraph(molecule);
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            List<PathEdge> edges = graph.remove(molecule.getAtom(i));
            for (PathEdge edge : edges) {
                List<IAtom> ring = edge.getAtoms();
                this.rings.add(ring);
            }
        }
        return this.rings;
    }

    @Override
    public IRingSet getRingSet(IAtomContainer molecule) throws CDKException {
        Collection<List<IAtom>> cycles = this.findRings(molecule);
        IRingSet ringSet = (IRingSet)molecule.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (List<IAtom> ringAtoms : cycles) {
            IRing ring = (IRing)molecule.getBuilder().newInstance(IRing.class, new Object[0]);
            for (IAtom atom : ringAtoms) {
                atom.setFlag(2, true);
                ring.addAtom(atom);
                for (IAtom atomNext : ringAtoms) {
                    IBond bond;
                    if (atom.equals(atomNext) || (bond = molecule.getBond(atom, atomNext)) == null) continue;
                    bond.setFlag(2, true);
                    ring.addElectronContainer((IElectronContainer)bond);
                }
            }
            ringSet.addAtomContainer((IAtomContainer)ring);
        }
        return ringSet;
    }
}

