/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.surface;

import java.util.ArrayList;
import java.util.Iterator;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.surface.NeighborList;
import org.openscience.cdk.geometry.surface.Tessellate;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class NumericalSurface {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(NumericalSurface.class);
    double solvent_radius = 1.4;
    int tesslevel = 4;
    IAtom[] atoms;
    ArrayList[] surf_points;
    double[] areas;
    double[] volumes;

    public NumericalSurface(IAtomContainer atomContainer) {
        this.atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)atomContainer);
    }

    public NumericalSurface(IAtomContainer atomContainer, double solvent_radius, int tesslevel) {
        this.solvent_radius = solvent_radius;
        this.atoms = AtomContainerManipulator.getAtomArray((IAtomContainer)atomContainer);
        this.tesslevel = tesslevel;
    }

    public void calculateSurface() {
        Point3d cp = new Point3d(0.0, 0.0, 0.0);
        double max_radius = 0.0;
        for (int i = 0; i < this.atoms.length; ++i) {
            double vdwr = PeriodicTable.getVdwRadius((String)this.atoms[i].getSymbol());
            if (vdwr + this.solvent_radius > max_radius) {
                max_radius = PeriodicTable.getVdwRadius((String)this.atoms[i].getSymbol()) + this.solvent_radius;
            }
            cp.x += this.atoms[i].getPoint3d().x;
            cp.y += this.atoms[i].getPoint3d().y;
            cp.z += this.atoms[i].getPoint3d().z;
        }
        cp.x /= (double)this.atoms.length;
        cp.y /= (double)this.atoms.length;
        cp.z /= (double)this.atoms.length;
        Tessellate tess = new Tessellate("ico", this.tesslevel);
        tess.doTessellate();
        logger.info((Object)("Got tesselation, number of triangles = " + tess.getNumberOfTriangles()));
        NeighborList nbrlist = new NeighborList(this.atoms, max_radius + this.solvent_radius);
        logger.info((Object)"Got neighbor list");
        this.surf_points = new ArrayList[this.atoms.length];
        this.areas = new double[this.atoms.length];
        this.volumes = new double[this.atoms.length];
        for (int i = 0; i < this.atoms.length; ++i) {
            int point_density = tess.getNumberOfTriangles() * 3;
            Point3d[][] points = this.atomicSurfacePoints(nbrlist, i, this.atoms[i], tess);
            this.translatePoints(i, points, point_density, this.atoms[i], cp);
        }
        logger.info((Object)"Obtained points, areas and volumes");
    }

    public Point3d[] getAllSurfacePoints() {
        int npt = 0;
        for (int i = 0; i < this.surf_points.length; ++i) {
            npt += this.surf_points[i].size();
        }
        Point3d[] ret = new Point3d[npt];
        int j = 0;
        for (int i = 0; i < this.surf_points.length; ++i) {
            ArrayList arl = this.surf_points[i];
            Iterator it = arl.iterator();
            while (it.hasNext()) {
                ret[j] = (Point3d)it.next();
                ++j;
            }
        }
        return ret;
    }

    public Point3d[] getSurfacePoints(int atomIdx) throws CDKException {
        if (atomIdx >= this.surf_points.length) {
            throw new CDKException("Atom index was out of bounds");
        }
        ArrayList arl = this.surf_points[atomIdx];
        Point3d[] ret = new Point3d[arl.size()];
        for (int i = 0; i < arl.size(); ++i) {
            ret[i] = (Point3d)arl.get(i);
        }
        return ret;
    }

    public double getSurfaceArea(int atomIdx) throws CDKException {
        if (atomIdx >= this.surf_points.length) {
            throw new CDKException("Atom index was out of bounds");
        }
        return this.areas[atomIdx];
    }

    public double[] getAllSurfaceAreas() {
        return this.areas;
    }

    public double getTotalSurfaceArea() {
        double ta = 0.0;
        for (int i = 0; i < this.areas.length; ++i) {
            ta += this.areas[i];
        }
        return ta;
    }

    private void translatePoints(int atmIdx, Point3d[][] points, int point_density, IAtom atom, Point3d cp) {
        double total_radius = PeriodicTable.getVdwRadius((String)atom.getSymbol()) + this.solvent_radius;
        double area = Math.PI * 4 * (total_radius * total_radius) * (double)points.length / (double)point_density;
        double sumx = 0.0;
        double sumy = 0.0;
        double sumz = 0.0;
        for (int i = 0; i < points.length; ++i) {
            Point3d p = points[i][1];
            sumx += p.x;
            sumy += p.y;
            sumz += p.z;
        }
        double vconst = 4.1887902047863905 / (double)point_density;
        double dotp1 = (atom.getPoint3d().x - cp.x) * sumx + (atom.getPoint3d().y - cp.y) * sumy + (atom.getPoint3d().z - cp.z) * sumz;
        double volume = vconst * (total_radius * total_radius) * dotp1 + total_radius * total_radius * total_radius * (double)points.length;
        this.areas[atmIdx] = area;
        this.volumes[atmIdx] = volume;
        ArrayList<Point3d> tmp = new ArrayList<Point3d>();
        for (int i = 0; i < points.length; ++i) {
            tmp.add(points[i][0]);
        }
        this.surf_points[atmIdx] = tmp;
    }

    private Point3d[][] atomicSurfacePoints(NeighborList nbrlist, int currAtomIdx, IAtom atom, Tessellate tess) {
        double total_radius = PeriodicTable.getVdwRadius((String)atom.getSymbol()) + this.solvent_radius;
        double total_radius2 = total_radius * total_radius;
        double twice_total_radius = 2.0 * total_radius;
        int[] nlist = nbrlist.getNeighbors(currAtomIdx);
        double[][] data = new double[nlist.length][4];
        for (int i = 0; i < nlist.length; ++i) {
            double x12 = this.atoms[nlist[i]].getPoint3d().x - atom.getPoint3d().x;
            double y12 = this.atoms[nlist[i]].getPoint3d().y - atom.getPoint3d().y;
            double z12 = this.atoms[nlist[i]].getPoint3d().z - atom.getPoint3d().z;
            double d2 = x12 * x12 + y12 * y12 + z12 * z12;
            double tmp = PeriodicTable.getVdwRadius((String)this.atoms[nlist[i]].getSymbol()) + this.solvent_radius;
            tmp *= tmp;
            double thresh = (d2 + total_radius2 - tmp) / twice_total_radius;
            data[i][0] = x12;
            data[i][1] = y12;
            data[i][2] = z12;
            data[i][3] = thresh;
        }
        Point3d[] tess_points = tess.getTessAsPoint3ds();
        ArrayList<Point3d[]> points = new ArrayList<Point3d[]>();
        for (int i = 0; i < tess_points.length; ++i) {
            Point3d pt = tess_points[i];
            boolean buried = false;
            for (int j = 0; j < data.length; ++j) {
                if (!(data[j][0] * pt.x + data[j][1] * pt.y + data[j][2] * pt.z > data[j][3])) continue;
                buried = true;
                break;
            }
            if (buried) continue;
            Point3d[] tmp = new Point3d[]{new Point3d(total_radius * pt.x + atom.getPoint3d().x, total_radius * pt.y + atom.getPoint3d().y, total_radius * pt.z + atom.getPoint3d().z), pt};
            points.add(tmp);
        }
        Point3d[][] ret = new Point3d[points.size()][2];
        for (int i = 0; i < points.size(); ++i) {
            Point3d[] tmp = (Point3d[])points.get(i);
            ret[i][0] = tmp[0];
            ret[i][1] = tmp[1];
        }
        return ret;
    }
}

