/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.geometry.surface.NumericalSurface;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.CPSADescriptorTest")
public class CPSADescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"PPSA-1", "PPSA-2", "PPSA-3", "PNSA-1", "PNSA-2", "PNSA-3", "DPSA-1", "DPSA-2", "DPSA-3", "FPSA-1", "FPSA-2", "FPSA-3", "FNSA-1", "FNSA-2", "FNSA-3", "WPSA-1", "WPSA-2", "WPSA-3", "WNSA-1", "WNSA-2", "WNSA-3", "RPCG", "RNCG", "RPCS", "RNCS", "THSA", "TPSA", "RHSA", "RPSA"};
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CPSADescriptor.class);

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#CPSA", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        NumericalSurface surface;
        IAtomContainer container;
        DoubleArrayResult retval = new DoubleArrayResult();
        if (!GeometryTools.has3DCoordinates((IAtomContainer)atomContainer)) {
            for (int i = 0; i < 29; ++i) {
                retval.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)retval, this.getDescriptorNames(), (Exception)((Object)new CDKException("Molecule must have 3D coordinates")));
        }
        try {
            container = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.debug((Object)"Error during clone");
            for (int i = 0; i < 29; ++i) {
                retval.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)retval, this.getDescriptorNames(), (Exception)((Object)new CDKException("Error during clone" + e.getMessage())));
        }
        try {
            GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
            peoe.assignGasteigerMarsiliSigmaPartialCharges(container, true);
        }
        catch (Exception e) {
            logger.debug((Object)"Error in assigning Gasteiger-Marsilli charges");
            for (int i = 0; i < 29; ++i) {
                retval.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)retval, this.getDescriptorNames(), (Exception)((Object)new CDKException("Error in getting G-M charges")));
        }
        try {
            surface = new NumericalSurface(container);
            surface.calculateSurface();
        }
        catch (NullPointerException npe) {
            logger.debug((Object)"Error in surface area calculation");
            for (int i = 0; i < 29; ++i) {
                retval.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)retval, this.getDescriptorNames(), (Exception)((Object)new CDKException("Error in surface area calculation")));
        }
        double[] atomSurfaces = surface.getAllSurfaceAreas();
        double totalSA = surface.getTotalSurfaceArea();
        double ppsa1 = 0.0;
        double ppsa3 = 0.0;
        double pnsa1 = 0.0;
        double pnsa3 = 0.0;
        double totpcharge = 0.0;
        double totncharge = 0.0;
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (container.getAtom(i).getCharge() > 0.0) {
                ppsa1 += atomSurfaces[i];
                ppsa3 += container.getAtom(i).getCharge() * atomSurfaces[i];
                totpcharge += container.getAtom(i).getCharge().doubleValue();
                continue;
            }
            pnsa1 += atomSurfaces[i];
            pnsa3 += container.getAtom(i).getCharge() * atomSurfaces[i];
            totncharge += container.getAtom(i).getCharge().doubleValue();
        }
        double ppsa2 = ppsa1 * totpcharge;
        double pnsa2 = pnsa1 * totncharge;
        double fpsa1 = ppsa1 / totalSA;
        double fpsa2 = ppsa2 / totalSA;
        double fpsa3 = ppsa3 / totalSA;
        double fnsa1 = pnsa1 / totalSA;
        double fnsa2 = pnsa2 / totalSA;
        double fnsa3 = pnsa3 / totalSA;
        double wpsa1 = ppsa1 * totalSA / 1000.0;
        double wpsa2 = ppsa2 * totalSA / 1000.0;
        double wpsa3 = ppsa3 * totalSA / 1000.0;
        double wnsa1 = pnsa1 * totalSA / 1000.0;
        double wnsa2 = pnsa2 * totalSA / 1000.0;
        double wnsa3 = pnsa3 * totalSA / 1000.0;
        double phobic = 0.0;
        double polar = 0.0;
        for (int i = 0; i < container.getAtomCount(); ++i) {
            if (Math.abs(container.getAtom(i).getCharge()) < 0.2) {
                phobic += atomSurfaces[i];
                continue;
            }
            polar += atomSurfaces[i];
        }
        double thsa = phobic;
        double tpsa = polar;
        double rhsa = phobic / totalSA;
        double rpsa = polar / totalSA;
        double dpsa1 = ppsa1 - pnsa1;
        double dpsa2 = ppsa2 - pnsa2;
        double dpsa3 = ppsa3 - pnsa3;
        double maxpcharge = 0.0;
        double maxncharge = 0.0;
        int pidx = 0;
        int nidx = 0;
        for (int i = 0; i < container.getAtomCount(); ++i) {
            double charge = container.getAtom(i).getCharge();
            if (charge > maxpcharge) {
                maxpcharge = charge;
                pidx = i;
            }
            if (!(charge < maxncharge)) continue;
            maxncharge = charge;
            nidx = i;
        }
        double rpcg = maxpcharge / totpcharge;
        double rncg = maxncharge / totncharge;
        double rpcs = atomSurfaces[pidx] * rpcg;
        double rncs = atomSurfaces[nidx] * rncg;
        retval.add(ppsa1);
        retval.add(ppsa2);
        retval.add(ppsa3);
        retval.add(pnsa1);
        retval.add(pnsa2);
        retval.add(pnsa3);
        retval.add(dpsa1);
        retval.add(dpsa2);
        retval.add(dpsa3);
        retval.add(fpsa1);
        retval.add(fpsa2);
        retval.add(fpsa3);
        retval.add(fnsa1);
        retval.add(fnsa2);
        retval.add(fnsa3);
        retval.add(wpsa1);
        retval.add(wpsa2);
        retval.add(wpsa3);
        retval.add(wnsa1);
        retval.add(wnsa2);
        retval.add(wnsa3);
        retval.add(rpcg);
        retval.add(rncg);
        retval.add(rpcs);
        retval.add(rncs);
        retval.add(thsa);
        retval.add(tpsa);
        retval.add(rhsa);
        retval.add(rpsa);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)retval, this.getDescriptorNames());
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(29);
    }
}

