/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.pharmacophore.PharmacophoreAtomTest")
public class PharmacophoreAtom
extends Atom {
    private String smarts;
    private int[] matchingAtoms;

    public PharmacophoreAtom(String smarts, String symbol, Point3d coordinates) {
        this.smarts = smarts;
        this.symbol = symbol;
        this.setPoint3d(coordinates);
    }

    public PharmacophoreAtom(PharmacophoreAtom pharmacophoreAtom) {
        this.smarts = pharmacophoreAtom.getSmarts();
        this.symbol = pharmacophoreAtom.getSymbol();
        this.setPoint3d(new Point3d(pharmacophoreAtom.getPoint3d()));
        if (pharmacophoreAtom.getMatchingAtoms() != null) {
            int[] indices = pharmacophoreAtom.getMatchingAtoms();
            this.matchingAtoms = new int[indices.length];
            System.arraycopy(indices, 0, this.matchingAtoms, 0, indices.length);
        }
    }

    @TestMethod(value="testGetterSetter")
    public void setSmarts(String smarts) {
        this.smarts = smarts;
    }

    @TestMethod(value="testGetterSetter")
    public String getSmarts() {
        return this.smarts;
    }

    @TestMethod(value="testMatchingAtoms")
    public void setMatchingAtoms(int[] atomIndices) {
        this.matchingAtoms = new int[atomIndices.length];
        System.arraycopy(atomIndices, 0, this.matchingAtoms, 0, atomIndices.length);
    }

    @TestMethod(value="testMatchingAtoms")
    public int[] getMatchingAtoms() {
        return this.matchingAtoms;
    }

    @TestMethod(value="testEquals")
    public boolean equals(Object o) {
        if (!(o instanceof PharmacophoreAtom)) {
            return false;
        }
        PharmacophoreAtom patom = (PharmacophoreAtom)((Object)o);
        Arrays.sort(this.matchingAtoms);
        int[] tmp = patom.getMatchingAtoms();
        Arrays.sort(tmp);
        boolean atomIndicesMatch = true;
        if (this.matchingAtoms.length == tmp.length) {
            for (int i = 0; i < this.matchingAtoms.length; ++i) {
                if (tmp[i] == this.matchingAtoms[i]) continue;
                atomIndicesMatch = false;
                break;
            }
        } else {
            atomIndicesMatch = false;
        }
        return this.smarts.equals(patom.getSmarts()) && this.symbol.equals(patom.getSymbol()) && this.point3d.equals((Tuple3d)patom.getPoint3d()) && atomIndicesMatch;
    }
}

