/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.RandomNumber;
import org.openscience.cdk.fingerprint.ShortestPathWalker;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

@TestClass(value="org.openscience.cdk.fingerprint.ShortestPathFingerprinterTest")
public class ShortestPathFingerprinter
extends RandomNumber
implements IFingerprinter,
Serializable {
    public static final int DEFAULT_SIZE = 1024;
    private static final long serialVersionUID = 7867864332244557861L;
    private int fingerprintLength;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ShortestPathFingerprinter.class);

    public ShortestPathFingerprinter() {
        this(1024);
    }

    public ShortestPathFingerprinter(int fingerprintLength) {
        this.fingerprintLength = fingerprintLength;
    }

    @TestMethod(value="testgetBitFingerprint_IAtomContainer")
    public IBitFingerprint getBitFingerprint(IAtomContainer ac) throws CDKException {
        IAtomContainer atomContainer = null;
        try {
            atomContainer = ac.clone();
        }
        catch (CloneNotSupportedException ex) {
            logger.error((Object)"Failed to clone the molecule:", new Object[]{ex});
        }
        Aromaticity.cdkLegacy().apply(atomContainer);
        BitSet bitSet = new BitSet(this.fingerprintLength);
        if (!ConnectivityChecker.isConnected((IAtomContainer)atomContainer)) {
            IAtomContainerSet partitionedMolecules = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)atomContainer);
            for (IAtomContainer container : partitionedMolecules.atomContainers()) {
                this.addUniquePath(container, bitSet);
            }
        } else {
            this.addUniquePath(atomContainer, bitSet);
        }
        return new BitSetFingerprint(bitSet);
    }

    @TestMethod(value="testGetRawFingerprint")
    public Map<String, Integer> getRawFingerprint(IAtomContainer ac) throws CDKException {
        throw new UnsupportedOperationException();
    }

    private void addUniquePath(IAtomContainer container, BitSet bitSet) {
        Integer[] hashes;
        for (Integer hash : hashes = this.findPaths(container)) {
            int position = this.getRandomNumber(hash);
            bitSet.set(position);
        }
    }

    private void addUniquePath(IAtomContainer atomContainer, Map<String, Integer> uniquePaths) {
        Integer[] hashes;
        for (Integer hash : hashes = this.findPaths(atomContainer)) {
            int position = this.getRandomNumber(hash);
            uniquePaths.put(String.valueOf(position), hash);
        }
    }

    private Integer[] findPaths(IAtomContainer container) {
        ShortestPathWalker walker = new ShortestPathWalker(container);
        ArrayList<Integer> paths = new ArrayList<Integer>();
        int patternIndex = 0;
        for (String s : walker.paths()) {
            int toHashCode = s.hashCode();
            paths.add(patternIndex, toHashCode);
            ++patternIndex;
        }
        IRingSet sssr = Cycles.essential((IAtomContainer)container).toRingSet();
        RingSetManipulator.sort((IRingSet)sssr);
        for (IAtomContainer ring : sssr.atomContainers()) {
            int toHashCode = String.valueOf(ring.getAtomCount()).hashCode();
            paths.add(patternIndex, toHashCode);
            ++patternIndex;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (IAtom atom : container.atoms()) {
            int charge = atom.getFormalCharge() == null ? 0 : atom.getFormalCharge();
            if (charge == 0) continue;
            l.add(atom.getSymbol().concat(String.valueOf(charge)));
        }
        Collections.sort(l);
        int toHashCode = ((Object)l).hashCode();
        paths.add(patternIndex, toHashCode);
        ++patternIndex;
        l = new ArrayList();
        for (IAtom atom : container.atoms()) {
            int st = atom.getStereoParity() == null ? 0 : atom.getStereoParity();
            if (st == 0) continue;
            l.add(atom.getSymbol().concat(String.valueOf(st)));
        }
        Collections.sort(l);
        toHashCode = ((Object)l).hashCode();
        paths.add(patternIndex, toHashCode);
        ++patternIndex;
        if (container.getSingleElectronCount() > 0) {
            StringBuilder radicalInformation = new StringBuilder();
            radicalInformation.append("RAD: ").append(String.valueOf(container.getSingleElectronCount()));
            paths.add(patternIndex, radicalInformation.toString().hashCode());
            ++patternIndex;
        }
        if (container.getLonePairCount() > 0) {
            StringBuilder lpInformation = new StringBuilder();
            lpInformation.append("LP: ").append(String.valueOf(container.getLonePairCount()));
            paths.add(patternIndex, lpInformation.toString().hashCode());
            ++patternIndex;
        }
        return paths.toArray(new Integer[paths.size()]);
    }

    @TestMethod(value="testGetSize")
    public int getSize() {
        return this.fingerprintLength;
    }

    @TestMethod(value="testGetCountFingerprint")
    public ICountFingerprint getCountFingerprint(IAtomContainer iac) throws CDKException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private int getRandomNumber(Integer hashValue) {
        return this.generateMersenneTwisterRandomNumber(this.fingerprintLength, hashValue.intValue());
    }
}

