/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.AbstractResourceFormat;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.PubChemCompoundXMLFormatTest")
public class PubChemCompoundXMLFormat
extends AbstractResourceFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new PubChemCompoundXMLFormat();
        }
        return myself;
    }

    @Override
    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "PubChem Compound XML";
    }

    @Override
    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return null;
    }

    @Override
    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"xml"};
    }

    @Override
    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.PCCompoundXMLReader";
    }

    @Override
    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return null;
    }

    @Override
    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return true;
    }

    @Override
    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return 0;
    }

    @Override
    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 0;
    }

    @Override
    @TestMethod(value="testMatches")
    public IChemFormatMatcher.MatchResult matches(List<String> lines) {
        IChemFormatMatcher.MatchResult result = NO_MATCH;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.contains("<PC-Compound") && result == NO_MATCH) {
                result = new IChemFormatMatcher.MatchResult(true, this, i);
            }
            if (!line.contains("<PC-Compounds")) continue;
            return NO_MATCH;
        }
        return result;
    }
}

