/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import signature.AbstractGraphBuilder;

public class VirtualGraphBuilder
extends AbstractGraphBuilder {
    private List<VirtualEdge> edges = new ArrayList<VirtualEdge>();

    public String toEdgeString() {
        StringBuffer edgeString = new StringBuffer();
        Collections.sort(this.edges);
        for (VirtualEdge edge : this.edges) {
            edgeString.append(edge.toString()).append(",");
        }
        return edgeString.toString();
    }

    public void makeEdge(int vertexIndex1, int vertexIndex2, String vertexSymbol1, String vertexSymbol2, String edgeLabel) {
        this.edges.add(new VirtualEdge(vertexIndex1, vertexIndex2, vertexSymbol1, vertexSymbol2, edgeLabel));
    }

    public void makeGraph() {
        this.edges.clear();
    }

    public void makeVertex(String label) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VirtualEdge
    implements Comparable<VirtualEdge> {
        public final int lowerVertexIndex;
        public final int upperVertexIndex;
        public final String lowerVertexSymbol;
        public final String upperVertexSymbol;
        public final String edgeLabel;

        public VirtualEdge(int vertexIndex1, int vertexIndex2, String vertexSymbol1, String vertexSymbol2, String edgeLabel) {
            if (vertexIndex1 < vertexIndex2) {
                this.lowerVertexIndex = vertexIndex1;
                this.upperVertexIndex = vertexIndex2;
                this.lowerVertexSymbol = vertexSymbol1;
                this.upperVertexSymbol = vertexSymbol2;
            } else {
                this.lowerVertexIndex = vertexIndex2;
                this.upperVertexIndex = vertexIndex1;
                this.lowerVertexSymbol = vertexSymbol2;
                this.upperVertexSymbol = vertexSymbol1;
            }
            this.edgeLabel = edgeLabel;
        }

        @Override
        public int compareTo(VirtualEdge o) {
            if (this.lowerVertexIndex < o.lowerVertexIndex) {
                return -1;
            }
            if (this.lowerVertexIndex == o.lowerVertexIndex) {
                if (this.upperVertexIndex < o.upperVertexIndex) {
                    return -1;
                }
                if (this.upperVertexIndex == o.upperVertexIndex) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }

        public String toString() {
            return this.lowerVertexIndex + this.lowerVertexSymbol + ":" + this.upperVertexIndex + this.upperVertexSymbol + "(" + this.edgeLabel + ")";
        }
    }
}

