/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Arrays;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.graph.ShortestPathsTest")
public final class ShortestPaths {
    private static final int[] EMPTY_PATH = new int[0];
    private static final int[][] EMPTY_PATHS = new int[0][];
    private final Route[] routeTo;
    private final int[] distTo;
    private final int[] nPathsTo;
    private final boolean[] precedes;
    private final int start;
    private final int limit;
    private final IAtomContainer container;

    @TestMethod(value="testConstructor_Container_Empty,testConstructor_Container_Null,testConstructor_Container_MissingAtom")
    public ShortestPaths(IAtomContainer container, IAtom start) {
        this(GraphUtil.toAdjList(container), container, container.getAtomNumber(start));
    }

    ShortestPaths(int[][] adjacent, IAtomContainer container, int start) {
        this(adjacent, container, start, null);
    }

    ShortestPaths(int[][] adjacent, IAtomContainer container, int start, int[] ordering) {
        this(adjacent, container, start, adjacent.length, ordering);
    }

    ShortestPaths(int[][] adjacent, IAtomContainer container, int start, int limit, int[] ordering) {
        int n = adjacent.length;
        this.container = container;
        this.start = start;
        this.limit = limit;
        this.distTo = new int[n];
        this.routeTo = new Route[n];
        this.nPathsTo = new int[n];
        this.precedes = new boolean[n];
        if (n == 0) {
            return;
        }
        if (start == -1) {
            throw new IllegalArgumentException("invalid vertex start - atom not found container");
        }
        for (int i = 0; i < n; ++i) {
            this.distTo[i] = Integer.MAX_VALUE;
        }
        this.distTo[start] = 0;
        this.routeTo[start] = new Source(start);
        this.nPathsTo[start] = 1;
        this.precedes[start] = true;
        if (ordering != null) {
            this.compute(adjacent, ordering);
        } else {
            this.compute(adjacent);
        }
    }

    private void compute(int[][] adjacent) {
        int[] queue = new int[adjacent.length];
        queue[0] = this.start;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            int v = queue[i];
            int dist = this.distTo[v] + 1;
            for (int w : adjacent[v]) {
                if (dist > this.limit) continue;
                if (dist < this.distTo[w]) {
                    this.distTo[w] = dist;
                    this.routeTo[w] = new SequentialRoute(this.routeTo[v], w);
                    this.nPathsTo[w] = this.nPathsTo[v];
                    queue[n++] = w;
                    continue;
                }
                if (this.distTo[w] != dist) continue;
                this.routeTo[w] = new Branch(this.routeTo[w], new SequentialRoute(this.routeTo[v], w));
                int n2 = w;
                this.nPathsTo[n2] = this.nPathsTo[n2] + this.nPathsTo[v];
            }
        }
    }

    private void compute(int[][] adjacent, int[] ordering) {
        int[] queue = new int[adjacent.length];
        queue[0] = this.start;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            int v = queue[i];
            int dist = this.distTo[v] + 1;
            for (int w : adjacent[v]) {
                if (dist < this.distTo[w]) {
                    this.distTo[w] = dist;
                    this.routeTo[w] = new SequentialRoute(this.routeTo[v], w);
                    this.nPathsTo[w] = this.nPathsTo[v];
                    this.precedes[w] = this.precedes[v] && ordering[w] < ordering[this.start];
                    queue[n++] = w;
                    continue;
                }
                if (this.distTo[w] != dist || !this.precedes[v] || ordering[w] >= ordering[this.start]) continue;
                if (this.precedes[w]) {
                    this.routeTo[w] = new Branch(this.routeTo[w], new SequentialRoute(this.routeTo[v], w));
                    int n2 = w;
                    this.nPathsTo[n2] = this.nPathsTo[n2] + this.nPathsTo[v];
                    continue;
                }
                this.precedes[w] = true;
                this.routeTo[w] = new SequentialRoute(this.routeTo[v], w);
            }
        }
    }

    @TestMethod(value="testPathTo_Int_Simple,testPathTo_Int_Benzene,testPathTo_Int_Norbornane,testPathTo_Int_Spiroundecane,testPathTo_Int_Pentadecaspiro,testPathTo_Int_OutOfBoundsIndex,testPathTo_Int_NegativeIndex,testPathTo_Int_Disconnected")
    public int[] pathTo(int end) {
        if (end < 0 || end >= this.routeTo.length) {
            return EMPTY_PATH;
        }
        return this.routeTo[end] != null ? this.routeTo[end].toPath(this.distTo[end] + 1) : EMPTY_PATH;
    }

    @TestMethod(value="testPathTo_Atom_Simple,testPathTo_Atom_Benzene,testPathTo_Atom_Norbornane,testPathTo_Atom_Spiroundecane,testPathTo_Atom_Pentadecaspiro,testPathTo_Atom_MissingAtom,testPathTo_Atom_Null,testPathTo_Atom_Disconnected")
    public int[] pathTo(IAtom end) {
        return this.pathTo(this.container.getAtomNumber(end));
    }

    @TestMethod(value="testIsPrecedingPathTo_OutOfBounds,testIsPrecedingPathTo")
    public boolean isPrecedingPathTo(int end) {
        return (end >= 0 || end < this.routeTo.length) && this.precedes[end];
    }

    @TestMethod(value="testPathsTo_Int_Simple,testPathsTo_Int_Benzene,testPathsTo_Int_Spiroundecane,testPathsTo_Int_Norbornane,testPathsTo_Int_OutOfBoundsIndex,testPathsTo_Int_NegativeIndex,testPathsTo_Int_Disconnected")
    public int[][] pathsTo(int end) {
        if (end < 0 || end >= this.routeTo.length) {
            return EMPTY_PATHS;
        }
        return this.routeTo[end] != null ? this.routeTo[end].toPaths(this.distTo[end] + 1) : EMPTY_PATHS;
    }

    @TestMethod(value="testPathsTo_Atom_Simple,testPathsTo_Atom_Benzene,testPathsTo_Atom_Spiroundecane,testPathsTo_Atom_Norbornane,testPathsTo_Atom_Pentadecaspiro,testPathsTo_Atom_MissingAtom,testPathsTo_Atom_Null,testPathsTo_Atom_Disconnected")
    public int[][] pathsTo(IAtom end) {
        return this.pathsTo(this.container.getAtomNumber(end));
    }

    @TestMethod(value="testAtomsTo_Int_Simple,testAtomsTo_Int_Benzene,testAtomsTo_Int_Disconnected,testAtomsTo_Int_OutOfBoundsIndex,testAtomsTo_Int_NegativeIndex")
    public IAtom[] atomsTo(int end) {
        int[] path = this.pathTo(end);
        IAtom[] atoms = new IAtom[path.length];
        int n = path.length;
        for (int i = 0; i < n; ++i) {
            atoms[i] = this.container.getAtom(path[i]);
        }
        return atoms;
    }

    @TestMethod(value="testAtomsTo_Atom_Simple,testAtomsTo_Atom_Benzene,testAtomsTo_Atom_Disconnected,testAtomsTo_Atom_MissingAtom,testAtomsTo_Atom_Null")
    public IAtom[] atomsTo(IAtom end) {
        return this.atomsTo(this.container.getAtomNumber(end));
    }

    @TestMethod(value="testNPathsTo_Int_Simple,testNPathsTo_Int_Benzene,testNPathsTo_Int_Norbornane,testNPathsTo_Int_Spiroundecane,testNPathsTo_Int_Pentadecaspiro,testNPathsTo_Int_Disconnected,testNPathsTo_Int_OutOfBoundIndex,testNPathsTo_Int_NegativeIndex")
    public int nPathsTo(int end) {
        return end < 0 || end >= this.nPathsTo.length ? 0 : this.nPathsTo[end];
    }

    @TestMethod(value="testNPathsTo_Atom_Simple,testNPathsTo_Atom_Benzene,testNPathsTo_Atom_Norbornane,testNPathsTo_Atom_Spiroundecane,testNPathsTo_Atom_Pentadecaspiro,testNPathsTo_Atom_Disconnected,testNPathsTo_Atom_MissingAtom,testNPathsTo_Atom_Null")
    public int nPathsTo(IAtom end) {
        return this.nPathsTo(this.container.getAtomNumber(end));
    }

    @TestMethod(value="testDistanceTo_Int_Simple,testDistanceTo_Int_OutOfBoundIndex,testDistanceTo_Int_NegativeIndex,testDistanceTo_Int_Disconnected,testDistanceTo_Int_Benzene,testDistanceTo_Int_Spiroundecane,testDistanceTo_Int_Pentadecaspiro")
    public int distanceTo(int end) {
        return end < 0 || end >= this.nPathsTo.length ? Integer.MAX_VALUE : this.distTo[end];
    }

    @TestMethod(value="testDistanceTo_Atom_Simple,testDistanceTo_Atom_MissingAtom,testDistanceTo_Atom_Null,testDistanceTo_Atom_Disconnected,testDistanceTo_Atom_Benzene,testDistanceTo_Atom_Spiroundecane,testDistanceTo_Atom_Pentadecaspiro")
    public int distanceTo(IAtom end) {
        return this.distanceTo(this.container.getAtomNumber(end));
    }

    private class Branch
    implements Route {
        private final Route left;
        private final Route right;

        private Branch(Route left, Route right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int[][] toPaths(int n) {
            int[][] leftPaths = this.left.toPaths(n);
            int[][] rightPaths = this.right.toPaths(n);
            int[][] paths = (int[][])Arrays.copyOf(leftPaths, leftPaths.length + rightPaths.length);
            System.arraycopy(rightPaths, 0, paths, leftPaths.length, rightPaths.length);
            return paths;
        }

        @Override
        public int[] toPath(int n) {
            return this.left.toPath(n);
        }
    }

    private class SequentialRoute
    implements Route {
        private final int v;
        private final Route parent;

        private SequentialRoute(Route parent, int v) {
            this.v = v;
            this.parent = parent;
        }

        @Override
        public int[][] toPaths(int n) {
            int[][] paths = this.parent.toPaths(n);
            int i = ShortestPaths.this.distTo[this.v];
            for (int[] path : paths) {
                path[i] = this.v;
            }
            return paths;
        }

        @Override
        public int[] toPath(int n) {
            int[] path = this.parent.toPath(n);
            path[((ShortestPaths)ShortestPaths.this).distTo[this.v]] = this.v;
            return path;
        }
    }

    private static class Source
    implements Route {
        private final int v;

        public Source(int v) {
            this.v = v;
        }

        @Override
        public int[][] toPaths(int n) {
            return new int[][]{this.toPath(n)};
        }

        @Override
        public int[] toPath(int n) {
            int[] path = new int[n];
            path[0] = this.v;
            return path;
        }
    }

    private static interface Route {
        public int[][] toPaths(int var1);

        public int[] toPath(int var1);
    }
}

