/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.selectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.data.discretization.DiscretizationMethod;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.NumericSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;

public interface SGSelectorGenerator {
    public Collection<SGSelector> getSelectors(Attribute var1, DataView var2);

    public static abstract class AbstractNumericSelectorGenerator
    implements SGSelectorGenerator {
        List<Double> cutpoints;
        DiscretizationMethod discMethod;

        public AbstractNumericSelectorGenerator(DiscretizationMethod discMethod) {
            this.discMethod = discMethod;
        }

        protected void prepareDiscMethod(Attribute numAtt, DataView dataView) {
            this.discMethod.setAttribute((NumericAttribute)numAtt);
            this.discMethod.setPopulation(dataView);
        }
    }

    public static class AllCombinationsSelectorGenerator
    extends AbstractNumericSelectorGenerator {
        public AllCombinationsSelectorGenerator(DiscretizationMethod discMethod) {
            super(discMethod);
        }

        @Override
        public Collection<SGSelector> getSelectors(Attribute numAtt, DataView dataview) {
            if (!(numAtt instanceof NumericAttribute)) {
                throw new IllegalArgumentException("This SelectorGenerator is only applicable for numeric attributes!");
            }
            this.prepareDiscMethod(numAtt, dataview);
            this.cutpoints = this.discMethod.getCutpoints();
            this.cutpoints.add(Double.NEGATIVE_INFINITY);
            this.cutpoints.add(Double.POSITIVE_INFINITY);
            Collections.sort(this.cutpoints);
            if (!(numAtt instanceof NumericAttribute)) {
                throw new IllegalArgumentException("This SelectorGenerator is only applicable for numeric attributes!");
            }
            HashSet<SGSelector> resultSet = new HashSet<SGSelector>();
            int i = 0;
            while (i < this.cutpoints.size() - 1) {
                int j = i + 1;
                while (j < this.cutpoints.size()) {
                    double lowerBound = (Double)this.cutpoints.get(i);
                    double upperBound = (Double)this.cutpoints.get(j);
                    if (i != 0 || j != this.cutpoints.size() - 1) {
                        NumericSelector sel = new NumericSelector((NumericAttribute)numAtt, lowerBound, upperBound, true, false);
                        resultSet.add(sel);
                    }
                    ++j;
                }
                ++i;
            }
            return resultSet;
        }
    }

    public static class AllExtremeValueBasedSelectorGenerator
    extends AbstractNumericSelectorGenerator {
        boolean includeSimpleIntervals;

        public AllExtremeValueBasedSelectorGenerator(DiscretizationMethod discMethod, boolean simpleIntervals) {
            super(discMethod);
            this.includeSimpleIntervals = simpleIntervals;
        }

        @Override
        public Collection<SGSelector> getSelectors(Attribute numAtt, DataView dataview) {
            NumericSelector sel;
            double upperBound;
            double lowerBound;
            int i;
            if (!(numAtt instanceof NumericAttribute)) {
                throw new IllegalArgumentException("This SelectorGenerator is only applicable for numeric attributes!");
            }
            this.prepareDiscMethod(numAtt, dataview);
            this.cutpoints = this.discMethod.getCutpoints();
            this.cutpoints.add(Double.NEGATIVE_INFINITY);
            this.cutpoints.add(Double.POSITIVE_INFINITY);
            Collections.sort(this.cutpoints);
            ArrayList<SGSelector> result = new ArrayList<SGSelector>();
            if (this.includeSimpleIntervals) {
                i = 0;
                while (i < this.cutpoints.size() - 1) {
                    lowerBound = (Double)this.cutpoints.get(i);
                    sel = new NumericSelector((NumericAttribute)numAtt, lowerBound, upperBound = ((Double)this.cutpoints.get(i + 1)).doubleValue(), true, false);
                    if (!result.contains(sel)) {
                        result.add(sel);
                    }
                    ++i;
                }
            }
            i = 1;
            while (i < this.cutpoints.size() - 1) {
                lowerBound = (Double)this.cutpoints.get(0);
                sel = new NumericSelector((NumericAttribute)numAtt, lowerBound, upperBound = ((Double)this.cutpoints.get(i)).doubleValue(), true, false);
                if (!result.contains(sel)) {
                    result.add(sel);
                }
                ++i;
            }
            i = 1;
            while (i < this.cutpoints.size() - 1) {
                lowerBound = (Double)this.cutpoints.get(i);
                sel = new NumericSelector((NumericAttribute)numAtt, lowerBound, upperBound = ((Double)this.cutpoints.get(this.cutpoints.size() - 1)).doubleValue(), true, false);
                if (!result.contains(sel)) {
                    result.add(sel);
                }
                ++i;
            }
            return result;
        }
    }

    public static class EmptySelectorSetGenerator
    implements SGSelectorGenerator {
        @Override
        public Collection<SGSelector> getSelectors(Attribute att, DataView dataview) {
            return Collections.emptyList();
        }
    }

    public static class SimpleNumericSelectorGenerator
    extends AbstractNumericSelectorGenerator {
        public SimpleNumericSelectorGenerator(DiscretizationMethod discMethod) {
            super(discMethod);
        }

        @Override
        public Collection<SGSelector> getSelectors(Attribute numAtt, DataView dataview) {
            if (!(numAtt instanceof NumericAttribute)) {
                throw new IllegalArgumentException("This SelectorGenerator is only applicable for numeric attributes!");
            }
            this.prepareDiscMethod(numAtt, dataview);
            this.cutpoints = this.discMethod.getCutpoints();
            this.cutpoints.add(Double.NEGATIVE_INFINITY);
            this.cutpoints.add(Double.POSITIVE_INFINITY);
            Collections.sort(this.cutpoints);
            ArrayList<SGSelector> result = new ArrayList<SGSelector>();
            int i = 0;
            while (i < this.cutpoints.size() - 1) {
                double upperBound;
                double lowerBound = (Double)this.cutpoints.get(i);
                NumericSelector sel = new NumericSelector((NumericAttribute)numAtt, lowerBound, upperBound = ((Double)this.cutpoints.get(i + 1)).doubleValue(), true, false);
                if (!result.contains(sel)) {
                    result.add(sel);
                }
                ++i;
            }
            return result;
        }
    }

    public static class SimpleValueSelectorGenerator
    implements SGSelectorGenerator {
        static final int MAX_NUMBER_VALUES = 50;

        @Override
        public Collection<SGSelector> getSelectors(Attribute att, DataView dataview) {
            ArrayList<SGSelector> result = new ArrayList<SGSelector>();
            if (att.isNominal() && ((NominalAttribute)att).getValuesCount() < 50) {
                NominalAttribute nomAtt = (NominalAttribute)att;
                Iterator<Value> valIterator = nomAtt.allValuesIterator();
                while (valIterator.hasNext()) {
                    Value value = valIterator.next();
                    DefaultSGSelector sel = new DefaultSGSelector(att, value);
                    result.add(sel);
                }
            }
            return result;
        }
    }

    public static class SimpleValueSelectorGeneratorIgnoreDefaults
    implements SGSelectorGenerator {
        @Override
        public Collection<SGSelector> getSelectors(Attribute att, DataView dataview) {
            ArrayList<SGSelector> result = new ArrayList<SGSelector>();
            if (att.isNominal() && ((NominalAttribute)att).getValuesCount() < 50) {
                NominalAttribute nomAtt = (NominalAttribute)att;
                Iterator<Value> valIterator = nomAtt.allValuesIterator();
                while (valIterator.hasNext()) {
                    Value value = valIterator.next();
                    if (value.isDefaultValue()) continue;
                    DefaultSGSelector sel = new DefaultSGSelector(att, value);
                    result.add(sel);
                }
            }
            return result;
        }
    }

    public static class SplitSelectorGenerator
    implements SGSelectorGenerator {
        SGSelectorGenerator nominalSelectorGenerator;
        SGSelectorGenerator numericSelectorGenerator;

        public SplitSelectorGenerator(SGSelectorGenerator nominalSelectorGenerator, SGSelectorGenerator numericSelectorGenerator) {
            this.nominalSelectorGenerator = nominalSelectorGenerator;
            this.numericSelectorGenerator = numericSelectorGenerator;
        }

        @Override
        public Collection<SGSelector> getSelectors(Attribute att, DataView dataview) {
            if (att.isNominal()) {
                return this.nominalSelectorGenerator.getSelectors(att, dataview);
            }
            if (att.isNumeric()) {
                return this.numericSelectorGenerator.getSelectors(att, dataview);
            }
            return Collections.EMPTY_LIST;
        }
    }
}

