### Name: FPTrasch
### Title: Bayesian analysis for a Finite Polya Tree Rasch model
### Aliases: FPTrasch FPTrasch.default
### Keywords: models nonparametric

### ** Examples

## Not run: 
##D     ####################################
##D     # A simulated Data Set
##D     ####################################
##D       nsubject<-200
##D       nitem<-5
##D       
##D       y<-matrix(0,nrow=nsubject,ncol=nitem)
##D       dimnames(y)<-list(paste("id",seq(1:nsubject)), 
##D                         paste("item",seq(1,nitem)))
##D 
##D       
##D       ind<-rbinom(nsubject,1,0.5)
##D       theta<-ind*rnorm(nsubject,-1,0.5)+(1-ind)*rnorm(nsubject,2,0.5)
##D       beta<-c(0,seq(-3,3,length=nitem-1))
##D 
##D       for(i in 1:nsubject)
##D       {
##D          for(j in 1:nitem)
##D          {
##D             eta<-theta[i]-beta[j]         
##D             mean<-exp(eta)/(1+exp(eta))
##D             y[i,j]<-rbinom(1,1,mean)
##D          }
##D       }
##D 
##D     # Prior information
##D 
##D       beta0<-rep(0,nitem-1)
##D       Sbeta0<-diag(100,nitem-1)
##D 
##D       prior<-list(alpha=1,tau1=0.01,tau2=0.01,mub=0,Sb=1,
##D                   beta0=beta0,Sbeta0=Sbeta0,M=8)
##D 
##D     # Initial state
##D       state <- NULL      
##D 
##D     # MCMC parameters
##D 
##D       nburn<-5000
##D       nsave<-25000
##D       nskip<-20
##D       ndisplay<-1000
##D       mcmc <- list(nburn=nburn,nsave=nsave,nskip=nskip,
##D                    ndisplay=ndisplay)
##D 
##D     # Fit the model
##D       fit1<-FPTrasch(y=y,prior=prior,mcmc=mcmc,
##D                      state=state,status=TRUE)
##D 
##D     # Summary with HPD and Credibility intervals
##D       summary(fit1)
##D       summary(fit1,hpd=FALSE)
##D 
##D     # Plot model parameters 
##D     # (to see the plots gradually set ask=TRUE)
##D       plot(fit1,ask=FALSE)
##D       plot(fit1,ask=FALSE,nfigr=2,nfigc=2)      
##D 
##D     # Extract random effects
##D     
##D       DPrandom(fit1)
##D       plot(DPrandom(fit1))
##D       DPcaterpillar(DPrandom(fit1))
## End(Not run)



