### Name: PTdensity
### Title: Nonparametric Bayesian density estimation using Mixtures of
###   Polya Trees
### Aliases: PTdensity PTdensity.default
### Keywords: models nonparametric

### ** Examples

## Not run: 
##D     ####################################
##D     # Univariate example
##D     ####################################
##D 
##D     # Data
##D       data(galaxy)
##D       galaxy<-data.frame(galaxy,speeds=galaxy$speed/1000) 
##D       attach(galaxy)
##D 
##D     # Initial state
##D       state <- NULL
##D 
##D     # MCMC parameters
##D       nburn<-100
##D       nsave<-1000
##D       nskip<-10
##D       ndisplay<-100
##D       mcmc <- list(nburn=nburn,nsave=nsave,nskip=nskip,ndisplay=ndisplay,
##D                    tune1=0.15,tune2=1.1,tune3=1.1)
##D 
##D     # Prior information
##D       prior<-list(alpha=1,M=8)
##D 
##D     # Fitting the model
##D 
##D       fit1<-PTdensity(y=speeds,ngrid=1000,prior=prior,mcmc=mcmc,
##D                        state=state,status=TRUE)
##D 
##D     # Posterior means
##D       fit1
##D 
##D     # Plot the estimated density
##D       plot(fit1,ask=FALSE)
##D 
##D     # Plot the parameters
##D     # (to see the plots gradually set ask=TRUE)
##D       plot(fit1,ask=FALSE,output="param")
##D 
##D     # Extracting the density estimate
##D       cbind(fit1$x1,fit1$dens)
##D 
##D 
##D     ####################################
##D     # Bivariate example
##D     ####################################
##D 
##D     # Data
##D       data(airquality)
##D       attach(airquality)
##D 
##D       ozone<-Ozone**(1/3)
##D       radiation<-Solar.R
##D 
##D     # Prior information
##D 
##D       prior<-list(a0=5,b0=1,M=4)
##D 
##D     # Initial state
##D       state <- NULL
##D 
##D     # MCMC parameters
##D 
##D       nburn<-5000
##D       nsave<-10000
##D       nskip<-10
##D       ndisplay<-1000
##D       mcmc <- list(nburn=nburn,nsave=nsave,nskip=nskip,ndisplay=ndisplay,
##D                    tune1=0.5,tune2=1.5,tune3=10.5)
##D 
##D     # Fitting the model
##D       fit1<-PTdensity(y=cbind(radiation,ozone),prior=prior,mcmc=mcmc,
##D                       state=state,status=TRUE,na.action=na.omit)
##D 
##D     # Plot the estimated density
##D       plot(fit1)
##D 
##D     # Extracting the density estimate
##D       fit1$x1
##D       fit1$x2
##D       fit1$dens
## End(Not run)



