### Name: commandArgs
### Title: Extract Command Line Arguments
### Aliases: commandArgs
### Keywords: programming

### ** Examples

  # Get all arguments
  commandArgs()

  ## Spawn a copy of this application as it was invoked.
  ## system(paste(commandArgs(), collapse=" "))

  # Get only "private" arguments and not the name of the R executable.
  commandArgs(excludeReserved=TRUE)[-1]

  # If R is started as
  #   R DATAPATH=../data --args --root="do da" --foo bar --details --a=2
  # then commandArgs(asValue=TRUE) returns a list like
  #   list(R=NA, DATAPATH="../data" args=TRUE, root="do da", foo="bar", details=TRUE, a="2")



