### Name: lazy
### Title: Nonlinear noise reduction
### Aliases: lazy nrlazy
### Keywords: ts

### ** Examples

## Not run: 
##D 
##D par(mfrow=c(1,2))
##D 
##D n <- 5000
##D dat <- henon(n)
##D dat[,1] <- dat[,1] + rnorm(n)/25
##D delayeddat <- embed(dat,d=2)
##D filtereddat <- lazy(dat,m=5,v=0.05,c=2)
##D delayedfiltdat <- embed(filtereddat,d=2)
##D plot(delayeddat, cex= 0.2, cex.main=0.7, xlab="", ylab="", main = "Embedded noisy Henon attractor filtered with lazy")
##D points(delayedfiltdat, cex=0.2, col=2)
##D legend(-1,-0.5, c("Noisy data","Filtered data"),fill=c(1,2),bty="n",cex=0.7)
##D 
##D filteredat2 <- nrlazy(dat,m=5,v=0.2)[,1]
##D delayedfiltdat2 <- embed(filteredat2,d=2)
##D plot(delayeddat, cex= 0.2, cex.main=0.7,xlab="", ylab="", main =  "Embedded noisy Henon attractor filtered with nrlazy")
##D points(delayedfiltdat2 , cex=0.2, col=2)
##D legend(-1,-0.5, c("Noisy data","Filtered data"),fill=c(1,2),bty="n",cex=0.7)
##D 
## End(Not run)



