### Name: lfo.run
### Title: Modeling data through a local linear ansatz
### Aliases: nstep lfo.run
### Keywords: models ts

### ** Examples

## Not run: 
##D 
##D par(mfrow=c(2,1))
##D dat<-logistic(r=3.6)
##D nsteppred<-lfo.run(dat[1:950])
##D plot(dat[951:1000],t="l",xlab="Time",ylab="x",ylim=c(0.2,0.9),
##D main="Local linear model on logistic data")
##D lines(nsteppred,col=2)
##D validiter<-length(nsteppred)
##D 
##D legend(40,0.35, "Real data",fill=1,bty="n",cex=0.7)
##D legend(40,0.3, "Artificial data",fill=2,bty="n",cex=0.7)
##D 
##D par(cex.lab=0.8)
##D plot(abs(dat[951:1000][1:validiter]-nsteppred),t="l",xlim=c(1,50),xlab="Time",ylab="Distance from original time series")
##D text(40,1,paste("Last neighbor found at iteration", validiter),cex=0.7)
##D 
## End(Not run)



