### Name: bodyAsExpression
### Title: Get body of function as an expression.
### Aliases: bodyAsExpression as.language
### Keywords: symbolmath

### ** Examples

## Not run: 
##D 
##D # construct an R function for the Burr probability density
##D # function (PDF) given the Burr cumulative distribution function (CDF)
##D BurrCDF <- function(x, c = 1, k = 1) 1-(1+x^c)^-k
##D 
##D # transfer CDF to yacas
##D yacas(BurrCDF)
##D 
##D # create a template for the PDF from the CDF
##D BurrPDF <- BurrCDF
##D 
##D # differentiate CDF and place resulting expression in body
##D body(BurrPDF) <- yacas(expression(deriv(BurrCDF(x,c,k))))[[1]]
##D 
##D # test out PDF
##D BurrPDF(1)
##D 
## End(Not run)




