### Name: format.earth
### Title: Format 'earth' objects
### Aliases: format.earth
### Keywords: models

### ** Examples

a <- earth(Volume ~ ., data = trees)
cat(format(a))

# yields:
#      23.20824
#      +  5.745962 * pmax(0,  Girth -   12.9)
#      -  2.866452 * pmax(0,   12.9 -  Girth)
#      + 0.7183364 * pmax(0, Height -     76)

cat(format(a, use.names = FALSE, add.labels = TRUE))

# yields:
#      23.20824  # 1
#      +  5.745962 * pmax(0, x[,1] -  12.9)  # 2
#      -  2.866452 * pmax(0,  12.9 - x[,1])  # 3
#      + 0.7183364 * pmax(0, x[,2] -    76)  # 4



