### Name: mars.to.earth
### Title: Convert a 'mars' to an 'earth' object
### Aliases: mars.to.earth
### Keywords: models

### ** Examples

## Not run: 
##D # The example is not run with example("mars.to.earth") because that would
##D # require making the earth package dependent on the mda package.
##D 
##D library(mda)
##D a <- mars(trees[,-3], trees[,3])
##D a <- mars.to.earth(a)
##D summary(a, digits = 2) # the standard earth functions can now be used
##D 
##D # yields (note the reconstructed call):
##D #    Call:
##D #    earth(x = trees[, -3], y = trees[, 3])
##D #
##D #    Expression:
##D #      20
##D #      +  5.4 * pmax(0,  Girth -     12)
##D #      -  2.6 * pmax(0,     12 -  Girth)
##D #      + 0.72 * pmax(0, Height -     76)
##D #
##D #    Number of cases: 31
##D #    Selected 4 of 5 terms, and 2 of 2 predictors
##D #    Number of terms at each degree of interaction: 1 3 (additive model)
##D #    GCV: 13     RSS: 251     GRSq: 0.95     RSq: 0.97
##D 
## End(Not run)



