### Name: model.matrix.earth
### Title: Get the 'earth' basis matrix
### Aliases: model.matrix.earth
### Keywords: models

### ** Examples

data(trees)
a <- earth(Volume ~ ., data = trees)
summary(a, decomp = "none") # "none" to print terms in same seq as a.lm below

# yields:
#    Call:
#    earth(formula = Volume ~ ., data = trees)
#
#    Expression:
#      23.20824
#      +  5.745962 * pmax(0,  Girth -   12.9)
#      -  2.866452 * pmax(0,   12.9 -  Girth)
#      + 0.7183364 * pmax(0, Height -     76)
#
#    Number of cases: 31
#    Selected 4 of 5 terms, and 2 of 2 predictors
#    Number of terms at each degree of interaction: 1 3 (additive model)
#    GCV: 11.48697     RSS: 213.4354     GRSq: 0.958859     RSq: 0.9736697

bx <- model.matrix(a)               # equivalent to bx <- a$bx
a.lm <- lm(trees$Volume ~ bx[,-1])  # -1 to drop intercept
summary(a.lm)                       # yields same coeffs as above summary
                                    # displayed p values are not meaningful
# yields:
#    Call:
#    lm(formula = trees$Volume ~ bx[, -1])
#
#    Residuals:
#         Min       1Q   Median       3Q      Max
#    -5.28999 -1.97818  0.07124  1.92087  4.12673
#
#    Coefficients:
#                          Estimate Std. Error t value Pr(>|t|)
#    (Intercept)            23.2082     0.9968  23.283  < 2e-16
#    bx[, -1]h(Girth-12.9)   5.7460     0.2969  19.352  < 2e-16
#    bx[, -1]h(12.9-Girth)  -2.8665     0.4443  -6.452 6.48e-07
#    bx[, -1]h(Height-76)    0.7183     0.1750   4.105 0.000335
#
#    Residual standard error: 2.812 on 27 degrees of freedom
#    Multiple R-Squared: 0.9737,        Adjusted R-squared: 0.9707
#    F-statistic: 332.8 on 3 and 27 DF,  p-value: < 2.2e-16



