### Name: plotmo
### Title: Plot Model Response
### Aliases: plotmo
### Keywords: models regression

### ** Examples

data(ozone1)
a <- earth(O3 ~ ., data = ozone1, degree = 2)
plotmo(a)

# example with some arguments:
# plotmo(a, caption = "example", ylim = NULL, degree1 = c(1,2,4),
#   degree2 = 4, col.response = 3, clip = FALSE, ticktype = "d", theta = -30)

# examples using functions other than earth:
#
# plotmo(lm(O3 ~ log(temp) + humidity*temp, data=ozone1), se=2)
#
# library(gam)
# data(airquality)
# airquality <- na.omit(airquality)  # plotmo doesn't know how to deal with NAs
# plotmo(gam(Ozone^(1/3) ~ lo(Solar.R) + lo(Wind, Temp), data = airquality))
#
# library(mgcv)
# plotmo(gam(O3 ~ s(doy) + s(humidity,temp), data=ozone1), se=2, ylim=NA)



