### Name: EllipticalCopulae
### Title: Bivariate Elliptical Copulae
### Aliases: EllipticalCopulae rellipticalCopula pellipticalCopula
###   dellipticalCopula rellipticalSlider pellipticalSlider
###   dellipticalSlider
### Keywords: models

### ** Examples

## Not run: 
##D ## [rp]ellipticalCopula -
##D    # Default Normal Copula:
##D    rellipticalCopula(10)
##D    pellipticalCopula(10)
##D 
##D ## [rp]ellipticalCopula -   
##D    # Student-t Copula Probability and Density:
##D    u = grid2d(x = (0:25)/25)
##D    pellipticalCopula(u, rho = 0.75, param = 4, 
##D      type = "t", output = "list")
##D    d = dellipticalCopula(u, rho = 0.75, param = 4, 
##D      type = "t", output = "list")   
##D    persp(d, theta = -40, phi = 30, col = "steelblue")
##D    
##D ## ellipticalTau -
##D ## ellipticalRho -
##D    # Dependence Measures:
##D    ellipticalTau(rho = -0.5)
##D    ellipticalRho(rho = 0.75, type = "logistic", subdivisions = 100)
##D    
##D ## ellipticalTailCoeff -
##D    # Student-t Tail Coefficient:
##D    ellipticalTailCoeff(rho = 0.25, param = 3, type = "t")
##D 
##D ## gfunc -
##D    # Generator Function:
##D    plot(gfunc(x = 0:10), main = "Generator Function")
##D    
##D ## ellipticalCopulaSim -
##D ## ellipticalCopulaSim -
##D    # Simualtion and Parameter Fitting:
##D    rv = ellipticalCopulaSim(n = 100, rho = 0.75)
##D    ellipticalCopulaFit(rv)
## End(Not run)  



