### Name: plot.mixEM
### Title: Various Plots Pertaining to Mixture Models
### Aliases: plot.mixEM
### Keywords: file

### ** Examples
 
##Analyzing the Old Faithful geyser data with a 2-component mixture of normals.

data(faithful)
attach(faithful)
out<-normalmixEM(waiting, arbvar = FALSE, verb = TRUE,
                 epsilon = 1e-04)
plot(out, density = TRUE, w = 1.1)

##Fitting randomly generated data with a 2-component location mixture of bivariate normals.

x.1<-rmvnorm(40, c(0, 0))
x.2<-rmvnorm(60, c(3, 4))
X.1<-rbind(x.1, x.2)

out.1<-mvnormalmixEM(X.1, arbvar = FALSE, verb = TRUE,
                     epsilon = 1e-03)
plot(out.1, density = TRUE, alpha = c(0.01, 0.05, 0.10), 
     marginal = TRUE)




