### Name: regmixEM.mixed
### Title: EM Algorithm for Mixtures of Regressions with Random Effects
### Aliases: regmixEM.mixed
### Keywords: file

### ** Examples

## EM output for simulated data from 2-component mixture of random effects.

data(RanEffdata)
x<-lapply(1:length(RanEffdata), function(i) 
          matrix(RanEffdata[[i]][, 2:3], ncol = 2))
x<-x[1:20]
y<-lapply(1:length(RanEffdata), function(i) 
          matrix(RanEffdata[[i]][, 1], ncol = 1))
y<-y[1:20]
lambda<-c(0.45, 0.55)
mu<-matrix(c(0, 4, 100, 12), 2, 2)
sigma<-2
R<-list(diag(1, 2), diag(1, 2))
em.out<-regmixEM.mixed(y, x, sigma = sigma, arb.sigma = FALSE,
                       lambda = lambda, mu = mu, R = R,
                       addintercept.random = FALSE,
                       epsilon = 1e-02, verb = TRUE)
em.out[4:10]




