### Name: att.get.ncdf
### Title: Get attribute from netCDF file
### Aliases: att.get.ncdf
### Keywords: utilities

### ** Examples

# Make a simple netCDF file
filename <- "atttest_types.nc"
dim <- dim.def.ncdf( "X", "inches", 1:12 )
var <- var.def.ncdf( "Data", "unitless", dim, -1 ) 
ncnew <- create.ncdf( filename, var )

# Define some attributes of various types
attvaldbl <- 3.1415926536
att.put.ncdf( ncnew, var, "testatt_dbl", attvaldbl, prec="double" )
attvalsingle <- c(1.0,4.0,9.0,16.0)
att.put.ncdf( ncnew, var, "testatt_single", attvalsingle )
# varid=0 means it is a global attribute
att.put.ncdf( ncnew, 0, "globalatt_int", 32000, prec="int" ) 
att.put.ncdf( ncnew, 0, "globalatt_short", 7, prec="short" )
att.put.ncdf( ncnew, 0, "description", 
        "this is a test file with attributes of various types")
close.ncdf(ncnew)

# Now illustrate the use of the att.get.ncdf function by reading them back in
doitfor <- function( nc, var, attname ) {
        av <- att.get.ncdf( nc, var, attname )
        if( av$hasatt ) {
                print(paste("File",nc$filename,", var",var,"DOES have attribute",
                                attname))
                print(paste("Storage mode:",storage.mode(av$value)))
                print("Attribute value:")
                print(av$value)
        } else {
                print(paste("File",nc$filename,", var",var,"does NOT have",
                        "attribute", attname))
                }
}
        
nc <- open.ncdf( filename )
var <- "Data"
doitfor( nc, var, "testatt_dbl" )
doitfor( nc, var, "testatt_single" )
doitfor( nc, var, "testatt_wacko" )
doitfor( nc, 0,   "globalatt_int" )
doitfor( nc, 0,   "globalatt_short" )
doitfor( nc, 0,   "description" )



