### Name: var.def.ncdf
### Title: Define a netCDF Variable
### Aliases: var.def.ncdf
### Keywords: utilities

### ** Examples

# Define an integer dimension 
dimState <- dim.def.ncdf( "StateNo", "count", 1:50 )

# Make an integer variable.  Note that an integer variable can have
# a double precision dimension, or vice versa; there is no fixed
# relationship between the precision of the dimension and that of the
# associated variable.  We just make an integer variable here for
# illustration purposes.
varPop <- var.def.ncdf("Pop", "count", dimState, -1, 
                longname="Population", prec="integer")

# Create a netCDF file with this variable
ncnew <- create.ncdf( "states_population.nc", varPop )

# Write some values to this variable on disk.
popAlabama <- 4447100
put.var.ncdf( ncnew, varPop, popAlabama, start=1, count=1 )

# Add source info metadata to file
att.put.ncdf( ncnew, 0, "source", "Census 2000 from census bureau web site")

close.ncdf(ncnew)

# Now illustrate some manipulations of the var.ncdf object
filename <- "states_population.nc"
nc <- open.ncdf(filename)
print(paste("File",nc$filename,"contains",nc$nvars,"variables"))
for( i in 1:nc$nvars ) {
        v <- nc$var[[i]]
        print(paste("Here is information on variable number",i))
        print(paste("   Name: ",v$name))
        print(paste("   Units:",v$units))
        print(paste("   Missing value:",v$missval))
        print(paste("   # dimensions :",v$ndims))
        print(paste("   Variable size:",v$varsize))
        }

# Illustrate creating variables of various types.  You will find
# that the type of the missing_value attribute automatically follows
# the type of the variable.
dimt <- dim.def.ncdf( "Time", "days", 1:3 ) 
missval <- -1
varShort <- var.def.ncdf( "varShort", "meters", dimt, missval, prec="short")
varInt   <- var.def.ncdf( "varInt",   "meters", dimt, missval, prec="integer")
varFloat <- var.def.ncdf( "varFloat", "meters", dimt, missval, prec="single")
varDouble<- var.def.ncdf( "varDouble","meters", dimt, missval, prec="double")
nctypes <- create.ncdf("vartypes.nc", list(varShort,varInt,varFloat,varDouble) )
close.ncdf(nctypes)



