### Name: eigen.analysis
### Title: Eigenvalue and eigenvector analysis of a projection matrix
### Aliases: eigen.analysis
### Keywords: survey

### ** Examples


data(whale)
whaleA<-whale$T+whale$F

a<-eigen.analysis(whaleA)

a

ymax<-max(a$repro.value)*1.25
barplot(a$repro.value, col="blue", ylim=c(0,  ymax ), xpd=FALSE, 
       ylab="Reproductive value", xlab="Killer whale stage class")
box()

## display sensitititivies of "impossible" transitions 
## (postreprod -> juvenile, yearling -> mature, etc)
eigen.analysis(whaleA, zero=FALSE)$sensitivities

data(teasel)
teaselA<-teasel$T + teasel$F

a<-eigen.analysis(teaselA)
a
barplot(a$stable.stage, col="green", ylim=c(0,1), 
       ylab="Stable stage proportion", xlab="Teasel stage class")
box()




