### Name: lnorms
### Title: Generate random lognormal values for fertility rates
### Aliases: lnorms
### Keywords: survey

### ** Examples

lnorms(3,1.5,rnorm(1)) 
 # Generate lognormal random fertilities
 # for a population of 1000 mature individuals (Ni) with mean fertility (f) of
 # 3 and inter-individual variance in fertility (varF) of 1.5.
 Ni   <- 1000
 f    <-  3
 varF <-  1.5
 rndfert  <- lnorms(f,varF,rnorm(Ni,0,1))

 hist(rndfert,40, main="Lognormal random fertilities", 
xlab="Fertility rate", col="blue")

## or using rlnorm in stats
# hist(rlnorm(1000, log(3), log(1.5)), 40, xlim=c(0,10), col="blue")

 


