### Name: monkeyflower
### Title: Projection matrices for monkeyflower
### Aliases: monkeyflower
### Keywords: datasets

### ** Examples

data(monkeyflower)
A <- subset(monkeyflower, 
           species=="cardinalis" & site=="Carlon" & year=="pooled",  
           select=c(4:19))
stages<-c("seed", "sm.nr", "lg.nr", "repro")
A <- matrix(unlist(A), nrow=4, byrow=TRUE, dimnames=list(stages, stages) )
A
eigen.analysis(A)
## mean matrix growth rate
eigen.analysis(matrix(apply(monkeyflower[,4:19], 2, mean), nrow=4))$lambda



