stage.vector.plot           package:popbio           R Documentation

_P_l_o_t _s_t_a_g_e _v_e_c_t_o_r _p_r_o_j_e_c_t_i_o_n_s

_D_e_s_c_r_i_p_t_i_o_n:

     Plots short-term dynamics and convergence to stage stage
     distribution using stage vector projections.

_U_s_a_g_e:

     stage.vector.plot(stage.vectors, proportions=TRUE, legend.coords="topright", 
             ylim=NULL, xlab="Years", ylab=NULL, col=rainbow(8),  ... )

_A_r_g_u_m_e_n_t_s:

stage.vectors: a matrix listing stage class vectors in columns

proportions: plot proportional changes or total numbers, defaults to
          proportions. 

legend.coords: a 'legend' keyword or vector of x,y coordinates,
          defaults to top-right corner 

    ylim: the y limits of the plot, defaults to min and max values in
          stage.vector.projections

    xlab: a label for the x axis

    ylab: a label for the y axis

     col: Vector of color names for line drawings.  Default is
          rainbow(8)

     ...: additional options are passed to 'plot' function

_D_e_t_a_i_l_s:

     A plot of stage or age class projections

_A_u_t_h_o_r(_s):

     Chris Stubben

_R_e_f_e_r_e_n_c_e_s:

     see section 2.2 in Caswell 2001

_S_e_e _A_l_s_o:

     see 'pop.projection'

_E_x_a_m_p_l_e_s:

     ## matrix from Example 2.1 in Caswell
     A<-matrix(c(
     0, 0.3,   0,
     1,   0, 0.5,
     5,   0,   0
     ), nrow=3, dimnames=list(1:3,1:3))
     n<-c(1,0,0)
     p<-pop.projection(A,n,60)

     ## Plots in Figure 2.3
     stage.vector.plot(p$stage.vector[,1:15], col='black', las=1, prop=FALSE)
     stage.vector.plot(p$stage.vector[,1:40], col=2:4, las=1)
     stage.vector.plot(p$stage.vector, col=2:4, prop=FALSE,
     ylim=c(.01, 10), log='y', legend="bottomright", yaxt='n')
     axis(2, at=c(.01, 0.1, 1,10), labels=expression(10^-2, 10^-1, 10^0, 10^1), las=1) 

