### Name: qb.sim.cross
### Title: Simulates QTL related data for an F2 or BC cross.
### Aliases: sim.data qb.sim.cross summary.qb.sim
### Keywords: datagen

### ** Examples

## Not run: 
##D ## Simulate large intercross.
##D cross <- qb.sim.cross(len = rep(100,20), n.mar = 11, eq.spacing =FALSE,
##D   n.ind = 500, type = "f2", ordinal = c(0.3,0.3,0.2,0.2),
##D   missing.geno = 0.03, missing.pheno = 0.03,
##D   qtl.pos = rbind(qtl.1=c(chr=1,pos=15),qtl.2=c(1,45),qtl.3=c(3,12),
##D     qtl.4=c(5,15),qtl.5=c(7,15),qtl.6=c(10,15),qtl.7=c(12,35),qtl.8=c(19,15)),
##D   qtl.main = rbind(main.1=c(qtl=1,add=0.5,dom=0),main.2=c(2,0,0.7),
##D     main3=c(3,-0.5,0),main4=c(4,0.5,-0.5)),
##D   qtl.epis = rbind(epis1=c(qtl.a=4,qtl.b=5,aa=-0.7,ad=0,da=0,dd=0),
##D     epis2=c(6,8,0,1.2,0,0)),
##D   covariate = c(fix.cov=0.5,ran.cov=0.07),
##D   gbye = rbind(GxE.1=c(qtl=7,add=0.8,dom=0)) ) 
##D 
##D ## Examine simulation information.
##D summary(cross$qtl)
## End(Not run)

## Simulate small backcross.
cross <- qb.sim.cross(len = rep(60,3), n.mar = 7, eq.spacing =FALSE,
  n.ind = 100, type = "bc", ordinal = c(0.3,0.3,0.2,0.2),
  missing.geno = 0.03, missing.pheno = 0.03,
  qtl.pos = rbind(qtl.1=c(chr=1,pos=15), qtl.2=c(1,45),
                  qtl.3=c(2,12), qtl.4=c(3,15)),
  qtl.main = rbind(main.1=c(qtl=1,add=1.5), main.2=c(2,0),
                   main3=c(3,-1), main4=c(4,0)),
  qtl.epis = rbind(epis1=c(qtl.a=2,qtl.b=3,aa=-2), epis2=c(2,4,3)),
  covariate = c(fix.cov=0.5,ran.cov=0.07),
  gbye = rbind(GxE.1=c(qtl=3,add=2)))
summary(cross$qtl)



