### Name: rob.fitConGraph
### Title: Fitting a concentration graph model based on a robustified
###   method
### Aliases: rob.fitConGraph
### Keywords: robust multivariate

### ** Examples

  require(mvtnorm)
  R <- matrix(c(1.0, 0.8, 0.0,
                0.8, 1.0, 0.0,
                0.0, 0.0, 1.0),
              3, 3)
  # A sample data including five outliers
  df <- as.data.frame(rbind(rmvnorm(95, rep(0, 3), R),
                            rmvnorm(5, rep(1, 3), R)))

  ug <- UG(~a*b*c)
  names(df) <- vertices(ug)

  rob.fitConGraph(ug, 0.3, df)



