### Name: CA
### Title: Stochastic Cellular Automaton
### Aliases: CA
### Keywords: datasets

### ** Examples

    data(CA)
    times(CA)["to"] <- 10
    plot(sim(CA))

    set.seed(345)
    times(CA)["to"] <- 50
    CA <- sim(CA)

    library(lattice)
    tcol <- (terrain.colors(13))[-13]
    x <- out(CA, last=TRUE)
    x <- ifelse(x == 0, NA, x)
    print(levelplot(x,
                 cuts = 11,
                 col.regions = tcol,
                 colorkey=list(at=seq(0,55,5))
    ))



