### Name: analyse.profile
### Title: Analysis of a flow pattern in soil
### Aliases: analyse.profile
### Keywords: spatial

### ** Examples


data("K06")
path <- paste(system.file(package='SoPhy'),"tracer", sep="/")
K06$name <- paste(path, "K06.G.tif", sep="/")
rate <- if (interactive()) c(0.5, 0.8) else c(0.6, 0.67)
ri <- analyse.profile(K06, estimate.all=FALSE, method="fix.m",
                      selected.rate=rate, selected.dist=NULL,
                      Print=2)
cat("estimated risk index =", ri$r.i$risk.index, "\n")



