### Name: read.swms2d.table
### Title: Standard SWMS2D input files
### Aliases: read.swms2d.table
### Keywords: spatial

### ** Examples

##################################################################
##  SWMS2D, Example 1
##################################################################

path <- paste(system.file(package='SoPhy'), 'swms2d', sep="/")
x <- read.swms2d.table(path)
x$TPrint <- seq(10, 5400, 10)
par(cex=1, mar=c(4.2,4,0.2,0.2))

z <- swms2d(x)$hQ[3, , ]
i <- ((length(x$nCodeM$z) / 2):1) * 2 - 1
image(x=c(0, x$TPrint) / 60, y=x$nCodeM$z[i] - max(x$nCodeM$z),
      z=t(z[i, ]), xlab='time [min]', ylab='z [cm]',
      col=grey(seq(1, 0.15, -0.01)), cex.lab=1.5, cex.axis=1.5)

my.legend(0, -max(x$nC$z[i]), zlim=range(z), y.i=0.02,
          col=grey(seq(1,0.15,-0.01)), cex=1.5)



