### Name: simulateHorizons
### Title: Simulation of the stochastic part of the definition of the
###   horizons
### Aliases: simulateHorizons
### Keywords: spatial

### ** Examples

h <- xswms2d(xlim=c(1, 50), ylim=c(1, 50), step=1, new=NULL)
h$n <- 2            ## define a second
h$H2 <- h$H1
h$H2$type <- "H"    ## genuine horizon, not polygon 

## coordinates of the boundary segments between the horizons 
h$H2$points <- list(x=seq(1, 100, 5))             ## x coordinates
h$H2$points$y <- 40 + 20 * cos(h$H2$points$x / 5) ## y coordinates

## Gaussian random field of the second horizon is pure nugget effect:
h$H2$model <- list(model=list(list(model='nugget', var=0.5, scale=1)),
                   mean=0.5)
h$H2$stone$lambda <- 0.005  ## intensity of the stones in the 2nd horizon
h <- calculate.horizons(h)
for (i in 1:2) { 
  plotRF(simulateHorizons(h)) ##
  readline("Press return")
}




