### Name: swms2d
### Title: SWMS2D function call
### Aliases: swms2d SWMS2D
### Keywords: spatial

### ** Examples

##################################################################
##  SWMS2D, Example 1, stochastically modified material properties
##################################################################
# E = exp(mu + 1/2 * sd^2)
# Var = exp(2*mu + sd^2)*(exp(sd^2) - 1)

path <- paste(system.file(package='SoPhy'), 'swms2d', sep="/")
x <- read.swms2d.table(path)
x$TPrint <- 20 * 60
sd <- 0.3 ## then sd of log.gauss is 0.306878
mu <- log(x$nCodeM[, 10]) - 0.5 * sd^2
n <- if (interactive()) 100 else 10 # better 10000
front <- integer(n)

for (j in 1:n) {
  cat(j,"\n")
  x$nCodeM[, 10] <- rlnorm(length(x$nCodeM$z), m = mu, sd = sd)
  x$nCodeM[, 11] <- x$nCodeM[, 10]^(-2)
  z <- swms2d(x)$hQ[3, , ]
  front[j] <- (min(which(z[-1:-2, 2] / z[-1:-2, 1] < 1.005)) %/% 2) + 1
}

idx <- 24 
cat('The probability that the front advances at most', 
    max(x$nCodeM$z) - x$nCodeM$z[2 * idx],'cm is about',
    format(mean(front <= idx), dig=2),'\n')

par(cex=1, mar=c(4.2,4.2,1.2,0.4))
distance <- max(x$nCodeM$z) - x$nCodeM$z[2 * front]
h <- sort(unique(distance))
dh <- min(diff(h) / 2)
hist(distance, freq=FALSE,
     breaks=seq(h[1]-dh, h[length(h)]+dh, 2 * dh),
     main="Histogramm for the depth of the water front",
     xlab="depth", cex.axis=1.5, cex.main=1.2, cex.lab=1.5)




