analyse.profile            package:SoPhy            R Documentation

_A_n_a_l_y_s_i_s _o_f _a _f_l_o_w _p_a_t_t_e_r_n _i_n _s_o_i_l

_D_e_s_c_r_i_p_t_i_o_n:

     The function fits the Pareto distribution to a flow pattern
     obtained from a dye experiment

_U_s_a_g_e:

      analyse.profile(picture, fct, param, lower, upper, loc,
                estimate.all=NULL, selected.dist=0.95, selected.rate=c(0.5, 0.8),
                measure=function(x) x^2, method=c("fix.m","optim.m", "ml"),
                endpoint.tolerance=-10,
                ppi.par = 5,
                ppi.xy = c(xlow=2, xup=2, ylow=2, yup=2),

                interactive=TRUE, PrintLevel=RFparameters()$Print,
                extensions=c("tif", "tiff", "gif", "jpeg"),

                X11.width=13, new=TRUE,
                col.thresh=c("white", "yellow", "black", "blue"),
                col.rect="red", col.bg="yellow", col.sep="gray",
                col.left="red", col.mid="darkgreen", col.right="darkgreen",
                col.line = "red", col.txt="black",
                reverse=TRUE, title
               )

_A_r_g_u_m_e_n_t_s:

 picture: list or array or character. If is a list, then the programme
          expects that the structure is of the output format of
          'analyse.profile'.  Then the parameters 'fct', 'param',
          'upper', 'lower' and 'loc' must be missing, and they are
          taken from the list. The list element 'picture' might be
          missing and is reread from the orginal file. 

          If it is an array, a three dimensional array is expected
          where the third dimension has three or four components (the
          forth component is ignored if any). The array is intepreted
          as RGB-A coded picture.

          If 'picture' is a character string, the function reads in a
          file with name or name base  'picture', see 'read.picture'. 

     fct: threshold function that extracts the stained area from an RGB
          figure. 'fct' has two input variables, the first is a three
          dimensional array, the second is an arbitrary list of _named_
          parameters. Further, the function must return a list of
          standard values of the parameters, if the second parameter is
          missing, independently of value of the first variable.

          If 'fct' is not given, then

          fct <- function(i, p) {
                  if (missing(p)) list(minR=160, maxGB=200)
                  else {
                    gb <- i[,,2] + i[,,3]
                    (gb >= i[,,1] * p$minR / 100 & 80<=gb &
                     p$maxGB>=gb)
                  }
                }

   param: list.  Initial values for the parameter list of the function
          'fct'. If  'param' is not named the names will be
          'parameter1', 'parameter2', etc.  Be sure that the parameter
          names match the names in 'fct'. 

          The values of 'param' are changed in the interactive plot. 
          If 'param' is not given 'param' takes the value returned by
          'fct()'. 

   lower: inital values for the lower bounds of the range of the
          parameters in 'fct'.  The values can be changed in the
          interactive plot.  If not given 'lower' is set to 'param'.

   upper: inital values for the upper bounds of the range of the
          parameters in 'fct'.  The values can be changed in the
          interactive plot.  If not given 'upper' is set to 'param'.

     loc: missing or list or list of lists. If it is a list then it
          must have the the components 'x' and 'y'.  Each of the
          components are vectors of two components containing the x and
          y coordinates of two opposite corners of a rectangle,
          respectively. The rectangle gives the clipping area for which
          the number of stained pixels is calculated.  The values can
          be changed interactively. 

          If 'loc' is missing 'loc' is determined in the interactive
          plot. 

          If 'loc' is a list of lists then it has three components,
          each of which is a list as described above. The first
          component gives the clipping reactangle (that might be
          thought to be best), the other two the minimal and maximal
          tolerable cutting areas. If an edge of the last two rectangle
          agrees with an edge of the best rectangle up to 2 pixels, it
          is assumed that the user wishes that the two edges agree.

          Note that the ideal rectangle is first given by two points
          which are the opposite corners of the rectangle. This
          rectangle and the following ones are changed by giving a
          further point; the programme guesses suitably well which
          corner should be moved into which position. 

          if 'loc' is not given and 'interactive=FALSE' then the whole
          picture is taken. 

estimate.all: 'NULL' or logical. If 'NULL' then nothing is estimated.
          If 'FALSE' only a single risk index according to 'param' is
          estimated; if 'TRUE' the risk index is calculated for a grid
          given by 'lower', 'upper' and the second and third component
          of 'loc'. The marginal number of grid points is 'ppi.par' for
          the components of 'lower' and 'upper' and 'ppi.xy' for the
          definition of the clipping rectangle; see also 'risk.index'

selected.dist: number in (0,1) or a vector of integers.  Distances for
          which the form parameter of the pareto distribution is
          estimated; see 'risk.index'.  If 'selected.dist' is a number
          in (0,1) the distances are '1:(1 + round(max(data[,1]-1) *
          selected.dist))'. 

selected.rate: additionally to the indices given by 'selected.dist',
          the form parameter is estimated also for those distances
          where the corresponding number of observed relative stained
          pixels (w.r.t. to the maximum number of observed pixels) is
          within the interval given by 'selected.rate'.  The risk index
          is calculated as the median of the estimated form parameters.

 measure: instead of the default least squares another distance
          function can be given.

  method: the number of observed paths is a free parameter when fitting
          the Pareto distribution. It can either be set as the maximum
          number of stained pixels for the currently considered
          distances or depths (''fix.m'') or fitted within the
          optimisation algorithm (''optim.m''). Usually, it is not
          worth using the slower ''optim.m'' option. As third new
          option the maximum likelihood method "ml" is available.

endpoint.tolerance: optimisation parameter.  If the shape parameter is
          negative then the distribution has a finite upper endpoint. 
          Hence, mathematically, the lowest upper end point of the
          Pareto distribution is given as the largest distance for
          which at least one stained pixel is observed.  For stability
          reasons and because the observed data might be a scale mixure
          of Pareto distribution it is advantageous to allow for some
          tolerance of the minimal upper end point.

          If 'endpoint.tolerance' is positive then the lower threshold
          for the upper end point is the largest distance for which the
          number of observed stained pixels is larger than
          'endpoint.tolerance'.

          If 'endpoint.tolerance' is negative then the lower threshold
          equals the largest distance for which at least one stained
          pixel is observed minus the modulus of 'endpoint.tolerance'. 

 ppi.par: list or scale. Number of points by which a given parameter
          interval is divided (if the interval is not trivial). The
          points of all intervals (and those for the clipping area)
          build a grid. For each point of the grid, the risk index is
          estimated, if 'estimate.all=TRUE'. 'ppi.par' must be given by
          name (or a single integer is given then the number of grid
          points are the same for each parameter); see also the
          variable 'param'.

          If 'ppi.par' is 'NULL' and 'picture' is a list, the value in
          'picture' is used. 

  ppi.xy: vector of 4 components; number of points by which the
          interval for the positions of the lower, upper, left and
          right edge of the clipping area is divided.

          If 'ppi.xy' is 'NULL' and 'picture' is a list, the value in
          'picture' is used. 

interactive: logical.  If 'TRUE' the user can modify the parameters
          interacitvely.

PrintLevel: numeric.

        <=_0 no messages are printed

        >=_1 the higher the number the more information is given

extensions: accepted extensions for the graphics.  Used if 'picture' is
          a character

X11.width: width of the interactive plot. The height is determined
          automatically.  Only used if 'new=TRUE'

     new: if 'TRUE' a new window for the interactive plot is opened

col.thresh: vector of 4 colour specifications. The components are the
          colours for

             1.  the pixels that are  not considered as stained by the
                current and the preceding parameter choice

             2.  the pixels that are considered as stained by the
                preceding parameter choice, but not by the current one.

             3.  the pixels that are considered as stained by the
                current parameter choice, but not by the preceding one

             4.  the pixels that are considered as stained by the
                current and the preceding parameter choice

          If the values of an interval for a parameter is changed than
          the parameters in 'param' are considered as the the preceding
          parameters. 

col.rect: colour for the interactive menue: colour of a button for free
          input.

  col.bg: colour for the interactive menue: colour of an interactive
          bar

 col.sep: colour for the interactive menue: colour of a separating line

col.left: colour for the interactive menue: colour of a preceding
          element

 col.mid: colour for the interactive menue: colour for a message

col.right: colour for the interactive menue: colour of a subsequent
          element

col.line: colour for the interactive menue: colour of a marking line in
          interactive bars of direct choice.

 col.txt: colour for the interactive menue: colour of headers

 reverse: logical; see details

   title: title for the interactive plot; if not given the picture name
          is used (usually the file name)

_D_e_t_a_i_l_s:

     If the picture is read in from the file the following particular
     case may appear.  In soil profiles often a metal grid is placed of
     size 1m x 1m. This metal grid must be first removed by usingGIMP
     (www.gimp.org), for example, and, in general, also the figure has
     to be rotated. The pixels of the metal bars are removed by coding
     them 255, 255, 255 in RGB code.  To get a reliable estimation of
     the risk index, the number of removed pixels must be the same  for
     each horizontal line in the chosen clipping area, except the
     horizontal line consists of white pixels only that should be
     removed. Now the programme sets each pixel of a horizontal line to
     NA if at least 70% of the pixels of that line are coded 255, 255,
     255.  Otherwise only the white pixels are set to NA. 

     Plotting aspects:

     'reverse=TRUE' is for the plot of soil profiles, where the
     numbering of the y-axis start at the top and is counted positively
     downwards.  

     'reverse=FALSE' The usual presentation of the vertical axis.

     The functions checks whether 'y' is in decreasing or increasing
     order, and plots the y axis accordingly.

_V_a_l_u_e:

     returns a list of the following arguments. Since the arguments do
     not have a fixed order they should be called by name, only. 

 picture: a three dimensional array, containing the RGB-A coding

     fct: see the variable 'fct' above

   param: see the variable 'param' above

   lower: see the variable 'lower' above

   upper: see the variable 'upper' above

     loc: see the variable 'loc' above

 ppi.par: see the variable 'ppi.par' above

  ppi.xy: see the variable 'ppi.xy' above

     r.i: output of 'risk.index' for the ideal parameters

risk.index: array of '2 + length(param)' dimensions containing the
          estimated risk indeces obtained by the sensitivity analysis.
          The latter is based on intervals of values for the edges of
          the clipping area, see 'loc' and 'ppi.xy' and the intervals
          for the parameters, see 'lower', 'upper' and 'ppi.par'.  The
          first two dimensions of 'risk.index' are  for the horizontal
          and vertical variation of the rectangle, the following
          dimensions are for the parameters, given in the order of
          'param'. The number of components in each dimension is given
          by 'ppi.xy' and 'ppi.par' except an interval is trivial. 
          Then the number of components is 1. 

raw.risk.index: same as 'risk.index' except that the raw risk index is
          stored, see the function 'risk.index'.

          The raw risk index is usually not used. 

 absfreq: vector. Number of blue pixels per line (from top) 

_A_u_t_h_o_r(_s):

     Martin Schlather, schlath@hsu-hh.de <URL:
     http://www.unibw-hamburg.de/WWEB/math/schlath/schlather.html>

_R_e_f_e_r_e_n_c_e_s:

     Schlather, M. and Huwe, B. (2005) A risk index for characterising
     flow pattern in soils using dye tracer distributions _Submitted to
     J. Contam. Hydrol._

_S_e_e _A_l_s_o:

     'risk.index', 'SoPhy'

_E_x_a_m_p_l_e_s:

     data("K06")
     path <- paste(system.file(package='SoPhy'),"tracer", sep="/")
     K06$name <- paste(path, "K06.G.tif", sep="/")
     rate <- if (interactive()) c(0.5, 0.8) else c(0.6, 0.67)
     ri <- analyse.profile(K06, estimate.all=FALSE, method="fix.m",
                           selected.rate=rate, selected.dist=NULL,
                           Print=2)
     cat("estimated risk index =", ri$r.i$risk.index, "\n")

