circ.plot             package:CircStats             R Documentation

_C_i_r_c_u_l_a_r _D_a_t_a _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     Creates a plot of circular data points on the current graphics
     device.  Data points are either plotted as points on the unit
     circle, or the range of the circle is divided into a specified
     number of bins, and points are stacked in the bins corresponding
     to the number of observations in each bin.

_U_s_a_g_e:

     circ.plot(x, main="", pch=16, stack=FALSE, bins=0, cex=1, dotsep=40, shrink=1)

_A_r_g_u_m_e_n_t_s:

       x: vector of observations to be plotted, measured in radians.

    main: title of plot.

     pch: point character to use.  See help on par.

   stack: logical flag: if TRUE, points are stacked on the perimeter of
          the circle.  Otherwise, all points are plotted on the
          perimeter of the circle.  Default is FALSE.

    bins: if stack = TRUE, bins is the number of arcs to partition the
          circle with.

     cex: point character size.  See help on par.

  dotsep: constant used to specify the distance between stacked points,
          if stack = TRUE.  Default is 40; larger values will create
          smaller spaces, while smaller values create larger spaces. 
          This option can be useful when pch is other than 1, or when
          shrink is other than 1.

  shrink: parameter that controls the size of the plotted circle. 
          Default is 1.  Larger values shrink the circle, while smaller
          values enlarge the circle.  This option is useful when stack
          = TRUE.

_D_e_t_a_i_l_s:

     When there are many closely distributed observations, stacking is
     recommended.  Otherwise, much information can be lost due to
     overplotting of points.  When stacking the points, if there are
     many points in a particular bin, it may be necessary to shrink the
     plot of the circle so that all points fit.  This is controlled
     with the parameter shrink.  Generally the parameter dotsep does
     not need adjustment, however, when shrinking the plot, or for a
     very large number of observations, it may be helpful.

_N_o_t_e:

     this function use function `eqscplot' from package MASS.

_S_e_e _A_l_s_o:

     rose.diag.

_E_x_a_m_p_l_e_s:

     # Generate 100 observations from a von Mises distribution.
     # with mean direction 0 and concentration 3.
     data.vm <- rvm(100, 0, 3) 
     # Plot data set. All points do not fit on plot.
     circ.plot(data.vm, stack=TRUE, bins=150) 
     # Shrink the plot so that all points fit.
     circ.plot(data.vm, stack=TRUE, bins=150, shrink=1.5) 

