\name{Bt20}
\alias{Bt20}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Effect of DFMO on breast cancer tumors}
\description{
  The data are the result of an experiment, that we will refer to as the
  Bt-20 experiment. The goal of the experiment was to determine whether
  hormone-independent human breast cancer cells growing in nude mice
  manifest sensitivity to the polyamine-biosynthetic inhibitor
  DFMO. Mice bearing established tumors to one of six groups: 0%
  (control), 0.5%, 1%, 2% and 3%. Tumors in each group were measured
  at day 0, 3, 7, 10, 14 and 16.
}
\usage{
data(Bt20)
}
%- maybe also `usage' for other objects documented here.
\format{ A matrix, the first column contains the group ids (which dose),
  the second column contains the animal ids. Columns 3 to 8 contains the
  measurements at the time points 0, 3, 7, 10, 14 and 16, respectively.
}
\source{Daniel F. Heitjan, Andrea Manni and Richard J. Santen.Statistical Analysis of in Vivo Tumor Growth Experiments.
  Cancer Research 1993.53:6042-6050. 
}
\references{
  Daniel F. Heitjan, Andrea Manni and Richard J. Santen.Statistical Analysis of in Vivo Tumor Growth Experiments.
  Cancer Research 1993.53:6042-6050.
   }
  
\keyword{datasets}\eof
\name{REAR}
\alias{REAR}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Fit a autoregressive model with random errors}
\description{This function fits two different models using the nlme
  library and then compares them using a likelihood ratio test. The first
  model is an autoregressive random errors model with a linear mean
  assuming different slope in each group. The second
  model is an autoregressive random errors model with a linear mean
  assuming same slope in each group. 
  
}
\usage{
REAR(data,time)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{The data matrix or data frame, where the first column
    correspond to the group id, the second to the animal id, the
    remaining columns are the measurement at each time. }
  \item{time}{A vector of numeric values corresponding to the time
    points at which the measurements were effectued.}
}
\details{
 The data are reshaped in a longitudinal dataset and then the models are
 fit using the lme function of the nlme library.
}
\value{
   \item{Chi}{The value of the Chisquare test used to  test the hypothesis
    of equal slopes}
  \item{df}{The degrees of freedom for the Chisquare test}
  \item{p}{The p-value associated to the Chisquare test}
  \item{sum.fit.full}{The summary on the fit of the full model}
  \item{std.fit.reduced}{The summary on the fit of the reduced model}
 
}
\references{Daniel F. Heitjan, Andrea Manni and Richard J. Santen
  Statistical Analysis of in Vivo Tumor Growth Experiments
  Cancer Research 53:6042-6050, 1993.}
\author{Raphael Gottardo}


\examples{
data(Bt20)
REAR(Bt20,c(0,3,7,10,14,16))
}
\keyword{ts}
\keyword{multivariate}\eof
\name{ano.difference}
\alias{ano.difference}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Performs a simple anova on a vector of measurement (or differences).}
\description{
This function is a particular case of the manova.growth, the manova
reduces to an ANOVA when the matrix of measurement is a vector. If an
initial time is specified (see initial), the anova is performed on the
differences and rates of growth might be computed.
}
\usage{
ano.difference(data, initial=NULL, final="last", C=NULL, U=NULL, normal=TRUE, B=100, rate=TRUE,time=NULL)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{The data matrix or data frame, where the first column
    correspond to the group ids, the second to the animal ids, the
    remaining columns are the measurements at each time. }
  \item{initial}{An integer corresponding to the index of the initial time. If
    \code{initial} is specified, the anova is performed on the
    differences. Otherwise only the 'final' measurements are used.}
  \item{final}{ An integer corresponding to the index of the final time. By
    default \code{final} is equal to "last" which correspond to the last
  measurement.}
  \item{C}{The left contrast matrix. Default to the matrix to test equal
  means in each group.}
  \item{U}{The right contrast matrix. Default to the identity. }
  \item{normal}{ A logical value, if \code{normal} is true the standard
    deviations of the rates are computed based on normal assumption of
    the measurements, otherwise computed by bootstraping. Default to TRUE.}
  \item{B}{A numeric value, the number of bootstraps. Only used if
    \code{normal} is FALSE. }
  \item{rate}{A logical  value, if TRUE,  the rates are computed. Default
    to TRUE. The rate can not be computed if \code{initial} is not
    specified. }
  \item{time}{A vector of numeric values corresponding to the time
    points at which the measurements were effectued. Time is absolutely required.}
  
  
}

\value{
  \item{Ftest}{The value of the F-test used to  test the hypothesis
    based on C and U.}
  \item{df1}{The numerator degrees of freedom for the F-test}
  \item{df2}{The denominator degrees of freedom for the F-test}
  \item{p}{The p-value associated to the F-test}
  \item{mean}{The estimate of the mean}
  \item{std.mean}{The standard deviation associated to the mean}
  \item{rate}{The rate of growth. Set to NULL if \code{rate} is FALSE}
  \item{std.rate}{The standard deviation of the rates. Set to NULL if \code{rate} is FALSE}
}
\author{Raphael Gottardo}


\seealso{ \code{\link{manova.growth}},\code{\link{growth.curve}}}

\examples{
data(Bt20)
ano.difference(Bt20, initial=1, final="last", C=NULL, U=NULL, normal=TRUE, rate=TRUE,time=c(0,3,7,10,14,16))
}

\keyword{univar}
\eof
\name{design.matrix}
\alias{design.matrix}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Create the design matrix associated to the data. }
\description{}
\usage{
design.matrix(factors)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{factors}{The vector (first column of the data) of group ids.}
}
\value{The design matrix X.
}
\author{Raphael Gottardo}

\examples{
data(Bt20)
### Remove the missing values (if any)
Bt20<-remove.NA(Bt20)
X<-design.matrix(Bt20[,1])
}
\keyword{htest}\eof
\name{graph.curve}
\alias{graph.curve}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Graph the medians tumor volumes at each time point and for each group.}
\description{
  Estimate the growth curve for each group. All curves are graphed on
  the same figure.
}
\usage{
graph.curve(data, time, legend=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{ The data matrix or data frame, where the first column
    correspond to the group ids, the second to the animal ids, the
    remaining columns are the measurements at each time.}
  \item{time}{A vector of numeric values corresponding to the time
    points at which the measurements were effectued.}
  \item{legend}{A logical  value, if TRUE legends using the group
    ids, are added to the graph.}
}
\value{
  The graph added to the current plotting device.
}
\author{Raphael Gottardo}

\examples{
data(Bt20)
graph.curve(Bt20, c(0,3,7,10,14,16), legend=TRUE)
}
\keyword{multivariate}
\eof
\name{growth.curve}
\alias{growth.curve}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Perform an anova on slopes.}
\description{
  This function is particular a case of the manova.growth, the manova
  reduces to an ANOVA when the a particular growth curve is linear.
}
\usage{
growth.curve(data, C=NULL, U=NULL, normal=TRUE, B=1000, time=NULL)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{ The data matrix or data frame, where the first column
    correspond to the group ids, the second to the animal ids, the
    remaining columns are the measurements at each time. }
  \item{C}{ The left contrast matrix. Default to test same rate of growth in each group.}
  \item{U}{ The right contrast matrix. Default to test same rate of growth in each group.}
  \item{normal}{A logical value, if \code{normal} is true the standard
    deviations of the rates are computed based on normal assumption of
    the measurements, otherwise computed by bootstraping. Default to TRUE.}
  \item{B}{A numeric value, the number of bootstraps. Only used if
    \code{normal} is FALSE. }
  \item{time}{A vector of numeric values corresponding to the time
    points at which the measurements were effectued. \code{Time} is absolutely required.}
}
\details{ In this function, we assume that the mean is of the form
  A+B*t. Where A, B are estimated . Therefore the mean is just a function
  (matrix multiplication ) of the rates.
  }
\value{
  \item{Ftest}{The value of the F-test used to  test the hypothesis
    based on C and U.}
  \item{df1}{The numerator degrees of freedom for the F-test}
  \item{df2}{The denominator degrees of freedom for the F-test}
  \item{p}{The p-value associated to the F-test}
  \item{mean}{The estimate of the mean}
  \item{std.mean}{The standard deviation associated to the mean}
  \item{rate}{The rate of growth. Set to NULL if \code{rate} is FALSE}
  \item{std.rate}{The standard deviation of the rates. Set to NULL if \code{rate} is FALSE}
}
\references{Daniel F. Heitjan, Andrea Manni and Richard J. Santen
  Statistical Analysis of in Vivo Tumor Growth Experiments
  Cancer Research 53:6042-6050, 1993.}
\author{Raphael Gottardo}

\seealso{ \code{\link{manova.growth}}}

\examples{
data(Bt20)
growth.curve(Bt20, C=NULL, U=NULL, normal=TRUE, time=c(0,3,7,10,14,16))
}
\keyword{multivariate}
\eof
\name{hotelling.trace}
\alias{hotelling.trace}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Compute the hotteling trace statistics.}
\description{
 The trace statistic is computed by matrix multiplication. It depends
 on the contrast matrices, the design matrix and the observations.
}
\usage{
hotelling.trace(X, Y, C, U)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{X}{The design matrix.}
  \item{Y}{The matrix of observations.}
  \item{C}{ The left contrast matrix.}
  \item{U}{The right contrast matrix. }
}
\value{The hotelling trace statistic.
}
\references{
  \item{1}{Steven F. Arnold.The Theory of Linear Models and Multivariate Analysis.
    John Wiley \& Sons.New York, 1981. }
  
  \item{2}{Daniel F. Heitjan, Andrea Manni and Richard J. Santen.Statistical Analysis of in Vivo Tumor Growth Experiments.Cancer Research 1993.53:6042-6050.}
   }
  
  
\author{Raphael Gottardo}

\examples{
data(Bt20)
### Remove the missing values (if any)
Bt20<-remove.NA(Bt20)
###Create the design matrix
X<-design.matrix(Bt20[,1])
###Convert as numeric the measurement
Y<-as.matrix(Bt20[,3:dim(Bt20)[2]])
### Number of groups
p<-dim(X)[2]
### Default contrast matrices
C<-cbind(rep(1,p-1),-diag(p-1))
U<-rbind(rep(1,p),-diag(p))
### Compute the Lawley Hotteling trace statistics
tr<-hotelling.trace(X,Y,C,U)
 }

\keyword{multivariate}
\eof
\name{manova.estimate}
\alias{manova.estimate}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Compute the mean estimates.}
\description{
 A simple matrix multiplication to compute the mean estimate.
}
\usage{
manova.estimate(Y, X)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{Y}{The matrix of obervations.}
  \item{X}{The design matrix.}
}
\value{The matrix of estimates.
}
\references{Steven F. Arnold.The Theory of Linear Models and Multivariate Analysis.
  John Wiley \& Sons.New York, 1981.}
\author{Raphael Gottardo}

\examples{
data(Bt20)
### Remove the missing values (if any)
Bt20<-remove.NA(Bt20)
###Create the design matrix
X<-design.matrix(Bt20[,1])
###Convert as numeric the measurement
Y<-as.matrix(Bt20[,3:dim(Bt20)[2]])
manova.estimate(Y, X)
}
\keyword{multivariate}
\eof
\name{manova.growth}
\alias{manova.growth}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Performs a multivariate analysis of variance for growth curve experiments.}
\description{
  Performs a multivariate analysis of variance for growth curves
  experiments. By default we test the hypothesis of no group*time interactions.
}
\usage{
manova.growth(data, C=NULL, U=NULL, normal=TRUE, B=1000)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{The data matrix or data frame, where the first column
    correspond to the group ids, the second to the animal ids, the
    remaining columns are the measurements at each time. }
  \item{C}{The left contrast matrix.  Default to test no time*group interactions. }
  \item{U}{The right contrast matrix.  Default
    to test no time*group interactions.}
  \item{normal}{A logical value, if \code{normal} if true the standard
    deviations of the rates are computed based on normal assumption of
    the measurements, otherwise computed by bootstraping. Default to TRUE.}
  \item{B}{A numeric value, the number of bootstraps. Only used if
    \code{normal} is FALSE.}
 
}
\value{
   \item{Ftest}{The value of the F-test used to  test the hypothesis
    based on C and U.}
  \item{df1}{The numerator degrees of freedom for the F-test}
  \item{df2}{The denominator degrees of freedom for the F-test}
  \item{p}{The p-value associated to the F-test}
  \item{mean}{The estimate of the mean}
  \item{std.mean}{The standard deviation associated to the mean}
  \item{rate}{The rate of growth. Set to NULL if \code{rate} is FALSE}
  \item{std.rate}{The standard deviation of the rates. Set to NULL if \code{rate} is FALSE}
}
\references{Daniel F. Heitjan, Andrea Manni and Richard J. Santen
  Statistical Analysis of in Vivo Tumor Growth Experiments
  Cancer Research 53:6042-6050, 1993.}
\author{Raphael Gottardo}

\seealso{\code{\link{growth.curve}},  \code{\link{ano.difference}}}

\examples{
data(Bt20)
manova.growth(Bt20, C=NULL, U=NULL, normal=TRUE)
}

\keyword{multivariate}
\eof
\name{remove.NA}
\alias{remove.NA}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Remove the rows with missing values.}
\description{
  If one row of the data matrix contains missing measurements, the row
  is delete.
}
\usage{
remove.NA(data)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{The matrix of measurements}
}
\value{
  The data matrix (missing values removed).
}
\author{Raphael Gottardo}

\examples{
data(Bt20)
remove.NA(Bt20)
}
\keyword{NA}
\eof
\name{resamp.std}
\alias{resamp.std}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Compute the standard deviation by bootstrap.}
\description{
 Bootstrap a new data set from the original data set by keeping the
 general structure of the groups. Then compute the standard deviation
 based on the bootstrap estimates.
}
\usage{
resamp.std(factors, Y, X, B=1000)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{factors}{A vector (character or numeric) containing the group ids.}
  \item{Y}{The matrix of measurements.}
  \item{X}{The design matrix.}
  \item{B}{A numeric value, the number of bootstraps.}
}
\value{The matrix of standard deviation.
}
\author{Raphael Gottardo}

 

\examples{
data(Bt20)
###Create the design matrix
X<-design.matrix(Bt20[,1])
###Convert as numeric the measurement
Y<-as.matrix(Bt20[,3:dim(Bt20)[2]])
### Number of groups
p<-dim(X)[2]
### Compute the standard deviation associated with the mean
std<-resamp.std(Bt20[,1],Y,X,B=1000)

}

\keyword{multivariate}\eof
\name{reshape.long}
\alias{reshape.long}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Reshape the data set in a longitudinal data set in order to use
  the lme function.}
\description{}

\usage{
reshape.long(data, time)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{ The data matrix or data frame, where the first column
    correspond to the group ids, the second to the animal ids, the
    remaining columns are the measurements at each time. }
  \item{time}{A vector of numeric values corresponding to the time
    points at which the measurements were effectued.}
}
\value{
  The reshaped data.
}

\author{Raphael Gottardo}

\examples{
data(Bt20)
long.data<-reshape.long(Bt20,c(0,3,7,10,14,16))
}
\keyword{multivariate}\eof
